/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.languages.LanguageDTO;
import org.cyclos.model.system.languages.LanguageData;
import org.cyclos.model.system.languages.LanguageDetailedVO;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.system.LanguageService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class LanguageServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<LanguageDTO, Language, LanguageData, Void>
implements LanguageService {
    @Autowired
    private LanguageServiceLocal languageService;

    public LanguageServiceSecurity() {
        super(Language.class);
    }

    @Override
    public boolean doHasViewAccess(Language language) {
        return this.hasPermission(Permission.SYSTEM_CONFIGURATION_VIEW);
    }

    public LanguageDetailedVO get(LanguageVO languageVO) {
        return this.languageService.get(languageVO);
    }

    public LanguageDetailedVO getCurrent() {
        return this.languageService.getCurrent();
    }

    public List<LanguageDetailedVO> list() {
        return this.languageService.list();
    }

    public LanguageDetailedVO resolve(String string) throws FrameworkException {
        return this.languageService.resolve(string);
    }

    @Override
    protected void checkCreateNew(Void void_) {
        this.checkPermission(Permission.SYSTEM_CONFIGURATION_MANAGE);
    }

    @Override
    protected boolean doHasManageAccess(Language language) {
        if (this.languageService.isBuiltin(language)) {
            return false;
        }
        return this.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE);
    }

    protected LanguageServiceLocal getImplementation() {
        return this.languageService;
    }
}

