/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.system;

import java.util.List;
import org.cyclos.entities.system.CustomRecurringTask;
import org.cyclos.impl.system.CustomRecurringTaskServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskDTO;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskData;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskDetailedVO;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskLogQuery;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskLogVO;
import org.cyclos.model.system.scheduledtasks.CustomRecurringTaskVO;
import org.cyclos.security.Security;
import org.cyclos.security.SimpleConfigurationEntityCRUDServiceSecurity;
import org.cyclos.services.system.CustomRecurringTaskService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class CustomRecurringTaskServiceSecurity
extends SimpleConfigurationEntityCRUDServiceSecurity<CustomRecurringTaskDTO, CustomRecurringTask, CustomRecurringTaskData, Void>
implements CustomRecurringTaskService {
    @Autowired
    private CustomRecurringTaskServiceLocal customRecurringTaskService;

    public CustomRecurringTaskServiceSecurity() {
        super(CustomRecurringTask.class, Permission.SYSTEM_CONFIGURATION_VIEW, Permission.SYSTEM_CONFIGURATION_MANAGE);
    }

    public List<CustomRecurringTaskDetailedVO> list() throws FrameworkException {
        this.checkViewPermission();
        return this.customRecurringTaskService.list();
    }

    public void runNow(CustomRecurringTaskVO customRecurringTaskVO) throws FrameworkException {
        this.checkManagePermission();
        this.customRecurringTaskService.runNow(customRecurringTaskVO);
    }

    public Page<CustomRecurringTaskLogVO> searchLogs(CustomRecurringTaskLogQuery customRecurringTaskLogQuery) throws FrameworkException {
        this.checkViewPermission();
        return this.customRecurringTaskService.searchLogs(customRecurringTaskLogQuery);
    }

    protected CustomRecurringTaskServiceLocal getImplementation() {
        return this.customRecurringTaskService;
    }
}

