/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import java.util.List;
import java.util.Properties;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.contentmanagement.TranslationMessage;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.TranslationMessageServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.contentmanagement.translations.ApplicationTranslationData;
import org.cyclos.model.contentmanagement.translations.BasicTranslationKeyDTO;
import org.cyclos.model.contentmanagement.translations.SetCustomizedTranslationsDTO;
import org.cyclos.model.contentmanagement.translations.TranslationKeyDTO;
import org.cyclos.model.contentmanagement.translations.TranslationKeyData;
import org.cyclos.model.contentmanagement.translations.TranslationKeyVO;
import org.cyclos.model.contentmanagement.translations.TranslationQuery;
import org.cyclos.model.system.languages.LanguageDetailedVO;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.system.LanguageServiceSecurity;
import org.cyclos.services.contentmanagement.TranslationMessageService;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TranslationMessageServiceSecurity
extends BaseServiceSecurity
implements TranslationMessageService {
    @Autowired
    private TranslationMessageServiceLocal translationMessageService;
    @Autowired
    private LanguageServiceSecurity languageServiceSecurity;

    public void checkManage(Language language) {
        if (!this.inSameNetwork((NetworkedEntity)language) || !this.hasPermissionToTranslate(language)) {
            throw new PermissionDeniedException();
        }
    }

    public void checkView(Language language) {
        if (!this.inSameNetworkOrGlobal((NetworkedEntity)language) || !this.hasPermissionToTranslate(language)) {
            throw new PermissionDeniedException();
        }
    }

    public ApplicationTranslationData getApplicationTranslationData(LanguageVO languageVO) {
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageVO);
        this.checkView(language);
        return this.translationMessageService.getApplicationTranslationData(languageVO);
    }

    public Properties getCustomizedKeysPerLanguage(LanguageVO languageVO) {
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageVO);
        this.checkView(language);
        return this.translationMessageService.getCustomizedKeysPerLanguage(languageVO);
    }

    public TranslationKeyData getTranslationKeyData(BasicTranslationKeyDTO basicTranslationKeyDTO) throws FrameworkException {
        Language language = null;
        if (basicTranslationKeyDTO.getLanguage() != null) {
            language = (Language)this.conversionHandler.convert(Language.class, (Object)basicTranslationKeyDTO.getLanguage());
            this.checkView(language);
        }
        TranslationKeyData translationKeyData = this.translationMessageService.getTranslationKeyData(basicTranslationKeyDTO);
        translationKeyData.setEditable(this.hasPermissionToTranslate(language) && this.inSameNetwork((NetworkedEntity)language));
        return translationKeyData;
    }

    public boolean hasPermissionToTranslate(Language language) {
        return this.isGlobalAdmin() && language.getNetwork() == null || this.permission(Permission.APPLICATION_TRANSLATION_ENABLE).value((Object)language).granted();
    }

    public List<LanguageDetailedVO> listTranslatableLanguages() {
        this.checkPermission(Permission.APPLICATION_TRANSLATION_ENABLE);
        return this.translationMessageService.listTranslatableLanguages();
    }

    public void restoreOriginalTranslation(BasicTranslationKeyDTO basicTranslationKeyDTO) throws FrameworkException {
        if (basicTranslationKeyDTO.getLanguage() != null) {
            Language language = (Language)this.conversionHandler.convert(Language.class, (Object)basicTranslationKeyDTO.getLanguage());
            this.checkManage(language);
        }
        this.translationMessageService.restoreOriginalTranslation(basicTranslationKeyDTO);
    }

    public void saveKey(TranslationKeyDTO translationKeyDTO) throws FrameworkException {
        if (translationKeyDTO.getLanguage() != null) {
            Language language = (Language)this.conversionHandler.convert(Language.class, (Object)translationKeyDTO.getLanguage());
            this.checkManage(language);
        }
        this.translationMessageService.saveKey(translationKeyDTO);
    }

    public Page<TranslationKeyVO> searchKeys(TranslationQuery translationQuery) {
        Language language = this.find(Language.class, translationQuery.getLanguageId());
        this.checkView(language);
        return this.translationMessageService.searchKeys(translationQuery);
    }

    public void setCustomizedKeysPerLanguage(SetCustomizedTranslationsDTO setCustomizedTranslationsDTO) throws FrameworkException {
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)setCustomizedTranslationsDTO.getLanguage());
        this.checkManage(language);
        this.translationMessageService.setCustomizedKeysPerLanguage(setCustomizedTranslationsDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<TranslationMessage>(TranslationMessage.class){

            public boolean isVisible(SessionData sessionData, TranslationMessage translationMessage) {
                return TranslationMessageServiceSecurity.this.languageServiceSecurity.isAccessible(sessionData, translationMessage.getLanguage());
            }
        };
    }
}

