/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.contentmanagement;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.contentmanagement.Document;
import org.cyclos.entities.contentmanagement.DocumentCategory;
import org.cyclos.entities.contentmanagement.DynamicDocument;
import org.cyclos.entities.contentmanagement.SharedDocument;
import org.cyclos.entities.contentmanagement.StaticDocument;
import org.cyclos.entities.contentmanagement.UserDocument;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.DocumentServiceLocal;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.contentmanagement.documentcategories.DocumentCategoryVO;
import org.cyclos.model.contentmanagement.documents.DocumentDTO;
import org.cyclos.model.contentmanagement.documents.DocumentData;
import org.cyclos.model.contentmanagement.documents.DocumentDataParams;
import org.cyclos.model.contentmanagement.documents.DocumentNature;
import org.cyclos.model.contentmanagement.documents.DocumentQuery;
import org.cyclos.model.contentmanagement.documents.DocumentRange;
import org.cyclos.model.contentmanagement.documents.DocumentSearchData;
import org.cyclos.model.contentmanagement.documents.DocumentVO;
import org.cyclos.model.contentmanagement.documents.ProcessDynamicDocumentDTO;
import org.cyclos.model.contentmanagement.documents.ProcessDynamicDocumentData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.security.CRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.contentmanagement.DocumentService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class DocumentServiceSecurity
extends CRUDServiceSecurity<DocumentDTO, Document, DocumentData, DocumentDataParams>
implements DocumentService {
    @Autowired
    private DocumentServiceLocal documentService;

    public DocumentServiceSecurity() {
        super(Document.class);
    }

    public boolean applyRestrictions(DocumentQuery documentQuery) {
        boolean bl;
        User user = (User)this.conversionHandler.convert(User.class, (Object)documentQuery.getUser());
        SessionData sessionData = this.getSessionData();
        DocumentRange documentRange = documentQuery.getDocumentRange();
        boolean bl2 = documentRange == null;
        boolean bl3 = documentRange == DocumentRange.SHARED;
        boolean bl4 = bl = documentRange == DocumentRange.INDIVIDUAL;
        if (bl3) {
            user = null;
            documentQuery.setUser(null);
        }
        boolean bl5 = sessionData.hasPermission(Permission.DOCUMENTS_VIEW);
        boolean bl6 = sessionData.hasPermission(Permission.USER_DOCUMENTS_VIEW);
        if (bl3 && !bl5 || bl && !bl6 || !bl5 && !bl6) {
            return false;
        }
        if (sessionData.isBroker()) {
            documentQuery.setEnabled(Boolean.valueOf(true));
        }
        if (bl2 || bl) {
            if (user != null && !sessionData.manages((BasicUser)user)) {
                return false;
            }
            if (sessionData.isBroker()) {
                documentQuery.setBrokers(CollectionHelper.asSet((Object[])new UserVO[]{new UserVO(sessionData.getLoggedUser().getId())}));
            }
            this.groupsHandler.visibles().accessibles().groups().check((Collection)documentQuery.getGroups());
        }
        if (bl2 || bl3) {
            Set set = this.conversionHandler.convertSet(DocumentCategory.class, (Iterable)documentQuery.getCategories());
            List list = this.getSessionData().getProducts().product().getDocumentCategoryView();
            Collection collection = PermissionHelper.checkSelection((Collection)list, (Collection)set, (boolean)true);
            documentQuery.setCategories(this.conversionHandler.convertSet(DocumentCategoryVO.class, (Iterable)collection));
        }
        return true;
    }

    @Override
    public boolean canPerformOperation(Document document, CRUDOperation cRUDOperation) {
        UserDocument userDocument;
        User user;
        if ((cRUDOperation == CRUDOperation.CREATE || cRUDOperation == CRUDOperation.UPDATE) && document instanceof UserDocument && (user = (userDocument = (UserDocument)document).getUser()) != null && user.isRemoved()) {
            return false;
        }
        return super.canPerformOperation(document, cRUDOperation);
    }

    @Override
    public boolean doHasManageAccess(Document document) {
        if (document instanceof UserDocument) {
            UserDocument userDocument = (UserDocument)document;
            User user = userDocument.getUser();
            if (user != null) {
                if (this.getSessionData().isBrokerOf((BasicUser)user) && !userDocument.isBrokerManageable()) {
                    return false;
                }
                return this.permission((BasicUser)user).user(new Permission[]{Permission.USER_DOCUMENTS_MANAGE}).granted();
            }
            return this.permissionOptionalValue(Permission.USER_DOCUMENTS_MANAGE).granted();
        }
        if (document instanceof SharedDocument) {
            return this.permission(Permission.DOCUMENTS_MANAGE).value((Object)((SharedDocument)document).getCategory()).granted();
        }
        return false;
    }

    @Override
    public boolean doHasViewAccess(Document document) {
        if (document instanceof UserDocument) {
            SessionData sessionData;
            UserDocument userDocument = (UserDocument)document;
            User user = userDocument.getUser();
            if (user.equals((Object)(sessionData = this.getSessionData()).getLoggedUser()) && !userDocument.isMemberVisible() || sessionData.isBrokerOf((BasicUser)user) && !userDocument.isBrokerVisible()) {
                return false;
            }
            return this.permissionOptionalValue(user).my(new Permission[]{Permission.MY_INDIVIDUAL_DOCUMENTS_VIEW}).user(new Permission[]{Permission.USER_DOCUMENTS_VIEW}).granted();
        }
        if (document instanceof StaticDocument && ((StaticDocument)document).isPubliclyAccessible()) {
            return true;
        }
        if (document instanceof SharedDocument) {
            SharedDocument sharedDocument = (SharedDocument)document;
            return this.permissionOptionalValue(Permission.MY_SHARED_DOCUMENTS_VIEW).value((Object)sharedDocument.getCategory()).granted() || this.permission(Permission.DOCUMENTS_VIEW).value((Object)sharedDocument.getCategory()).granted();
        }
        return false;
    }

    public DocumentVO getDocument(DocumentVO documentVO) {
        this.checkViewAccess(documentVO);
        return this.documentService.getDocument(documentVO);
    }

    public RawFileVO getDocumentFile(DocumentVO documentVO) {
        this.checkViewAccess(documentVO);
        return this.documentService.getDocumentFile(documentVO);
    }

    public DocumentSearchData getDocumentSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        this.checkViewPermission();
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        if (user != null) {
            this.checkManagesUser((BasicUser)user);
        }
        return this.documentService.getDocumentSearchData(userLocatorVO);
    }

    public ProcessDynamicDocumentData getProcessDynamicDocumentData(DocumentVO documentVO, UserLocatorVO userLocatorVO) {
        this.checkViewAccess(documentVO);
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        this.checkManagesUser((BasicUser)user);
        return this.documentService.getProcessDynamicDocumentData(documentVO, userLocatorVO);
    }

    @Override
    public boolean isAccessible(SessionData sessionData, Document document) {
        return false;
    }

    public List<DocumentVO> listUserDocuments(UserLocatorVO userLocatorVO) {
        this.checkLoggedIn();
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        boolean bl = this.permission((BasicUser)user).my(new Permission[]{Permission.MY_INDIVIDUAL_DOCUMENTS_VIEW}).user(new Permission[]{Permission.USER_DOCUMENTS_VIEW}).granted();
        SessionData sessionData = this.getSessionData();
        boolean bl2 = sessionData.getLoggedUser().equals((Object)user);
        boolean bl3 = sessionData.hasPermission(bl2 ? Permission.MY_SHARED_DOCUMENTS_VIEW : Permission.DOCUMENTS_VIEW);
        if (!bl && !bl3) {
            throw new PermissionDeniedException();
        }
        return this.documentService.listUserDocuments(userLocatorVO);
    }

    public String processDynamicDocument(ProcessDynamicDocumentDTO processDynamicDocumentDTO) throws ValidationException {
        this.checkViewAccess((Document)this.conversionHandler.convert(DynamicDocument.class, (Object)processDynamicDocumentDTO.getDocument()));
        this.checkManagesUser((BasicUser)this.userLocatorHandler.toUserOrCurrent((BasicUserVO)processDynamicDocumentDTO.getUser()));
        return this.documentService.processDynamicDocument(processDynamicDocumentDTO);
    }

    public SerializableInputStream readContent(DocumentVO documentVO) throws EntityNotFoundException {
        this.checkViewAccess(documentVO);
        return this.documentService.readContent(documentVO);
    }

    public void saveFile(DocumentVO documentVO, String string, String string2, SerializableInputStream serializableInputStream) {
        this.checkManageAccess(documentVO);
        this.documentService.saveFile(documentVO, string, string2, serializableInputStream);
    }

    public Long saveWithFile(DocumentDTO documentDTO, String string, String string2, SerializableInputStream serializableInputStream) {
        this.checkSave(documentDTO);
        return this.documentService.saveWithFile(documentDTO, string, string2, serializableInputStream);
    }

    public Page<DocumentVO> search(DocumentQuery documentQuery) {
        if (!this.applyRestrictions(documentQuery)) {
            throw new PermissionDeniedException();
        }
        return this.documentService.search(documentQuery);
    }

    @Override
    protected void checkCreateNew(DocumentDataParams documentDataParams) {
        if (documentDataParams.getNature() == DocumentNature.USER) {
            User user = (User)this.conversionHandler.convert(User.class, (Object)documentDataParams.getUser());
            if (user != null) {
                if (user.isRemoved()) {
                    throw new PermissionDeniedException();
                }
                this.permission((BasicUser)user).user(new Permission[]{Permission.USER_DOCUMENTS_MANAGE}).check();
            } else {
                this.permissionOptionalValue(Permission.USER_DOCUMENTS_MANAGE).check();
            }
        } else {
            DocumentCategory documentCategory = (DocumentCategory)this.conversionHandler.convert(DocumentCategory.class, (Object)documentDataParams.getCategory());
            if (documentCategory != null) {
                this.permission(Permission.DOCUMENTS_MANAGE).value((Object)documentCategory).check();
            } else {
                this.permissionOptionalValue(Permission.DOCUMENTS_MANAGE).check();
            }
        }
    }

    protected DocumentServiceLocal getImplementation() {
        return this.documentService;
    }

    @Override
    private void checkManageAccess(DocumentVO documentVO) {
        Document document = (Document)this.conversionHandler.convert(Document.class, (Object)documentVO);
        if (!this.hasManageAccess(document)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    private void checkViewAccess(DocumentVO documentVO) {
        Document document = (Document)this.conversionHandler.convert(Document.class, (Object)documentVO);
        if (!this.hasViewAccess(document)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkViewPermission() {
        if (!this.getSessionData().hasPermission(new Permission[]{Permission.DOCUMENTS_VIEW, Permission.USER_DOCUMENTS_VIEW})) {
            throw new PermissionDeniedException();
        }
    }
}

