/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.List;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.impl.CRUDServiceLocal;
import org.cyclos.impl.banking.VoucherTypeServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.banking.vouchertypes.VoucherTypeDTO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeData;
import org.cyclos.model.banking.vouchertypes.VoucherTypeListData;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.security.ConfigurationEntityCRUDServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.VoucherConfigurationServiceSecurity;
import org.cyclos.services.banking.VoucherTypeService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class VoucherTypeServiceSecurity
extends ConfigurationEntityCRUDServiceSecurity<VoucherTypeDTO, VoucherType, VoucherTypeData, ConfigurationVO>
implements VoucherTypeService {
    @Autowired
    private VoucherTypeServiceLocal voucherTypeService;
    @Autowired
    private VoucherConfigurationServiceSecurity voucherConfigurationServiceSecurity;

    public VoucherTypeServiceSecurity() {
        super(VoucherType.class);
    }

    @Override
    public boolean doHasViewAccess(VoucherType voucherType) {
        return this.hasView(voucherType.getConfiguration());
    }

    public VoucherTypeListData getListData() throws FrameworkException {
        this.checkPermission(Permission.VOUCHER_TYPES_VIEW);
        return this.voucherTypeService.getListData();
    }

    public List<VoucherTypeVO> list() throws FrameworkException {
        this.checkPermission(Permission.VOUCHER_TYPES_VIEW);
        return this.voucherTypeService.list();
    }

    @Override
    protected void checkCreateNew(ConfigurationVO configurationVO) {
        VoucherConfiguration voucherConfiguration = (VoucherConfiguration)this.conversionHandler.convert(VoucherConfiguration.class, (Object)configurationVO);
        if (!this.hasManage(voucherConfiguration)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    protected void customizeData(VoucherTypeData voucherTypeData) {
        VoucherTypeDTO voucherTypeDTO = (VoucherTypeDTO)voucherTypeData.getDto();
        if (voucherTypeDTO.isPersistent()) {
            VoucherType voucherType = (VoucherType)this.find(voucherTypeDTO.getId());
            voucherTypeData.setCanGenerateVouchers(this.voucherConfigurationServiceSecurity.canGenerateVouchers(voucherType.getConfiguration()));
        }
    }

    @Override
    protected boolean doHasManageAccess(VoucherType voucherType) {
        return this.hasManage(voucherType.getConfiguration());
    }

    @Override
    protected CRUDServiceLocal<VoucherType, VoucherTypeDTO, VoucherTypeData, ConfigurationVO> getImplementation() {
        return this.voucherTypeService;
    }

    private boolean hasManage(VoucherConfiguration voucherConfiguration) {
        return this.permission(Permission.VOUCHER_TYPES_MANAGE).value((Object)voucherConfiguration).granted();
    }

    private boolean hasView(VoucherConfiguration voucherConfiguration) {
        return this.permission(Permission.VOUCHER_TYPES_VIEW).value((Object)voucherConfiguration).granted();
    }
}

