/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.List;
import org.cyclos.entities.banking.VoucherCustomField;
import org.cyclos.entities.banking.VoucherCustomFieldPossibleValue;
import org.cyclos.entities.banking.VoucherCustomFieldPossibleValueCategory;
import org.cyclos.impl.banking.VoucherCustomFieldServiceLocal;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.voucherfields.VoucherCustomFieldDTO;
import org.cyclos.model.banking.voucherfields.VoucherCustomFieldData;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.Security;
import org.cyclos.security.system.BaseSimpleCustomFieldServiceSecurity;
import org.cyclos.services.banking.VoucherCustomFieldService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class VoucherCustomFieldServiceSecurity
extends BaseSimpleCustomFieldServiceSecurity<VoucherCustomFieldDTO, VoucherCustomField, VoucherCustomFieldPossibleValueCategory, VoucherCustomFieldPossibleValue, VoucherCustomFieldData, Void>
implements VoucherCustomFieldService {
    @Autowired
    private VoucherCustomFieldServiceLocal transferCustomFieldService;

    public VoucherCustomFieldServiceSecurity() {
        super(VoucherCustomField.class, Permission.ACCOUNT_CONFIGURATION_VIEW, Permission.ACCOUNT_CONFIGURATION_MANAGE);
    }

    public void addRelation(VoucherTypeVO voucherTypeVO, CustomFieldVO customFieldVO) throws EntityNotFoundException {
        this.checkManagePermission();
        this.transferCustomFieldService.addRelation(voucherTypeVO, customFieldVO);
    }

    public List<CustomFieldVO> list() {
        this.checkViewPermission();
        return this.transferCustomFieldService.list();
    }

    public List<CustomFieldVO> listAllRelated(VoucherTypeVO voucherTypeVO) throws FrameworkException {
        this.checkViewPermission();
        return this.transferCustomFieldService.listAllRelated(voucherTypeVO);
    }

    public List<CustomFieldVO> listRelated(VoucherTypeVO voucherTypeVO, UserVO userVO) throws EntityNotFoundException {
        this.checkViewPermission();
        return this.transferCustomFieldService.listRelated(voucherTypeVO, userVO);
    }

    public void removeRelation(VoucherTypeVO voucherTypeVO, CustomFieldVO customFieldVO) throws EntityNotFoundException {
        this.checkManagePermission();
        this.transferCustomFieldService.removeRelation(voucherTypeVO, customFieldVO);
    }

    protected VoucherCustomFieldServiceLocal getImplementation() {
        return this.transferCustomFieldService;
    }
}

