/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.Set;
import org.cyclos.entities.banking.UserAccountVisibilitySettings;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.UserPermissionCheck;
import org.cyclos.impl.banking.UserAccountVisibilitySettingsServiceLocal;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.accounts.UserAccountVisibilitySettingsData;
import org.cyclos.model.banking.accounttypes.UserAccountTypeVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.services.banking.UserAccountVisibilitySettingsService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class UserAccountVisibilitySettingsServiceSecurity
extends BaseServiceSecurity
implements UserAccountVisibilitySettingsService {
    @Autowired
    private UserAccountVisibilitySettingsServiceLocal userAccountVisibilitySettingsService;

    public UserAccountVisibilitySettingsData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        this.viewCheck(basicUser).check();
        UserAccountVisibilitySettingsData userAccountVisibilitySettingsData = this.userAccountVisibilitySettingsService.getData(userLocatorVO);
        userAccountVisibilitySettingsData.setEditable(this.manageCheck(basicUser).granted());
        return userAccountVisibilitySettingsData;
    }

    public void save(UserLocatorVO userLocatorVO, Set<UserAccountTypeVO> set) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        this.manageCheck(basicUser).check();
        this.userAccountVisibilitySettingsService.save(userLocatorVO, set);
    }

    public void setAsVisible(UserLocatorVO userLocatorVO, UserAccountTypeVO userAccountTypeVO, boolean bl) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        this.manageCheck(basicUser).check();
        this.userAccountVisibilitySettingsService.setAsVisible(userLocatorVO, userAccountTypeVO, bl);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<UserAccountVisibilitySettings>(UserAccountVisibilitySettings.class){

            public boolean isVisible(SessionData sessionData, UserAccountVisibilitySettings userAccountVisibilitySettings) {
                return UserAccountVisibilitySettingsServiceSecurity.this.viewCheck(userAccountVisibilitySettings.getUser()).granted();
            }
        };
    }

    private UserPermissionCheck manageCheck(BasicUser basicUser) {
        return this.permission(basicUser).my(new Permission[]{Permission.MY_ACCOUNT_VISIBILITY_ENABLE}).user(new Permission[]{Permission.USER_ACCOUNT_VISIBILITY_MANAGE});
    }

    private UserPermissionCheck viewCheck(BasicUser basicUser) {
        return this.permission(basicUser).my(new Permission[]{Permission.MY_ACCOUNT_VISIBILITY_ENABLE}).user(new Permission[]{Permission.USER_ACCOUNT_VISIBILITY_VIEW});
    }
}

