/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import com.querydsl.core.types.Path;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.access.OidcClientAccessor;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.RecurringPaymentOccurrence;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.QAdminProductAuthorizationRole;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.BaseEntityCheck;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.OidcClientServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.UserPermissionCheck;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentTransferTypeQuery;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.users.OperatorGroupServiceLocal;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.BaseInstallmentQuery;
import org.cyclos.model.banking.transactions.BasePaymentData;
import org.cyclos.model.banking.transactions.BaseTransactionQuery;
import org.cyclos.model.banking.transactions.CalculateInstallmentsDTO;
import org.cyclos.model.banking.transactions.ExternalPaymentData;
import org.cyclos.model.banking.transactions.IInstallmentSearchData;
import org.cyclos.model.banking.transactions.ITransactionSearchData;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.InstallmentOverviewQuery;
import org.cyclos.model.banking.transactions.InstallmentOverviewSearchData;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentResultVO;
import org.cyclos.model.banking.transactions.InstallmentSearchData;
import org.cyclos.model.banking.transactions.MaturityTableItemData;
import org.cyclos.model.banking.transactions.MaturityTableQuery;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PaymentData;
import org.cyclos.model.banking.transactions.PaymentRequestData;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformPaymentData;
import org.cyclos.model.banking.transactions.PerformPaymentToOwnerData;
import org.cyclos.model.banking.transactions.PerformPaymentTypeData;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.ReceivePaymentData;
import org.cyclos.model.banking.transactions.ReceivePaymentFromUserData;
import org.cyclos.model.banking.transactions.RecurringPaymentData;
import org.cyclos.model.banking.transactions.ScheduledPaymentData;
import org.cyclos.model.banking.transactions.TicketData;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionOverviewSearchData;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transactions.TransactionSearchData;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transfertypes.TransferTypeDirection;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.vouchers.VoucherVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.OperatorGroupAccountAccess;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.security.banking.ExternalPaymentServiceSecurity;
import org.cyclos.security.banking.PaymentRequestServiceSecurity;
import org.cyclos.security.banking.PaymentServiceSecurity;
import org.cyclos.security.banking.RecurringPaymentServiceSecurity;
import org.cyclos.security.banking.ScheduledPaymentServiceSecurity;
import org.cyclos.security.banking.TicketServiceSecurity;
import org.cyclos.security.banking.TransactionAuthorizationServiceSecurity;
import org.cyclos.security.banking.TransferServiceSecurity;
import org.cyclos.security.banking.VoucherServiceSecurity;
import org.cyclos.security.users.TransactionFeedbackServiceSecurity;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TransactionServiceSecurity
extends BaseServiceSecurity
implements TransactionService {
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private TransferServiceSecurity transferServiceSecurity;
    @Autowired
    private PaymentServiceSecurity paymentServiceSecurity;
    @Autowired
    private TicketServiceSecurity ticketServiceSecurity;
    @Autowired
    private RecurringPaymentServiceSecurity recurringPaymentServiceSecurity;
    @Autowired
    private TransactionAuthorizationServiceSecurity transactionAuthorizationServiceSecurity;
    @Autowired
    private ExternalPaymentServiceSecurity externalPaymentServiceSecurity;
    @Autowired
    private PaymentRequestServiceSecurity paymentRequestServiceSecurity;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;
    @Autowired
    private ScheduledPaymentServiceSecurity scheduledPaymentServiceSecurity;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private OperatorGroupServiceLocal operatorGroupService;
    @Autowired
    private TransactionFeedbackServiceSecurity transactionFeedbackServiceSecurity;
    @Autowired
    private VoucherServiceSecurity voucherServiceSecurity;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    private Map<TransactionNature, NaturePermissions> naturePermissions;
    @Autowired
    private AccountTypeServiceLocal accountTypeService;
    @Autowired
    private OidcClientServiceLocal oidcClientService;

    public void check(LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2) throws ValidationException, PermissionDeniedException {
        this.check(locateAccountOwnerResult, locateAccountOwnerResult2, (TransferType)((PaymentTransferType)null));
    }

    public void check(LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, TransferType transferType) throws ValidationException, PermissionDeniedException {
        this.doCheck(locateAccountOwnerResult, locateAccountOwnerResult2, transferType, true);
    }

    public void check(PerformInternalTransactionDTO performInternalTransactionDTO) throws ValidationException, PermissionDeniedException {
        this.check(this.accountHandler.locateOrCurrent((AccountOwner)performInternalTransactionDTO.getOwner()), this.transactionService.locateForPayment(performInternalTransactionDTO.getSubject()), (TransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performInternalTransactionDTO.getType()));
    }

    public void checkBaseTransactionQuery(BaseTransactionQuery baseTransactionQuery) {
        this.accountServiceSecurity.checkTransQuery((AbstractTransQuery)baseTransactionQuery);
    }

    public void checkIgnoringSessionData(LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, TransferType transferType) {
        this.doCheck(locateAccountOwnerResult, locateAccountOwnerResult2, transferType, false);
    }

    public void checkPaymentParameters(LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, PaymentCreationType paymentCreationType, PaymentTransferType paymentTransferType) {
        boolean bl;
        InternalAccountOwner internalAccountOwner = locateAccountOwnerResult.getInternalAccountOwner();
        InternalAccountOwner internalAccountOwner2 = locateAccountOwnerResult2.getInternalAccountOwner();
        this.accountService.checkActive((AccountOwner)internalAccountOwner);
        this.accountService.checkActive((AccountOwner)internalAccountOwner2);
        SessionData sessionData = this.getSessionData();
        User user = null;
        boolean bl2 = bl = locateAccountOwnerResult.isUser() && !locateAccountOwnerResult.getAccountOwner().equals((Object)sessionData.getLoggedUser());
        if (bl) {
            user = locateAccountOwnerResult.getUser();
        }
        if (bl && !user.isMember()) {
            throw new ValidationException(this.message(GeneralKeys.Errors.INVALID, BankingKeys.Accounts.OWNER));
        }
        if (paymentTransferType == null || !paymentTransferType.isEnabled()) {
            throw new ValidationException(this.message(GeneralKeys.Errors.REQUIRED, BankingKeys.Transactions.TYPE));
        }
        TransferTypeDirection transferTypeDirection = this.transferTypeService.resolveDirection(internalAccountOwner, (AccountOwner)internalAccountOwner2);
        if (paymentTransferType.getDirection() != transferTypeDirection) {
            throw new ValidationException(this.message(GeneralKeys.Errors.INVALID, BankingKeys.Transactions.TYPE));
        }
        if (!sessionData.isScript() && !sessionData.isSystem()) {
            AccountType accountType;
            InternalAccountOwner internalAccountOwner3;
            boolean bl3;
            PaymentTransferTypeQuery paymentTransferTypeQuery = new PaymentTransferTypeQuery();
            paymentTransferTypeQuery.setFromOwner(internalAccountOwner);
            paymentTransferTypeQuery.setToOwner((AccountOwner)internalAccountOwner2);
            paymentTransferTypeQuery.setPossibleTransferTypes(Collections.singleton(paymentTransferType));
            boolean bl4 = bl3 = (Integer)this.transactionService.countPaymentTypes(paymentCreationType, paymentTransferTypeQuery).getFirst() > 0;
            if (paymentCreationType.isCheckToOwner()) {
                internalAccountOwner3 = internalAccountOwner2;
                accountType = paymentTransferType.getTo();
            } else {
                internalAccountOwner3 = internalAccountOwner;
                accountType = paymentTransferType.getFrom();
            }
            if (!bl3 || !this.accountServiceSecurity.hasAccess(internalAccountOwner3, accountType)) {
                throw new ValidationException(this.message(BankingKeys.Transactions.PAYMENT_NO_PAYMENT_TYPES, new Object[0]));
            }
        }
    }

    public PaymentTransferType checkPerform(CalculateInstallmentsDTO calculateInstallmentsDTO) {
        return this.checkPerform((InternalAccountOwner)calculateInstallmentsDTO.getOwner(), (InternalAccountOwner)calculateInstallmentsDTO.getSubject(), (CurrencyVO)calculateInstallmentsDTO.getCurrency(), (TransferTypeVO)calculateInstallmentsDTO.getType()).type;
    }

    public PaymentTransferType checkPerform(PerformInternalTransactionDTO performInternalTransactionDTO) {
        OidcAuthorization oidcAuthorization;
        CheckResult checkResult = this.checkPerform(performInternalTransactionDTO.getOwner(), performInternalTransactionDTO.getSubject(), performInternalTransactionDTO.getCurrency(), performInternalTransactionDTO.getType());
        SessionData sessionData = this.getSessionData();
        OidcAccessToken oidcAccessToken = sessionData.getAccessToken();
        if (oidcAccessToken != null) {
            oidcAuthorization = oidcAccessToken.getAuthorization();
            if (!(oidcAuthorization.getPaymentTo() == null && oidcAuthorization.getPaymentAmount() == null || performInternalTransactionDTO instanceof PerformPaymentDTO)) {
                throw new PermissionDeniedException("The authorized client can only perform a specific payment, but got a " + performInternalTransactionDTO.getClass().getSimpleName());
            }
            if (oidcAuthorization.getPaymentTo() != null && !oidcAuthorization.getPaymentTo().equals((Object)checkResult.to.getUser())) {
                throw new ValidationException(PerformInternalTransactionDTO.SUBJECT.getName(), this.message(GeneralKeys.Errors.INVALID, BankingKeys.Accounts.TO));
            }
            if (oidcAuthorization.getPaymentAmount() != null && !BigDecimalHelper.areEquals((BigDecimal)oidcAuthorization.getPaymentAmount(), (BigDecimal)performInternalTransactionDTO.getAmount())) {
                throw new ValidationException(PerformInternalTransactionDTO.AMOUNT.getName(), this.message(GeneralKeys.Errors.INVALID, BankingKeys.Transactions.AMOUNT));
            }
            if (oidcAuthorization.getPaymentCurrency() != null && !oidcAuthorization.getPaymentCurrency().equals((Object)checkResult.type.getCurrency())) {
                throw new ValidationException(PerformInternalTransactionDTO.CURRENCY.getName(), this.message(GeneralKeys.Errors.INVALID, BankingKeys.Accounts.CURRENCY));
            }
            OidcClientAccessor oidcClientAccessor = this.oidcClientService.getAccessor(oidcAccessToken.getAuthorization().getClient());
            if (!oidcClientAccessor.getPayments().contains(checkResult.type)) {
                throw new ValidationException(PerformInternalTransactionDTO.TYPE.getName(), this.message(GeneralKeys.Errors.INVALID, BankingKeys.Transactions.TYPE));
            }
        }
        oidcAuthorization = checkResult.type;
        return oidcAuthorization;
    }

    public void checkQuery(BaseTransactionQuery baseTransactionQuery) {
        User user;
        Object object;
        InternalAccountOwner internalAccountOwner = null;
        if (baseTransactionQuery instanceof TransactionQuery) {
            object = (TransactionQuery)baseTransactionQuery;
            LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)object.getOwner(), true);
            if (locateAccountOwnerResult.isSystem()) {
                this.checkPermission(Permission.SYSTEM_ACCOUNTS_VIEW);
            } else if (locateAccountOwnerResult.isUser()) {
                user = locateAccountOwnerResult.getUser();
                SessionData sessionData = this.getSessionData();
                if (sessionData.isManagerOf((BasicUser)user)) {
                    this.checkPermission(Permission.USER_ACCOUNTS_VIEW);
                } else if (!user.equals((Object)sessionData.getLoggedUser())) {
                    throw new PermissionDeniedException();
                }
            }
            internalAccountOwner = locateAccountOwnerResult.getInternalAccountOwner();
            object.setOwner(internalAccountOwner);
        }
        object = baseTransactionQuery.getAuthorizationStatuses();
        boolean bl = this.transactionAuthorizationServiceSecurity.hasViewPermission(internalAccountOwner);
        if (!(!CollectionHelper.isNotEmpty((Iterable)object) || bl || object.size() == 1 && object.contains(TransactionAuthorizationStatus.AUTHORIZED))) {
            throw new PermissionDeniedException();
        }
        user = this.getVisibleNatures(internalAccountOwner);
        PermissionHelper.checkSelection((Collection)user, (Collection)baseTransactionQuery.getNatures());
        this.checkBaseTransactionQuery(baseTransactionQuery);
    }

    public PaymentTransferType checkReceive(CalculateInstallmentsDTO calculateInstallmentsDTO) {
        PaymentTransferType paymentTransferType = this.checkReceive(calculateInstallmentsDTO.getOwner(), calculateInstallmentsDTO.getCurrency(), calculateInstallmentsDTO.getType());
        calculateInstallmentsDTO.setSubject((InternalAccountOwner)this.getLoggedUser());
        return paymentTransferType;
    }

    public PaymentTransferType checkReceive(PerformInternalTransactionDTO performInternalTransactionDTO) {
        PaymentTransferType paymentTransferType = this.checkReceive(performInternalTransactionDTO.getOwner(), performInternalTransactionDTO.getCurrency(), performInternalTransactionDTO.getType());
        performInternalTransactionDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
        performInternalTransactionDTO.setSubject((InternalAccountOwner)new UserVO(this.getLoggedUser().getId()));
        return paymentTransferType;
    }

    public DeviceConfirmationVO createDeviceConfirmationForReceive(@NotNull PerformInternalTransactionDTO performInternalTransactionDTO) throws FrameworkException {
        this.checkReceive(performInternalTransactionDTO);
        return this.transactionService.createDeviceConfirmationForReceive(performInternalTransactionDTO);
    }

    public SerializableInputStream deviceConfirmationBarcodeForReceive(InternalAccountOwner internalAccountOwner, DeviceConfirmationBarcodeParams deviceConfirmationBarcodeParams) throws FrameworkException {
        return this.transactionService.deviceConfirmationBarcodeForReceive(internalAccountOwner, deviceConfirmationBarcodeParams);
    }

    public FileInfo exportInstallments(@NotNull ExportFormatVO exportFormatVO, @NotNull InstallmentQuery installmentQuery) {
        this.checkInstallmentsQuery((BaseInstallmentQuery)installmentQuery);
        return this.transactionService.exportInstallments(exportFormatVO, installmentQuery);
    }

    public FileInfo exportInstallmentsOverview(@NotNull ExportFormatVO exportFormatVO, @NotNull InstallmentOverviewQuery installmentOverviewQuery) {
        this.checkInstallmentsQuery((BaseInstallmentQuery)installmentOverviewQuery);
        return this.transactionService.exportInstallmentsOverview(exportFormatVO, installmentOverviewQuery);
    }

    public FileInfo exportOverview(@NotNull ExportFormatVO exportFormatVO, @NotNull TransactionOverviewQuery transactionOverviewQuery) {
        this.checkBaseTransactionQuery((BaseTransactionQuery)transactionOverviewQuery);
        return this.transactionService.exportOverview(exportFormatVO, transactionOverviewQuery);
    }

    public FileInfo exportTransaction(@NotNull ExportFormatVO exportFormatVO, @NotNull TransactionVO transactionVO) throws FrameworkException {
        return this.transactionService.exportTransaction(exportFormatVO, transactionVO);
    }

    public FileInfo exportTransactions(@NotNull ExportFormatVO exportFormatVO, @NotNull TransactionQuery transactionQuery) {
        this.checkBaseTransactionQuery((BaseTransactionQuery)transactionQuery);
        return this.transactionService.exportTransactions(exportFormatVO, transactionQuery);
    }

    public TransactionData getData(TransactionVO transactionVO) throws FrameworkException {
        Transaction transaction = (Transaction)this.conversionHandler.convert(Transaction.class, (Object)transactionVO);
        switch (transaction.getNature()) {
            case PAYMENT: {
                return this.paymentServiceSecurity.getData(transaction.getId());
            }
            case RECURRING_PAYMENT: {
                return this.recurringPaymentServiceSecurity.getData(transaction.getId());
            }
            case SCHEDULED_PAYMENT: {
                return this.scheduledPaymentServiceSecurity.getData(transaction.getId());
            }
            case EXTERNAL_PAYMENT: {
                return this.externalPaymentServiceSecurity.getData(transaction.getId());
            }
            case PAYMENT_REQUEST: {
                return this.paymentRequestServiceSecurity.getData(transaction.getId());
            }
            case TICKET: {
                return this.ticketServiceSecurity.getData(new TicketVO(transaction.getId()));
            }
            case IMPORT: {
                return this.postProcess(transaction, this.transactionService.getData(transactionVO));
            }
        }
        throw new IllegalStateException("Unhandled transaction nature: " + String.valueOf(transaction.getNature()));
    }

    public InstallmentOverviewSearchData getInstallmentsOverviewSearchData() throws FrameworkException {
        this.checkLoggedIn();
        InstallmentOverviewSearchData installmentOverviewSearchData = this.transactionService.getInstallmentsOverviewSearchData();
        this.fillInstallmentsSearchData(null, installmentOverviewSearchData);
        return installmentOverviewSearchData;
    }

    public InstallmentSearchData getInstallmentsSearchData(InternalAccountOwner internalAccountOwner) throws FrameworkException {
        internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner, true).getInternalAccountOwner();
        this.accountServiceSecurity.checkAccessibleAccounts(internalAccountOwner);
        InstallmentSearchData installmentSearchData = this.transactionService.getInstallmentsSearchData(internalAccountOwner);
        this.fillInstallmentsSearchData(internalAccountOwner, installmentSearchData);
        return installmentSearchData;
    }

    public Page<MaturityTableItemData> getMaturityTable(MaturityTableQuery maturityTableQuery) {
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)maturityTableQuery.getTransferType());
        this.check(this.accountHandler.locateOrCurrent((AccountOwner)maturityTableQuery.getOwner()), null, (TransferType)paymentTransferType);
        return this.transactionService.getMaturityTable(maturityTableQuery);
    }

    public TransactionOverviewSearchData getOverviewSearchData(boolean bl) throws FrameworkException {
        TransactionOverviewSearchData transactionOverviewSearchData;
        SessionData sessionData = this.getSessionData();
        if (bl) {
            boolean bl2;
            if (sessionData.isAdmin()) {
                bl2 = sessionData.getProducts().admin().getAuthorizationRoles().isAnyKeySet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.view);
            } else {
                bl2 = sessionData.hasPermission(new Permission[]{Permission.MY_AUTHORIZED_PAYMENTS_VIEW, Permission.BROKER_AUTHORIZED_PAYMENTS_VIEW});
                if (!bl2) {
                    if (sessionData.isRestrictedOperator()) {
                        bl2 = this.operatorGroupService.canAuthorizeAnyPayment(sessionData.getLoggedOperator().getGroup());
                    } else if (sessionData.hasPermission(Permission.MY_OPERATORS_ENABLE)) {
                        bl2 = this.operatorGroupService.anyRequiresAuthorization(sessionData.getLoggedUser());
                    }
                }
            }
            if (!bl2) {
                throw new PermissionDeniedException();
            }
        } else if (sessionData.isGuest()) {
            throw new PermissionDeniedException();
        }
        if ((transactionOverviewSearchData = this.transactionService.getOverviewSearchData(bl)).getAccountTypes().isEmpty()) {
            throw new PermissionDeniedException();
        }
        return this.fillSearchData(null, transactionOverviewSearchData);
    }

    public PerformPaymentData getPaymentData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, TransferTypeVO transferTypeVO) throws FrameworkException {
        this.check(this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner), this.transactionService.locateForPayment(internalAccountOwner2));
        return this.transactionService.getPaymentData(internalAccountOwner, internalAccountOwner2, transferTypeVO);
    }

    public PerformPaymentToOwnerData getPaymentToOwnerData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, TransferTypeVO transferTypeVO) throws FrameworkException {
        this.check(this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner), this.transactionService.locateForPayment(internalAccountOwner2));
        return this.transactionService.getPaymentToOwnerData(internalAccountOwner, internalAccountOwner2, transferTypeVO);
    }

    public PerformPaymentTypeData getPaymentTypeData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, TransferTypeVO transferTypeVO) throws FrameworkException {
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        this.check(this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner), this.transactionService.locateForPayment(internalAccountOwner2), (TransferType)paymentTransferType);
        return this.transactionService.getPaymentTypeData(internalAccountOwner, internalAccountOwner2, transferTypeVO);
    }

    public ReceivePaymentData getReceivePaymentData() throws FrameworkException {
        this.checkPermission(Permission.MY_PAYMENTS_RECEIVE);
        return this.transactionService.getReceivePaymentData();
    }

    public ReceivePaymentFromUserData getReceivePaymentFromUserData(UserLocatorVO userLocatorVO, TransferTypeVO transferTypeVO) throws FrameworkException {
        this.checkPermission(Permission.MY_PAYMENTS_RECEIVE);
        return this.transactionService.getReceivePaymentFromUserData(userLocatorVO, transferTypeVO);
    }

    public PerformPaymentTypeData getReceivePaymentTypeData(UserLocatorVO userLocatorVO, TransferTypeVO transferTypeVO) throws FrameworkException {
        this.checkPermission(Permission.MY_PAYMENTS_RECEIVE);
        return this.transactionService.getReceivePaymentTypeData(userLocatorVO, transferTypeVO);
    }

    public TransactionSearchData getSearchData(InternalAccountOwner internalAccountOwner) throws FrameworkException {
        internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner, true).getInternalAccountOwner();
        this.accountServiceSecurity.checkAccessibleAccounts(internalAccountOwner);
        return this.fillSearchData(internalAccountOwner, this.transactionService.getSearchData(internalAccountOwner));
    }

    public Set<TransactionNature> getVisibleNatures(InternalAccountOwner internalAccountOwner) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner);
        SessionData sessionData = this.getSessionData();
        EnumSet<TransactionNature> enumSet = EnumSet.allOf(TransactionNature.class);
        enumSet.removeIf(transactionNature -> !this.isVisibleOrAccessible(true, sessionData, locateAccountOwnerResult, (TransactionNature)transactionNature));
        return enumSet;
    }

    public boolean isAccessible(InternalAccountOwner internalAccountOwner, TransactionNature transactionNature) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner, true);
        return this.hasAccess(locateAccountOwnerResult) && this.isVisibleOrAccessible(false, this.getSessionData(), locateAccountOwnerResult, transactionNature);
    }

    public boolean isAccessible(Transaction transaction) {
        boolean bl;
        if (transaction == null || transaction.getFrom() != null && transaction.getTo() != null && !this.transferServiceSecurity.isVisible((Trans)transaction)) {
            return false;
        }
        SessionData sessionData = this.getSessionData();
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        if (transaction.getBy() != null && transaction.getBy().equals((Object)basicUser)) {
            return true;
        }
        if (transaction instanceof BasePayment) {
            BasePayment basePayment = (BasePayment)transaction;
            if (sessionData.isLoggedIn() && Arrays.asList(basePayment.getToUser(), basePayment.getReceivedBy()).contains(basicUser)) {
                return true;
            }
            if (!basePayment.isAuthorized() && !this.canViewAuthorized(basePayment)) {
                return false;
            }
        }
        if (transaction instanceof Ticket) {
            return this.ticketServiceSecurity.isAccessible((Ticket)transaction);
        }
        if (transaction instanceof ScheduledPayment) {
            return this.scheduledPaymentServiceSecurity.isAccessible((ScheduledPayment)transaction);
        }
        if (transaction instanceof RecurringPayment) {
            return this.recurringPaymentServiceSecurity.isAccessible((RecurringPayment)transaction);
        }
        if (transaction instanceof PaymentRequest) {
            return this.paymentRequestServiceSecurity.isAccessible((PaymentRequest)transaction);
        }
        if (transaction instanceof ExternalPayment) {
            return this.externalPaymentServiceSecurity.isAccessible((ExternalPayment)transaction);
        }
        boolean bl2 = bl = this.isAccessible(transaction.getFromOwner(), transaction.getNature()) || transaction.getToOwner() instanceof InternalAccountOwner && this.isAccessible((InternalAccountOwner)transaction.getToOwner(), transaction.getNature());
        if (bl && sessionData.isRestrictedOperator()) {
            bl = this.hasRestrictedOperatorAccess(sessionData, transaction.getFrom(), true) || this.hasRestrictedOperatorAccess(sessionData, transaction.getTo(), false);
        }
        return bl;
    }

    public boolean isVisible(InternalAccountOwner internalAccountOwner, TransactionNature transactionNature) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner);
        return this.hasAccess(locateAccountOwnerResult) && this.isVisibleOrAccessible(true, this.getSessionData(), locateAccountOwnerResult, transactionNature);
    }

    public TransactionVO load(Long l) throws FrameworkException {
        return this.transactionService.load(l);
    }

    public TransactionVO loadByTransactionNumber(String string) throws FrameworkException {
        TransactionVO transactionVO = this.transactionService.loadByTransactionNumber(string);
        this.find(Transaction.class, transactionVO.getId());
        return transactionVO;
    }

    public <D extends TransactionData> D postProcess(Transaction transaction, D d) {
        switch (transaction.getNature()) {
            case PAYMENT: {
                return (D)this.paymentServiceSecurity.postProcess((Payment)transaction, (PaymentData)d);
            }
            case RECURRING_PAYMENT: {
                return (D)this.recurringPaymentServiceSecurity.postProcess((RecurringPayment)transaction, (RecurringPaymentData)d);
            }
            case SCHEDULED_PAYMENT: {
                return (D)this.scheduledPaymentServiceSecurity.postProcess((ScheduledPayment)transaction, (ScheduledPaymentData)d);
            }
            case EXTERNAL_PAYMENT: {
                return (D)this.externalPaymentServiceSecurity.postProcess((ExternalPayment)transaction, (ExternalPaymentData)d);
            }
            case PAYMENT_REQUEST: {
                return (D)this.paymentRequestServiceSecurity.postProcess((PaymentRequest)transaction, (PaymentRequestData)d);
            }
            case TICKET: {
                return (D)this.ticketServiceSecurity.postProcess((Ticket)transaction, (TicketData)d);
            }
            case IMPORT: {
                return this.postProcessTransactionData(transaction, d);
            }
        }
        throw new IllegalStateException("Unhandled transaction nature: " + String.valueOf(transaction.getNature()));
    }

    public <D extends TransactionData> D postProcessTransactionData(Transaction transaction, D d) {
        if (d instanceof BasePaymentData) {
            PaymentData paymentData;
            BasePaymentData basePaymentData = (BasePaymentData)d;
            this.setAuthorizationActions((BasePayment)transaction, basePaymentData);
            this.transactionFeedbackServiceSecurity.setFeedbackActions((BasePayment)transaction, basePaymentData);
            if (d instanceof PaymentData && (paymentData = (PaymentData)d).getBoughtVouchers() != null) {
                paymentData.getBoughtVouchers().removeIf(voucherVO -> !this.voucherServiceSecurity.isVisible((VoucherVO)voucherVO));
            }
        }
        return d;
    }

    public TransferVO processInstallment(InstallmentActionDTO installmentActionDTO) throws FrameworkException {
        Installment installment = (Installment)this.conversionHandler.convert(Installment.class, (Object)installmentActionDTO.getInstallment());
        if (installment instanceof ScheduledPaymentInstallment) {
            return this.scheduledPaymentServiceSecurity.processInstallment(installmentActionDTO);
        }
        if (installment instanceof RecurringPaymentOccurrence) {
            return this.recurringPaymentServiceSecurity.processFailure(installmentActionDTO);
        }
        throw new IllegalActionException("Invalid installment: " + String.valueOf(installment));
    }

    public void removeDeviceConfirmationForReceive(String string, @NotNull PerformInternalTransactionDTO performInternalTransactionDTO) throws FrameworkException {
        this.checkReceive(performInternalTransactionDTO);
        this.transactionService.removeDeviceConfirmationForReceive(string, performInternalTransactionDTO);
    }

    public void requestNewOTPForReceive(PerformInternalTransactionDTO performInternalTransactionDTO, SendMedium sendMedium) throws FrameworkException, SmsSendingException {
        this.checkReceive(performInternalTransactionDTO);
        this.transactionService.requestNewOTPForReceive(performInternalTransactionDTO, sendMedium);
    }

    public Page<TransactionResultVO> search(TransactionQuery transactionQuery) throws FrameworkException {
        this.checkQuery((BaseTransactionQuery)transactionQuery);
        return this.transactionService.search(transactionQuery);
    }

    public Page<InstallmentResultVO> searchInstallments(InstallmentQuery installmentQuery) throws FrameworkException {
        this.checkInstallmentsQuery((BaseInstallmentQuery)installmentQuery);
        return this.transactionService.searchInstallments(installmentQuery);
    }

    public Page<InstallmentResultVO> searchInstallmentsOverview(InstallmentOverviewQuery installmentOverviewQuery) throws FrameworkException {
        this.checkInstallmentsQuery((BaseInstallmentQuery)installmentOverviewQuery);
        return this.transactionService.searchInstallmentsOverview(installmentOverviewQuery);
    }

    public Page<TransactionResultVO> searchOverview(TransactionOverviewQuery transactionOverviewQuery) throws FrameworkException {
        this.checkBaseTransactionQuery((BaseTransactionQuery)transactionOverviewQuery);
        return this.transactionService.searchOverview(transactionOverviewQuery);
    }

    public void settleInstallment(InstallmentActionDTO installmentActionDTO) throws FrameworkException {
        Installment installment = (Installment)this.conversionHandler.convert(Installment.class, (Object)installmentActionDTO.getInstallment());
        if (!(installment instanceof ScheduledPaymentInstallment)) {
            throw new IllegalActionException("Invalid installment: " + String.valueOf(installment));
        }
        this.scheduledPaymentServiceSecurity.settleInstallment(installmentActionDTO);
    }

    public DeviceConfirmationVO viewDeviceConfirmationForReceive(String string, @NotNull PerformInternalTransactionDTO performInternalTransactionDTO) throws FrameworkException {
        this.checkReceive(performInternalTransactionDTO);
        return this.transactionService.viewDeviceConfirmationForReceive(string, performInternalTransactionDTO);
    }

    @Override
    protected void doInitialize() {
        super.doInitialize();
        this.naturePermissions = new EnumMap<TransactionNature, NaturePermissions>(TransactionNature.class);
        NaturePermissions naturePermissions = new NaturePermissions(Permission.MY_SCHEDULED_PAYMENTS_VIEW, Permission.USER_SCHEDULED_PAYMENTS_VIEW, Permission.SYSTEM_SCHEDULED_PAYMENTS_VIEW, operatorGroup -> true);
        this.naturePermissions.put(TransactionNature.SCHEDULED_PAYMENT, naturePermissions);
        this.naturePermissions.put(TransactionNature.RECURRING_PAYMENT, naturePermissions);
        this.naturePermissions.put(TransactionNature.EXTERNAL_PAYMENT, new NaturePermissions(Permission.MY_EXTERNAL_PAYMENTS_VIEW, Permission.USER_EXTERNAL_PAYMENTS_VIEW, Permission.SYSTEM_EXTERNAL_PAYMENTS_VIEW));
        this.naturePermissions.put(TransactionNature.PAYMENT_REQUEST, new NaturePermissions(Permission.MY_PAYMENT_REQUESTS_VIEW, Permission.USER_PAYMENT_REQUESTS_VIEW, Permission.SYSTEM_PAYMENT_REQUESTS_VIEW, OperatorGroup::isRequestPayments));
        this.naturePermissions.put(TransactionNature.TICKET, new NaturePermissions(Permission.MY_PAYMENT_TICKETS_VIEW, Permission.USER_PAYMENT_TICKETS_VIEW, null, OperatorGroup::isReceivePayments));
        this.getEntityCheckRegistry().register((EntityCheck)new BaseEntityCheck<Installment>(Installment.class){

            public boolean isVisible(SessionData sessionData, Installment installment) {
                return TransactionServiceSecurity.this.isAccessible((Transaction)installment.getTransaction());
            }
        });
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return new BaseEntityCheck<Transaction>(Transaction.class){

            public boolean isVisible(SessionData sessionData, Transaction transaction) {
                return TransactionServiceSecurity.this.isAccessible(transaction);
            }
        };
    }

    private boolean canViewAuthorized(BasePayment basePayment) {
        SessionData sessionData = this.getSessionData();
        TransactionAuthorizationType transactionAuthorizationType = basePayment.getAuthorizationType();
        if (transactionAuthorizationType == TransactionAuthorizationType.OPERATOR) {
            boolean bl = sessionData.getLoggedUser().equals((Object)basePayment.getFromUser());
            if (sessionData.isRestrictedOperator()) {
                Operator operator = sessionData.getLoggedOperator();
                if (!bl || !this.operatorGroupService.listPaymentTypesWithAuthorize(operator.getGroup()).contains(basePayment.getType())) {
                    return false;
                }
            } else if (!bl) {
                return false;
            }
        } else {
            if (!this.transactionAuthorizationServiceSecurity.hasViewPermission(basePayment.getFromOwner()) && !this.transactionAuthorizationServiceSecurity.hasViewPermission(basePayment.getToOwner())) {
                return false;
            }
            if (sessionData.isAdmin()) {
                PaymentTransferType paymentTransferType = (PaymentTransferType)basePayment.getType();
                HashSet hashSet = new HashSet();
                for (AuthorizationLevel authorizationLevel : paymentTransferType.getAuthorizationLevels()) {
                    hashSet.addAll(authorizationLevel.getRoles());
                }
                Set set = sessionData.getProducts().admin().getAuthorizationRoles().keysSet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.view);
                if (!CollectionUtils.containsAny((Collection)set, hashSet)) {
                    return false;
                }
            }
        }
        return true;
    }

    private void checkInstallmentsQuery(BaseInstallmentQuery baseInstallmentQuery) {
        User user;
        Object object;
        InternalAccountOwner internalAccountOwner = null;
        if (baseInstallmentQuery instanceof InstallmentQuery) {
            object = (InstallmentQuery)baseInstallmentQuery;
            LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)object.getOwner(), true);
            if (locateAccountOwnerResult.isSystem()) {
                this.checkPermission(Permission.SYSTEM_ACCOUNTS_VIEW);
            } else if (locateAccountOwnerResult.isUser()) {
                user = locateAccountOwnerResult.getUser();
                SessionData sessionData = this.getSessionData();
                if (sessionData.isManagerOf((BasicUser)user)) {
                    this.checkPermission(Permission.USER_ACCOUNTS_VIEW);
                } else if (!user.equals((Object)sessionData.getLoggedUser())) {
                    throw new PermissionDeniedException();
                }
            }
            internalAccountOwner = locateAccountOwnerResult.getInternalAccountOwner();
            object.setOwner(internalAccountOwner);
        }
        object = baseInstallmentQuery.getAuthorizationStatuses();
        boolean bl = this.transactionAuthorizationServiceSecurity.hasViewPermission(internalAccountOwner);
        if (!(!CollectionHelper.isNotEmpty((Iterable)object) || bl || object.size() == 1 && object.contains(TransactionAuthorizationStatus.AUTHORIZED))) {
            throw new PermissionDeniedException();
        }
        user = this.getVisibleNatures(internalAccountOwner);
        user.removeIf(transactionNature -> !transactionNature.hasInstallments());
        PermissionHelper.checkSelection((Collection)user, (Collection)baseInstallmentQuery.getNatures());
        this.accountServiceSecurity.checkTransQuery((AbstractTransQuery)baseInstallmentQuery);
    }

    private CheckResult checkPerform(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, CurrencyVO currencyVO, TransferTypeVO transferTypeVO) {
        Validator validator = new Validator();
        validator.property((Property)PerformPaymentDTO.SUBJECT, BankingKeys.Transactions.RECEIVER).required();
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setAttribute("forPOS", (Object)Boolean.TRUE);
        performPaymentDTO.setSubject(internalAccountOwner2);
        this.validate(validator, performPaymentDTO);
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner);
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.transactionService.locateForPayment(internalAccountOwner2);
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        SessionData sessionData = this.getSessionData();
        Permission permission = null;
        boolean bl = locateAccountOwnerResult2.isSystem();
        if (locateAccountOwnerResult.isSystem()) {
            permission = bl ? Permission.SYSTEM_PAYMENTS_PAY_TO_SYSTEM : Permission.SYSTEM_PAYMENTS_PAY_TO_USER;
        } else if (locateAccountOwnerResult.isUser()) {
            boolean bl2 = locateAccountOwnerResult.getUser().equals((Object)locateAccountOwnerResult2.getUser());
            if (locateAccountOwnerResult.getUser().equals((Object)sessionData.getLoggedUser())) {
                permission = bl2 ? Permission.MY_PAYMENTS_PAY_TO_SELF : (bl ? Permission.MY_PAYMENTS_PAY_TO_SYSTEM : Permission.MY_PAYMENTS_PAY_TO_USER);
            } else {
                Permission permission2 = bl2 ? Permission.USER_PAYMENTS_PAY_TO_SELF : (permission = bl ? Permission.USER_PAYMENTS_PAY_TO_SYSTEM : Permission.USER_PAYMENTS_PAY_TO_USER);
            }
        }
        if (permission == null || !sessionData.hasPermission(permission)) {
            throw new PermissionDeniedException();
        }
        if (paymentTransferType == null) {
            Currency currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)currencyVO);
            paymentTransferType = this.transactionService.resolvePaymentType(locateAccountOwnerResult.getInternalAccountOwner(), (AccountOwner)locateAccountOwnerResult2.getInternalAccountOwner(), currency, sessionData.getChannel(), sessionData.getPrincipalType(), PaymentCreationType.DIRECT);
        }
        if (paymentTransferType == null) {
            String string = this.message(GeneralKeys.Errors.REQUIRED, this.message(BankingKeys.Transactions.TYPE, new Object[0]));
            throw new ValidationException(PerformPaymentDTO.TYPE.getName(), string);
        }
        this.check(locateAccountOwnerResult, locateAccountOwnerResult2, (TransferType)paymentTransferType);
        return new CheckResult(locateAccountOwnerResult2, paymentTransferType);
    }

    private PaymentTransferType checkReceive(InternalAccountOwner internalAccountOwner, CurrencyVO currencyVO, TransferTypeVO transferTypeVO) {
        Object object;
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isMember() || !sessionData.hasPermission(Permission.MY_PAYMENTS_RECEIVE)) {
            throw new PermissionDeniedException();
        }
        LocateAccountOwnerResult locateAccountOwnerResult = this.transactionService.locateForReceiving(internalAccountOwner);
        if (!locateAccountOwnerResult.isUser()) {
            throw new ValidationException(PerformPaymentDTO.SUBJECT.getName(), this.message(GeneralKeys.Errors.REQUIRED, BankingKeys.Accounts.FROM));
        }
        internalAccountOwner = locateAccountOwnerResult.getInternalAccountOwner();
        User user = sessionData.getLoggedUser();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        if (paymentTransferType == null) {
            object = (Currency)this.conversionHandler.convert(Currency.class, (Object)currencyVO);
            paymentTransferType = this.transactionService.resolvePaymentType(internalAccountOwner, (AccountOwner)user, object, this.channelService.getPos(), locateAccountOwnerResult.getPrincipalType(), PaymentCreationType.POS);
        }
        if (paymentTransferType == null || !paymentTransferType.isFromUser() || !paymentTransferType.isToUser()) {
            object = this.message(GeneralKeys.Errors.REQUIRED, this.message(BankingKeys.Transactions.TYPE, new Object[0]));
            throw new ValidationException(PerformPaymentDTO.TYPE.getName(), (String)object);
        }
        boolean bl = sessionData.getProducts().member((UserAccountType)paymentTransferType.getTo()).hasPermission(Permission.MY_PAYMENTS_RECEIVE);
        if (!bl) {
            throw new PermissionDeniedException();
        }
        return paymentTransferType;
    }

    private void doCheck(LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, TransferType transferType, boolean bl) {
        String string;
        User user;
        if (transferType != null && !(transferType instanceof PaymentTransferType)) {
            throw new ValidationException();
        }
        SessionData sessionData = this.getSessionData();
        PaymentTransferType paymentTransferType = (PaymentTransferType)transferType;
        if (locateAccountOwnerResult.isSystem()) {
            if (locateAccountOwnerResult2 != null && locateAccountOwnerResult2.isSystem()) {
                this.permissionOptionalValue(Permission.SYSTEM_PAYMENTS_PAY_TO_SYSTEM).value((Object)paymentTransferType).check();
            } else {
                this.permissionOptionalValue(Permission.SYSTEM_PAYMENTS_PAY_TO_USER).value((Object)paymentTransferType).check();
            }
        } else if (locateAccountOwnerResult2 != null) {
            user = (User)this.conversionHandler.convert(User.class, (Object)locateAccountOwnerResult);
            boolean bl2 = locateAccountOwnerResult.getAccountOwner().equals((Object)locateAccountOwnerResult2.getAccountOwner());
            this.permissionOptionalValue(user).my(new Permission[]{bl2 ? Permission.MY_PAYMENTS_PAY_TO_SELF : (locateAccountOwnerResult2.isSystem() ? Permission.MY_PAYMENTS_PAY_TO_SYSTEM : Permission.MY_PAYMENTS_PAY_TO_USER)}).user(new Permission[]{bl2 ? Permission.USER_PAYMENTS_PAY_TO_SELF : (locateAccountOwnerResult2.isSystem() ? Permission.USER_PAYMENTS_PAY_TO_SYSTEM : Permission.USER_PAYMENTS_PAY_TO_USER)}).value((Object)paymentTransferType).check();
            if (!bl2 && !locateAccountOwnerResult2.isSystem() && sessionData.getLoggedBasicUser().isRestrictedOperator()) {
                string = (Operator)sessionData.getLoggedBasicUser();
                Set set = string.getGroup().getRestrictPaymentsToUsers();
                User user2 = locateAccountOwnerResult2.getUser();
                if (CollectionHelper.isNotEmpty((Iterable)set) && user2 != null && !set.contains(user2)) {
                    throw new ValidationException();
                }
            }
        }
        if (paymentTransferType != null && bl) {
            user = sessionData.getChannel();
            PrincipalType principalType = sessionData.getPrincipalType();
            if (!paymentTransferType.getChannels().contains(user) || principalType != null && !paymentTransferType.getPrincipalTypes().isEmpty() && !paymentTransferType.getPrincipalTypes().contains(principalType)) {
                string = this.message(BankingKeys.Transactions.TYPE, new Object[0]);
                throw new ValidationException(PerformTransactionDTO.TYPE.getName(), this.message(GeneralKeys.Errors.INVALID, string));
            }
        }
    }

    private <D extends IInstallmentSearchData> D fillInstallmentsSearchData(InternalAccountOwner internalAccountOwner, D d) {
        if (CollectionHelper.isEmpty((Iterable)d.getAccountTypes()) || CollectionHelper.isEmpty((Iterable)d.getVisibleNatures())) {
            throw new PermissionDeniedException();
        }
        d.setCanViewAuthorized(this.transactionAuthorizationServiceSecurity.hasViewPermission(internalAccountOwner));
        return d;
    }

    private <D extends ITransactionSearchData> D fillSearchData(InternalAccountOwner internalAccountOwner, D d) {
        if (CollectionHelper.isEmpty((Iterable)d.getAccountTypes()) || CollectionHelper.isEmpty((Iterable)d.getVisibleNatures())) {
            throw new PermissionDeniedException();
        }
        d.setCanViewAuthorized(this.transactionAuthorizationServiceSecurity.hasViewPermission(internalAccountOwner));
        return d;
    }

    private boolean hasAccess(LocateAccountOwnerResult locateAccountOwnerResult) {
        if (locateAccountOwnerResult.isEmpty()) {
            SessionData sessionData = this.getSessionData();
            return !sessionData.getProducts().grantedAccountTypes().isEmpty();
        }
        return this.accountTypeService.hasAccessible(locateAccountOwnerResult.getInternalAccountOwner());
    }

    private boolean hasRestrictedOperatorAccess(SessionData sessionData, Account account, boolean bl) {
        User user;
        User user2 = user = account instanceof UserAccount ? ((UserAccount)account).getUser() : null;
        if (user == null) {
            return false;
        }
        if (user.equals((Object)sessionData.getLoggedUser())) {
            OperatorGroupAccountAccess operatorGroupAccountAccess = this.operatorService.accountAccess(account);
            return bl ? operatorGroupAccountAccess.allowsOutgoing() : operatorGroupAccountAccess.allowsIncoming();
        }
        return sessionData.isBrokerOf((BasicUser)user) && this.accountServiceSecurity.hasAccess(account);
    }

    private boolean isVisibleOrAccessible(boolean bl, SessionData sessionData, LocateAccountOwnerResult locateAccountOwnerResult, TransactionNature transactionNature) {
        NaturePermissions naturePermissions = this.naturePermissions.get(transactionNature);
        if (naturePermissions != null) {
            return naturePermissions.hasAccessOrView(bl, locateAccountOwnerResult, sessionData);
        }
        return true;
    }

    private void setAuthorizationActions(BasePayment basePayment, BasePaymentData basePaymentData) {
        Set<AuthorizationAction> set = this.transactionAuthorizationServiceSecurity.getPossibleActions(basePayment);
        basePaymentData.setCanAuthorize(basePaymentData.isCanAuthorize() && set.contains(AuthorizationAction.AUTHORIZED));
        basePaymentData.setCanDeny(basePaymentData.isCanDeny() && set.contains(AuthorizationAction.DENIED));
        basePaymentData.setCanCancelAuthorization(basePaymentData.isCanCancelAuthorization() && set.contains(AuthorizationAction.CANCELED));
    }

    private static class CheckResult {
        private PaymentTransferType type;
        private LocateAccountOwnerResult to;

        public CheckResult(LocateAccountOwnerResult locateAccountOwnerResult, PaymentTransferType paymentTransferType) {
            this.to = locateAccountOwnerResult;
            this.type = paymentTransferType;
        }
    }

    private class NaturePermissions {
        private final Permission my;
        private final Permission user;
        private final Permission system;
        private final Predicate<OperatorGroup> restrictedOperatorView;

        public NaturePermissions(Permission permission, Permission permission2, Permission permission3) {
            this(permission, permission2, permission3, null);
        }

        public NaturePermissions(Permission permission, Permission permission2, Permission permission3, Predicate<OperatorGroup> predicate) {
            this.my = permission;
            this.user = permission2;
            this.system = permission3;
            this.restrictedOperatorView = predicate;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean hasAccessOrView(boolean bl, LocateAccountOwnerResult locateAccountOwnerResult, SessionData sessionData) {
            if (locateAccountOwnerResult.isSystem()) {
                if (this.system == null) return false;
                if (!sessionData.hasPermission(this.system)) return false;
                return true;
            }
            if (locateAccountOwnerResult.isUser()) {
                if (sessionData.isRestrictedOperator() && locateAccountOwnerResult.getUser().equals((Object)sessionData.getLoggedUser())) {
                    OperatorGroup operatorGroup = sessionData.getLoggedOperator().getGroup();
                    if (this.restrictedOperatorView == null) return false;
                    if (!this.restrictedOperatorView.test(operatorGroup)) {
                        return false;
                    }
                    if (!bl) {
                        return true;
                    }
                    if (this.my == null) return false;
                    if (!sessionData.hasPermission(this.my)) return false;
                    return true;
                }
                UserPermissionCheck userPermissionCheck = TransactionServiceSecurity.this.permission((BasicUser)locateAccountOwnerResult.getUser());
                userPermissionCheck = bl ? userPermissionCheck.my(new Permission[]{this.my}) : userPermissionCheck.my(new Permission[0]);
                return userPermissionCheck.user(new Permission[]{this.user}).granted();
            }
            if (!locateAccountOwnerResult.isEmpty()) return false;
            if (!Arrays.asList(this.my, this.user, this.system).stream().filter(Objects::nonNull).anyMatch(arg_0 -> ((SessionData)sessionData).hasPermission(arg_0))) return false;
            return true;
        }
    }
}

