/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.banking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.TicketServiceLocal;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityModel;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.ApproveTicketDTO;
import org.cyclos.model.banking.transactions.ApproveTicketPreviewVO;
import org.cyclos.model.banking.transactions.CreateTicketDTO;
import org.cyclos.model.banking.transactions.CreateTicketData;
import org.cyclos.model.banking.transactions.ProcessTicketDTO;
import org.cyclos.model.banking.transactions.TicketBarcodeParams;
import org.cyclos.model.banking.transactions.TicketData;
import org.cyclos.model.banking.transactions.TicketPaymentTypeData;
import org.cyclos.model.banking.transactions.TicketProcessResult;
import org.cyclos.model.banking.transactions.TicketStatus;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.banking.TicketService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class TicketServiceSecurity
extends BaseServiceSecurity
implements TicketService {
    @Autowired
    private TicketServiceLocal ticketService;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;

    public TicketVO approve(ApproveTicketDTO approveTicketDTO) throws FrameworkException, TransferException {
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)approveTicketDTO.getTicket());
        this.checkApprovePermission(ticket);
        User user = ticket.getToUser();
        this.checkRelatesToUser((BasicUser)user);
        return this.ticketService.approve(approveTicketDTO);
    }

    public SerializableInputStream barcode(TicketBarcodeParams ticketBarcodeParams) throws FrameworkException {
        return this.ticketService.barcode(ticketBarcodeParams);
    }

    public void cancel(TicketVO ticketVO) throws FrameworkException {
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)ticketVO);
        this.checkCancelPermission(ticket);
        this.ticketService.cancel(ticketVO);
    }

    public TicketVO create(CreateTicketDTO createTicketDTO) throws FrameworkException {
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)createTicketDTO.getType());
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)createTicketDTO.getOwner());
        if (!locateAccountOwnerResult.isUser()) {
            throw new PermissionDeniedException();
        }
        createTicketDTO.setOwner(locateAccountOwnerResult.getInternalAccountOwner());
        this.checkCreatePermission(locateAccountOwnerResult.getUser(), transferType);
        return this.ticketService.create(createTicketDTO);
    }

    public CreateTicketData getCreateData(UserLocatorVO userLocatorVO, UserLocatorVO userLocatorVO2) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        this.checkCreatePermission(user, null);
        return this.ticketService.getCreateData(userLocatorVO, userLocatorVO2);
    }

    public TicketData getData(TicketVO ticketVO) throws FrameworkException {
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)ticketVO);
        TicketData ticketData = this.ticketService.getData(ticketVO);
        return this.postProcess(ticket, ticketData);
    }

    public TicketPaymentTypeData getTicketPaymentTypeData(UserLocatorVO userLocatorVO, @NotNull TransferTypeVO transferTypeVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)transferTypeVO);
        this.checkCreatePermission(user, transferType);
        return this.ticketService.getTicketPaymentTypeData(userLocatorVO, transferTypeVO);
    }

    public boolean isAccessible(Ticket ticket) {
        SessionData sessionData = this.getSessionData();
        User user = ticket.getToUser();
        User user2 = ticket.getFromUser();
        return this.transactionServiceSecurity.isAccessible((InternalAccountOwner)user, TransactionNature.TICKET) || sessionData.isLoggedIn() && sessionData.getLoggedUser().equals((Object)user2) || ticket.getStatus() == TicketStatus.OPEN && user2 == null;
    }

    public TicketData postProcess(Ticket ticket, TicketData ticketData) {
        TicketVO ticketVO = (TicketVO)ticketData.getTransaction();
        ticketData.setCanCancel(ticketData.isCanCancel() && this.hasCancelPermission(ticket));
        if (this.getSessionData().isGuest()) {
            this.removePropertyValuesNotIn((Bean)ticketData, new Property[]{TicketData.TRANSACTION, TicketData.CONFIRMATION_PASSWORD_INPUT});
            List<Property<?, ?>> list = Arrays.asList(TicketVO.EXPIRATION_DATE, TicketVO.STATUS, TicketVO.TICKET_NUMBER, TicketVO.CURRENCY_AMOUNT, TicketVO.DATE, TicketVO.TYPE, TicketVO.DESCRIPTION, TicketVO.NATURE, TicketVO.CANCEL_URL, TicketVO.SUCCESS_URL);
            if (ticket.getStatus() == TicketStatus.OPEN) {
                list = new ArrayList<Property>(list);
                list.add((Property<?, ?>)TicketVO.PAYER);
                list.add((Property<?, ?>)TicketVO.PAYER_PRINCIPAL);
                list.add((Property<?, ?>)TicketVO.PAYEE);
            }
            this.removePropertyValuesNotIn((Bean)ticketVO, list);
            this.removePropertyValuesNotIn((Bean)ticketVO.getPayee(), new Property[]{UserVO.IMAGE, UserVO.DISPLAY});
            this.removePropertyValuesNotIn((Bean)ticketData.getConfirmationPasswordInput(), new Property[]{CredentialInputDTO.ALLOWED_CREDENTIALS});
            this.removeIdsAndInternalNames(ticketData);
        }
        return this.transactionServiceSecurity.postProcessTransactionData((Transaction)ticket, ticketData);
    }

    public ApproveTicketPreviewVO previewApprove(TicketVO ticketVO) throws FrameworkException {
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)ticketVO);
        this.checkApprovePermission(ticket);
        return this.ticketService.previewApprove(ticketVO);
    }

    public TicketProcessResult process(ProcessTicketDTO processTicketDTO) throws TransferException, FrameworkException {
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)processTicketDTO.getTicket());
        User user = this.getLoggedUser();
        User user2 = ticket.getToUser();
        if (user == null || !user.equals((Object)user2)) {
            throw new PermissionDeniedException();
        }
        return this.ticketService.process(processTicketDTO);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private void checkApprovePermission(Ticket ticket) {
        if (!this.hasApprovePermission(ticket)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkCancelPermission(Ticket ticket) {
        if (!this.hasCancelPermission(ticket)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkCreatePermission(User user, TransferType transferType) {
        this.checkLoggedIn();
        if (!this.hasCreatePermission(user, transferType)) {
            throw new PermissionDeniedException();
        }
    }

    private boolean hasApprovePermission(Ticket ticket) {
        User user = this.getLoggedUser();
        User user2 = ticket.getToUser();
        if (user != null && user.equals((Object)user2)) {
            throw new IllegalActionException();
        }
        if (ticket.getStatus() != TicketStatus.OPEN) {
            return false;
        }
        User user3 = ticket.getFromUser();
        if (user3 != null && !user3.equals((Object)user)) {
            return false;
        }
        return this.permissionOptionalValue(Permission.MY_PAYMENT_TICKETS_APPROVE).value((Object)ticket.getType()).granted();
    }

    private boolean hasCancelPermission(Ticket ticket) {
        User user = ticket.getToUser();
        return this.permission((BasicUser)user).my(new Permission[]{Permission.MY_PAYMENT_TICKETS_CANCEL}).user(new Permission[]{Permission.USER_PAYMENT_TICKETS_CANCEL}).granted();
    }

    private boolean hasCreatePermission(User user, TransferType transferType) {
        return this.permissionOptionalValue(user).my(new Permission[]{Permission.MY_PAYMENT_TICKETS_CREATE}).user(new Permission[]{Permission.USER_PAYMENT_TICKETS_CREATE}).value((Object)transferType).granted();
    }

    private void removeIdsAndInternalNames(Object object) {
        if (object != null) {
            if (object instanceof IInternalNamedEntity) {
                ((IInternalNamedEntity)object).setInternalName(null);
            }
            if (object instanceof EntityModel) {
                ((EntityModel)object).setId(null);
            }
            if (object instanceof Bean) {
                Bean bean = (Bean)object;
                for (Property property : bean.properties()) {
                    this.removeIdsAndInternalNames(bean.get(property));
                }
            } else if (object instanceof Collection) {
                ((Collection)object).stream().forEach(this::removeIdsAndInternalNames);
            }
        }
    }

    private void removePropertyValuesNotIn(Bean bean, List<Property<?, ?>> list) {
        if (bean != null) {
            bean.properties().stream().filter(property -> !list.contains(property)).forEach(property -> bean.set(property, null));
        }
    }

    private void removePropertyValuesNotIn(Bean bean, Property ... propertyArray) {
        this.removePropertyValuesNotIn(bean, Arrays.asList(propertyArray));
    }
}

