/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.security.access;

import java.util.Arrays;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.DeviceConfirmation;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.EntityCheck;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.devices.DeviceConfirmationApprovalData;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.security.BaseServiceSecurity;
import org.cyclos.security.Security;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.access.DeviceConfirmationService;
import org.springframework.beans.factory.annotation.Autowired;

@Security
public class DeviceConfirmationServiceSecurity
extends BaseServiceSecurity
implements DeviceConfirmationService {
    @Autowired
    private DeviceConfirmationServiceLocal deviceConfirmationService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private InvokerHandler invokerHandler;

    public void approve(String string, long l, String string2) {
        this.doAction(string, l, string2, true);
    }

    public SerializableInputStream barcode(DeviceConfirmationBarcodeParams deviceConfirmationBarcodeParams) {
        this.check(deviceConfirmationBarcodeParams.getConfirmationId());
        return this.deviceConfirmationService.barcode(deviceConfirmationBarcodeParams);
    }

    public DeviceConfirmationVO create(CreateDeviceConfirmationParams createDeviceConfirmationParams) {
        this.checkLoggedIn();
        return this.deviceConfirmationService.create(createDeviceConfirmationParams);
    }

    public DeviceConfirmationApprovalData getApprovalData(Long l) {
        return this.deviceConfirmationService.getApprovalData(l);
    }

    public boolean isVisible(DeviceConfirmation deviceConfirmation) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return true;
        }
        if (sessionData.isGuest() && sessionData.getChannel().isMobile() && !sessionData.getChannelAccessAccessor().isRequireAuthenticationForDeviceConfirmation()) {
            return true;
        }
        if (deviceConfirmation.getUserId() == null) {
            return true;
        }
        if (sessionData.isLoggedIn()) {
            Long l = sessionData.getLoggedBasicUser().getId();
            return Arrays.asList(deviceConfirmation.getUserId(), deviceConfirmation.getCreatorId()).contains(l);
        }
        return false;
    }

    public DeviceConfirmationVO load(String string) throws FrameworkException {
        this.check(string);
        return this.deviceConfirmationService.load(string);
    }

    public void reject(String string, long l, String string2) {
        this.check(string);
        this.doAction(string, l, string2, false);
    }

    public void remove(String string) {
        this.check(string);
        this.deviceConfirmationService.remove(string);
    }

    @Override
    protected EntityCheck<?> resolveEntityCheck() {
        return null;
    }

    private DeviceConfirmation check(String string) {
        DeviceConfirmation deviceConfirmation = this.deviceConfirmationService.find(string);
        if (!this.isVisible(deviceConfirmation)) {
            throw new EntityNotFoundException(DeviceConfirmation.class, string);
        }
        return deviceConfirmation;
    }

    private void doAction(String string, long l, String string2, boolean bl) {
        Runnable runnable = () -> {
            if (bl) {
                this.deviceConfirmationService.approve(string, l, string2);
            } else {
                this.deviceConfirmationService.reject(string, l, string2);
            }
        };
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest()) {
            TrustedDevice trustedDevice = (TrustedDevice)this.rawEntityManagerHandler.find(TrustedDevice.class, Long.valueOf(l));
            ChannelConfiguration channelConfiguration = this.configurationHandler.getAccessAccessor(trustedDevice.getUser()).getChannelConfiguration(sessionData.getAccessChannel());
            boolean bl2 = channelConfiguration.isRequireAuthenticationForDeviceConfirmation();
            if (bl2) {
                throw new PermissionDeniedException();
            }
            SessionData sessionData2 = SessionDataFactory.user((BasicUser)trustedDevice.getUser());
            this.invokerHandler.runAs(sessionData2, () -> {
                runnable.run();
                return null;
            });
        } else {
            runnable.run();
        }
    }
}

