/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.validation.validations;

import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.util.Collection;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.system.CaptchaConfiguration;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.validations.CaptchaValidation;
import org.cyclos.impl.utils.validation.validations.CharacterEncodingValidation;
import org.cyclos.impl.utils.validation.validations.ChildValidation;
import org.cyclos.impl.utils.validation.validations.ColorValidation;
import org.cyclos.impl.utils.validation.validations.ComparableValidation;
import org.cyclos.impl.utils.validation.validations.ContainedInValidation;
import org.cyclos.impl.utils.validation.validations.DateValidation;
import org.cyclos.impl.utils.validation.validations.EmailValidation;
import org.cyclos.impl.utils.validation.validations.FixedLengthValidation;
import org.cyclos.impl.utils.validation.validations.FutureDateValidation;
import org.cyclos.impl.utils.validation.validations.FuturePeriodValidation;
import org.cyclos.impl.utils.validation.validations.IdentifierValidation;
import org.cyclos.impl.utils.validation.validations.InternetAddressListValidation;
import org.cyclos.impl.utils.validation.validations.InternetAddressValidation;
import org.cyclos.impl.utils.validation.validations.InvalidValidation;
import org.cyclos.impl.utils.validation.validations.IpAddressValidation;
import org.cyclos.impl.utils.validation.validations.LatLongValidation;
import org.cyclos.impl.utils.validation.validations.MaskValidation;
import org.cyclos.impl.utils.validation.validations.MaskValueValidation;
import org.cyclos.impl.utils.validation.validations.MaxElementsValidation;
import org.cyclos.impl.utils.validation.validations.MaxLengthValidation;
import org.cyclos.impl.utils.validation.validations.MaxWordSizeValidation;
import org.cyclos.impl.utils.validation.validations.MinElementsValidation;
import org.cyclos.impl.utils.validation.validations.MinLengthValidation;
import org.cyclos.impl.utils.validation.validations.MustBeInstanceOfValidation;
import org.cyclos.impl.utils.validation.validations.NoFuturePeriodValidation;
import org.cyclos.impl.utils.validation.validations.NoPropertyOfValidation;
import org.cyclos.impl.utils.validation.validations.NoUrlValidation;
import org.cyclos.impl.utils.validation.validations.NoneOfValidation;
import org.cyclos.impl.utils.validation.validations.NotContainsValidation;
import org.cyclos.impl.utils.validation.validations.PastDateValidation;
import org.cyclos.impl.utils.validation.validations.PeriodValidation;
import org.cyclos.impl.utils.validation.validations.PhoneValidation;
import org.cyclos.impl.utils.validation.validations.RangeOptionalType;
import org.cyclos.impl.utils.validation.validations.RangeValidation;
import org.cyclos.impl.utils.validation.validations.RegexValidation;
import org.cyclos.impl.utils.validation.validations.RequiredValidation;
import org.cyclos.impl.utils.validation.validations.SignalValidation;
import org.cyclos.impl.utils.validation.validations.TimeIntervalValidation;
import org.cyclos.impl.utils.validation.validations.UniqueValidation;
import org.cyclos.impl.utils.validation.validations.UrlValidation;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.utils.MessageKey;

public class PropertyValidations {
    private static final PropertyValidation DATE = new DateValidation();
    private static final PropertyValidation PAST_DATE = new PastDateValidation();
    private static final PropertyValidation FUTURE_DATE = new FutureDateValidation();
    private static final PropertyValidation POSITIVE_OR_ZERO = new SignalValidation(true, true, null, ValidationErrors.positiveOrZero());
    private static final PropertyValidation POSITIVE_NON_ZERO = new SignalValidation(true, false, null, ValidationErrors.positiveNonZero());
    private static final PropertyValidation NEGATIVE_OR_ZERO = new SignalValidation(false, true, null, ValidationErrors.negativeOrZero());
    private static final PropertyValidation RANGE_OPTIONAL_LIMITS = new RangeValidation(RangeOptionalType.BOTH_OPTIONAL);
    private static final PropertyValidation RANGE_ONE_LIMIT_REQUIRED = new RangeValidation(RangeOptionalType.ONE_REQUIRED);
    private static final PropertyValidation RANGE_BOTH_LIMITS_REQUIRED = new RangeValidation(RangeOptionalType.BOTH_REQUIRED);
    private static final PropertyValidation EMAIL = new EmailValidation();
    private static final PropertyValidation REQUIRED = new RequiredValidation();
    private static final PropertyValidation FUTURE_PERIOD = new FuturePeriodValidation();
    private static final PropertyValidation NO_FUTURE_PERIOD = new NoFuturePeriodValidation();
    private static final PropertyValidation INTERNET_ADDRESS = new InternetAddressValidation();
    private static final PropertyValidation IP_ADDRESS = new IpAddressValidation();
    private static final PropertyValidation PERIOD = new PeriodValidation();
    private static final PropertyValidation LAT_LONG = new LatLongValidation();
    private static final PropertyValidation URL = new UrlValidation();
    private static final PropertyValidation IDENTIFIER = new IdentifierValidation();
    private static final PropertyValidation COLOR = new ColorValidation();
    private static final PropertyValidation INTERNET_ADDRESS_LIST = new InternetAddressListValidation();
    private static final PropertyValidation CHARACTER_ENCODING = new CharacterEncodingValidation();

    @Deprecated
    public static PropertyValidation allOf(Collection<?> collection) {
        return PropertyValidations.anyOf(collection);
    }

    public static PropertyValidation anyOf(Collection<?> collection) {
        return new ContainedInValidation(collection);
    }

    public static PropertyValidation captcha(CaptchaConfiguration captchaConfiguration) {
        return new CaptchaValidation(captchaConfiguration);
    }

    public static PropertyValidation characterEncoding() {
        return CHARACTER_ENCODING;
    }

    public static PropertyValidation childOf(Object object, MessageKey messageKey) {
        return new ChildValidation(object, messageKey);
    }

    public static PropertyValidation color() {
        return COLOR;
    }

    public static PropertyValidation comparable(Comparable<?> comparable, boolean bl, boolean bl2, boolean bl3, ValidationError validationError) {
        return new ComparableValidation(comparable, bl, bl2, bl3, validationError);
    }

    public static PropertyValidation comparable(Comparable<?> comparable, String string, ValidationError validationError) {
        boolean bl = string.equals("<") || string.equals("<=");
        boolean bl2 = string.equals("<=") || string.equals("==") || string.equals(">=");
        boolean bl3 = string.equals(">") || string.equals(">=");
        return new ComparableValidation(comparable, bl, bl2, bl3, validationError);
    }

    public static PropertyValidation date() {
        return DATE;
    }

    public static PropertyValidation email() {
        return EMAIL;
    }

    public static PropertyValidation fixedLength(int n) {
        return new FixedLengthValidation(n);
    }

    public static PropertyValidation futureDate() {
        return FUTURE_DATE;
    }

    public static PropertyValidation futurePeriod() {
        return FUTURE_PERIOD;
    }

    public static PropertyValidation greaterEquals(Comparable<?> comparable) {
        return PropertyValidations.comparable(comparable, ">=", ValidationErrors.greaterEquals(comparable));
    }

    public static PropertyValidation greaterThan(Comparable<?> comparable) {
        return PropertyValidations.comparable(comparable, ">", ValidationErrors.greaterThan(comparable));
    }

    public static PropertyValidation identifier() {
        return IDENTIFIER;
    }

    public static PropertyValidation internetAddress() {
        return INTERNET_ADDRESS;
    }

    public static PropertyValidation internetAddressList() {
        return INTERNET_ADDRESS_LIST;
    }

    public static PropertyValidation invalid(boolean bl, ValidationError validationError) {
        return new InvalidValidation(bl, validationError);
    }

    public static PropertyValidation ipAddress() {
        return IP_ADDRESS;
    }

    public static PropertyValidation latLong() {
        return LAT_LONG;
    }

    public static PropertyValidation lessEquals(Comparable<?> comparable) {
        return PropertyValidations.comparable(comparable, "<=", ValidationErrors.lessEquals(comparable));
    }

    public static PropertyValidation lessThan(Comparable<?> comparable) {
        return PropertyValidations.comparable(comparable, "<", ValidationErrors.lessThan(comparable));
    }

    public static PropertyValidation mask(int n) {
        return new MaskValidation(n);
    }

    public static PropertyValidation maskValue(String string) {
        return new MaskValueValidation(string);
    }

    public static PropertyValidation maxElements(int n) {
        return new MaxElementsValidation(n);
    }

    public static PropertyValidation maxInterval(ITimeInterval iTimeInterval) {
        return new TimeIntervalValidation(iTimeInterval, true, true, false, ValidationErrors.lessEquals(iTimeInterval));
    }

    public static PropertyValidation maxLength(int n) {
        return new MaxLengthValidation(n);
    }

    public static PropertyValidation maxWordSize(int n) {
        return new MaxWordSizeValidation(n);
    }

    public static PropertyValidation minElements(int n) {
        return new MinElementsValidation(n);
    }

    public static PropertyValidation minInterval(ITimeInterval iTimeInterval) {
        return new TimeIntervalValidation(iTimeInterval, false, true, true, ValidationErrors.greaterEquals(iTimeInterval));
    }

    public static PropertyValidation minLength(int n) {
        return new MinLengthValidation(n);
    }

    public static PropertyValidation mustBeInstanceOf(Class<? extends BaseEntity> clazz) {
        return new MustBeInstanceOfValidation(clazz);
    }

    public static PropertyValidation negativeNonZero(int n) {
        return new SignalValidation(false, false, n, ValidationErrors.negativeNonZero());
    }

    public static PropertyValidation negativeOrZero() {
        return NEGATIVE_OR_ZERO;
    }

    public static PropertyValidation noFuturePeriod() {
        return NO_FUTURE_PERIOD;
    }

    public static PropertyValidation noneOf(Collection<?> collection) {
        return new NoneOfValidation(collection);
    }

    public static PropertyValidation noPropertyOf(Collection<Class<?>> collection) {
        return new NoPropertyOfValidation(collection);
    }

    public static PropertyValidation notContains(String string) {
        return new NotContainsValidation(string);
    }

    public static PropertyValidation noUrl() {
        return new NoUrlValidation();
    }

    public static PropertyValidation pastDate() {
        return PAST_DATE;
    }

    public static PropertyValidation period() {
        return PERIOD;
    }

    public static PropertyValidation phone(ConfigurationAccessor configurationAccessor, PhoneNature phoneNature) {
        return new PhoneValidation(configurationAccessor, phoneNature);
    }

    public static PropertyValidation positiveNonZero() {
        return POSITIVE_NON_ZERO;
    }

    public static PropertyValidation positiveNonZero(int n) {
        return new SignalValidation(true, false, n, ValidationErrors.positiveNonZero());
    }

    public static PropertyValidation positiveOrZero() {
        return POSITIVE_OR_ZERO;
    }

    public static PropertyValidation positiveOrZero(int n) {
        return new SignalValidation(true, true, n, ValidationErrors.positiveOrZero());
    }

    public static PropertyValidation range(RangeOptionalType rangeOptionalType) {
        switch (rangeOptionalType) {
            case BOTH_OPTIONAL: {
                return RANGE_OPTIONAL_LIMITS;
            }
            case ONE_REQUIRED: {
                return RANGE_ONE_LIMIT_REQUIRED;
            }
            case BOTH_REQUIRED: {
                return RANGE_BOTH_LIMITS_REQUIRED;
            }
        }
        throw new IllegalStateException();
    }

    public static PropertyValidation regex(String string) {
        return new RegexValidation(string);
    }

    public static PropertyValidation required() {
        return REQUIRED;
    }

    public static PropertyValidation unique(String string, AbstractJPAQuery<?, ?> abstractJPAQuery) {
        return new UniqueValidation(string, abstractJPAQuery);
    }

    public static PropertyValidation url() {
        return URL;
    }
}

