/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import java.io.Serializable;
import java.util.Objects;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.model.messaging.notifications.AdminNotificationType;
import org.cyclos.utils.Pair;

public class AdminsToNotifyCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Long networkId;
    private final AdminNotificationType notificationType;
    private final Serializable filter;

    public AdminsToNotifyCacheKey(AdminNotificationType adminNotificationType, Long l, Object object) {
        this.networkId = l;
        this.notificationType = adminNotificationType;
        if (object instanceof SimpleEntity) {
            SimpleEntity simpleEntity = (SimpleEntity)object;
            this.filter = Pair.create((Object)simpleEntity.getClass().getName(), (Object)simpleEntity.getId());
        } else if (object instanceof Serializable) {
            this.filter = (Serializable)object;
        } else if (object == null) {
            this.filter = null;
        } else {
            throw new IllegalStateException("Invalid filter: " + String.valueOf(object));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AdminsToNotifyCacheKey adminsToNotifyCacheKey = (AdminsToNotifyCacheKey)object;
        return Objects.equals(this.filter, adminsToNotifyCacheKey.filter) && Objects.equals(this.networkId, adminsToNotifyCacheKey.networkId) && this.notificationType == adminsToNotifyCacheKey.notificationType;
    }

    public Serializable getFilter() {
        return this.filter;
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    public AdminNotificationType getNotificationType() {
        return this.notificationType;
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.networkId, this.notificationType);
    }

    public boolean matchesNetwork(Long l) {
        return Objects.equals(this.networkId, l);
    }

    public String toString() {
        return "AdminsToNotifyCacheKey [networkId=" + this.networkId + ", notificationType=" + String.valueOf(this.notificationType) + ", filter=" + String.valueOf(this.filter) + "]";
    }
}

