/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.appnotifications;

import java.util.Map;
import java.util.Objects;
import org.cyclos.entities.users.BasicUser;

public class AppNotificationMessage {
    private BasicUser user;
    private String title;
    private String body;
    private String imageUrl;
    private String customUrl;
    private Map<String, String> variables;
    private String androidIconColor;
    private boolean iosUseBadge = true;

    public static Builder builder() {
        return new Builder();
    }

    private AppNotificationMessage() {
    }

    public String getAndroidIconColor() {
        return this.androidIconColor;
    }

    public String getBody() {
        return this.body;
    }

    public String getCustomUrl() {
        return this.customUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public BasicUser getUser() {
        return this.user;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public boolean isIosUseBadge() {
        return this.iosUseBadge;
    }

    public static class Builder {
        private AppNotificationMessage notification = new AppNotificationMessage();

        private Builder() {
        }

        public AppNotificationMessage build() {
            this.validate();
            return this.notification;
        }

        public Builder setAndroidIconColor(String string) {
            this.notification.androidIconColor = string;
            return this;
        }

        public Builder setBody(String string) {
            this.notification.body = string;
            return this;
        }

        public Builder setCustomUrl(String string) {
            this.notification.customUrl = string;
            return this;
        }

        public Builder setImageUrl(String string) {
            this.notification.imageUrl = string;
            return this;
        }

        public Builder setIosUseBadge(boolean bl) {
            this.notification.iosUseBadge = bl;
            return this;
        }

        public Builder setTitle(String string) {
            this.notification.title = string;
            return this;
        }

        public Builder setUser(BasicUser basicUser) {
            this.notification.user = basicUser;
            return this;
        }

        public Builder setVariables(Map<String, String> map) {
            this.notification.variables = map;
            return this;
        }

        private void validate() {
            Objects.requireNonNull(this.notification.getBody(), "App notification message body is required");
            Objects.requireNonNull(this.notification.getTitle(), "App notification message title is required");
            Objects.requireNonNull(this.notification.getUser(), "App notification message user is required");
            Map<String, String> map = this.notification.getVariables();
            if (map != null && (map.keySet().stream().anyMatch(Objects::isNull) || map.values().stream().anyMatch(Objects::isNull))) {
                throw new NullPointerException("Some variable names (or its value) associated to the message are null");
            }
        }
    }
}

