/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users.productresolvers;

import java.util.Collection;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.users.productresolvers.ProductsResolver;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.PermissionAccountAccess;
import org.cyclos.model.banking.accounts.InternalAccountOwner;

public class HasPermissionResolver
implements ProductsResolver<Boolean, Permission> {
    private static final String MY_VISIBLE_ACCOUNTS_ATTR = "myVisibleAccounts";

    @Override
    public boolean cacheResult() {
        return false;
    }

    @Override
    public Boolean resolve(Collection<Product> collection, String string, Permission permission) {
        if (!this.roleMatches(collection, permission)) {
            return false;
        }
        PermissionAccountAccess permissionAccountAccess = permission.getAccountAccess();
        if (permissionAccountAccess != null) {
            boolean bl = false;
            switch (permissionAccountAccess) {
                case MY: {
                    InvocationContext invocationContext = InvocationContext.ensure();
                    bl = invocationContext.getAttribute(MY_VISIBLE_ACCOUNTS_ATTR, () -> {
                        AccountServiceLocal accountServiceLocal = InvocationContext.bean(AccountServiceLocal.class);
                        return !accountServiceLocal.listVisible((InternalAccountOwner)invocationContext.sessionData().getLoggedBasicUser()).isEmpty();
                    });
                    break;
                }
                case SYSTEM: {
                    bl = this.resolve(collection, string, Permission.SYSTEM_ACCOUNTS_VIEW);
                    break;
                }
                case USER: {
                    bl = this.resolve(collection, string, Permission.USER_ACCOUNTS_VIEW);
                    break;
                }
                case SYSTEM_OR_USER: {
                    boolean bl2 = bl = this.resolve(collection, string, Permission.USER_ACCOUNTS_VIEW) != false || this.resolve(collection, string, Permission.SYSTEM_ACCOUNTS_VIEW) != false;
                }
            }
            if (!bl) {
                return false;
            }
        }
        return collection.stream().anyMatch(product -> product.getPermissions().contains(permission));
    }

    private boolean roleMatches(Collection<Product> collection, Permission permission) {
        if (permission.getRoles().isEmpty()) {
            return true;
        }
        return collection.stream().anyMatch(product -> permission.getRoles().contains(product.getRole()));
    }
}

