/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.access.OidcClientAccessor;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.BrokerProductAccessor;
import org.cyclos.impl.users.EmptyAdminProductAccessor;
import org.cyclos.impl.users.EmptyBrokerProductAccessor;
import org.cyclos.impl.users.EmptyUserManagementProductAccessor;
import org.cyclos.impl.users.MemberOrBrokerProductAccessor;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.OidcMemberProductAccessor;
import org.cyclos.impl.users.OidcProductAccessor;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.UserManagementProductAccessor;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.oidcclients.Scope;

public class OidcProductsAccessor
implements ProductsAccessor {
    private final OidcAccessToken token;
    private final OidcAuthorization authorization;
    private final OidcClientAccessor accessor;
    private final Set<Scope> scopes;
    private final ProductsAccessor delegate;
    private ProductAccessor productAccessor;
    private MemberProductAccessor memberAccessor;
    private Map<UserAccountType, MemberProductAccessor> memberAccessorsPerAccount;
    private Set<Permission> permissions;

    public OidcProductsAccessor(OidcAccessToken oidcAccessToken, OidcClientAccessor oidcClientAccessor, ProductsAccessor productsAccessor) {
        this.token = oidcAccessToken;
        this.authorization = oidcAccessToken.getAuthorization();
        this.accessor = oidcClientAccessor;
        this.scopes = this.authorization.getScopes();
        this.delegate = productsAccessor;
        this.initializePermissions();
    }

    @Override
    public AdminProductAccessor admin() {
        return EmptyAdminProductAccessor.getInstance();
    }

    @Override
    public BrokerProductAccessor broker() {
        return EmptyBrokerProductAccessor.getInstance();
    }

    @Override
    public Collection<? extends Product> getProducts() {
        return this.delegate.getProducts();
    }

    @Override
    public MemberProductAccessor member() {
        if (this.memberAccessor == null) {
            this.memberAccessor = new OidcMemberProductAccessor(this.token, this.accessor, this.delegate.member(), this.permissions);
        }
        return this.memberAccessor;
    }

    @Override
    public MemberProductAccessor member(UserAccountType userAccountType) {
        MemberProductAccessor memberProductAccessor;
        if (this.memberAccessorsPerAccount == null) {
            this.memberAccessorsPerAccount = new HashMap<UserAccountType, MemberProductAccessor>();
        }
        if ((memberProductAccessor = this.memberAccessorsPerAccount.get(userAccountType)) == null) {
            memberProductAccessor = new OidcMemberProductAccessor(this.token, this.accessor, this.delegate.member(userAccountType), this.permissions);
        }
        return memberProductAccessor;
    }

    @Override
    public MemberOrBrokerProductAccessor memberOrBroker() {
        return this.member();
    }

    @Override
    public ProductAccessor product() {
        if (this.productAccessor == null) {
            this.productAccessor = new OidcProductAccessor<ProductAccessor>(this.token, this.accessor, this.delegate.product(), this.permissions);
        }
        return this.productAccessor;
    }

    @Override
    public UserManagementProductAccessor userManagement() {
        return EmptyUserManagementProductAccessor.getInstance();
    }

    private void initializePermissions() {
        this.permissions = EnumSet.of(Permission.MY_NOTIFICATIONS_ENABLE);
        if (this.scopes.contains(Scope.PAYMENT)) {
            this.permissions.add(Permission.MY_PAYMENTS_PAY_TO_USER);
        }
        if (this.scopes.contains(Scope.TICKETS)) {
            this.permissions.add(Permission.MY_PAYMENT_TICKETS_VIEW);
            this.permissions.add(Permission.MY_PAYMENT_TICKETS_CREATE);
            this.permissions.add(Permission.MY_PAYMENT_TICKETS_CANCEL);
        }
        if (this.scopes.contains(Scope.ADS_READ)) {
            this.permissions.add(Permission.USER_ADS_VIEW);
            this.permissions.add(Permission.USER_WEB_SHOP_VIEW);
        }
        if (this.scopes.contains(Scope.ADS_WRITE)) {
            this.permissions.add(Permission.MY_ADS_ENABLE);
            this.permissions.add(Permission.MY_ADS_MANAGE);
            this.permissions.add(Permission.MY_WEB_SHOP_ENABLE);
            this.permissions.add(Permission.MY_WEB_SHOP_MANAGE);
            this.permissions.add(Permission.MY_WEB_SHOP_QUESTIONS_ENABLE);
        }
        if (this.scopes.contains(Scope.PURCHASE)) {
            this.permissions.add(Permission.USER_WEB_SHOP_PURCHASE);
        }
    }
}

