/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.OidcClientAccessor;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.messaging.MessageCategory;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.UserWizard;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.ContactInfoField;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.OidcMemberOrBrokerProductAccessor;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.BooleanPropertiesHolderImpl;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.oidcclients.Scope;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.products.AccountProfileVisibility;
import org.cyclos.model.users.products.AccountVisibility;
import org.cyclos.model.users.products.BrokerVisibility;
import org.cyclos.model.users.products.MyMessagesForwardOperation;
import org.cyclos.model.users.products.UserGroupAccessibility;
import org.cyclos.model.users.products.UserProfileActivity;
import org.cyclos.model.users.users.GroupFilterDefault;

public class OidcMemberProductAccessor
extends OidcMemberOrBrokerProductAccessor<MemberProductAccessor>
implements MemberProductAccessor {
    public OidcMemberProductAccessor(OidcAccessToken oidcAccessToken, OidcClientAccessor oidcClientAccessor, MemberProductAccessor memberProductAccessor, Set<Permission> set) {
        super(oidcAccessToken, oidcClientAccessor, memberProductAccessor, set);
    }

    @Override
    public AccountAccessibility getAccountAccessibility() {
        if (!this.getUserAccounts().isEmpty()) {
            return ((MemberProductAccessor)this.delegate).getAccountAccessibility();
        }
        return AccountAccessibility.NEVER;
    }

    @Override
    public List<AccountFee> getAccountFees() {
        return Collections.emptyList();
    }

    @Override
    public AccountVisibility getAccountVisibility() {
        return ((MemberProductAccessor)this.delegate).getAccountVisibility();
    }

    @Override
    public List<TokenPrincipalType> getActivateUserTokenTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<TransferType> getChargebackPaymentTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<ContactInfoField> getContactInfoFields() {
        return Collections.emptyList();
    }

    @Override
    public BooleanPropertiesHolder<CustomOperation> getCustomOperations() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public TimeInterval getDefaultAdPublicationTime() {
        return null;
    }

    @Override
    public BigDecimal getDefaultCreditLimit() {
        return ((MemberProductAccessor)this.delegate).getDefaultCreditLimit();
    }

    @Override
    public List<BasicGroup> getDefaultFilterGroups() {
        return null;
    }

    @Override
    public BigDecimal getDefaultPaymentAmountLimit() {
        return ((MemberProductAccessor)this.delegate).getDefaultPaymentAmountLimit();
    }

    @Override
    public BigDecimal getDefaultPaymentAmountPerDayLimit() {
        return ((MemberProductAccessor)this.delegate).getDefaultPaymentAmountPerDayLimit();
    }

    @Override
    public BigDecimal getDefaultPaymentAmountPerMonthLimit() {
        return ((MemberProductAccessor)this.delegate).getDefaultPaymentAmountPerWeekLimit();
    }

    @Override
    public BigDecimal getDefaultPaymentAmountPerWeekLimit() {
        return ((MemberProductAccessor)this.delegate).getDefaultPaymentAmountPerWeekLimit();
    }

    @Override
    public BigDecimal getDefaultPaymentAmountPerYearLimit() {
        return ((MemberProductAccessor)this.delegate).getDefaultPaymentAmountPerYearLimit();
    }

    @Override
    public BigDecimal getDefaultUpperCreditLimit() {
        return ((MemberProductAccessor)this.delegate).getDefaultCreditLimit();
    }

    @Override
    public MyMessagesForwardOperation getFwdMessageToEmail() {
        return null;
    }

    @Override
    public List<GroupFilterDefault> getGroupFilterDefault() {
        return Collections.emptyList();
    }

    @Override
    public List<BasicGroup> getGroupsForUserSearch() {
        return Collections.emptyList();
    }

    @Override
    public List<BasicGroup> getGroupsForViewProfile() {
        return Collections.emptyList();
    }

    @Override
    public BigDecimal getIndividualCreditLimit() {
        return null;
    }

    @Override
    public BigDecimal getInitialCredit() {
        return null;
    }

    @Override
    public GeneratedTransferType getInitialCreditType() {
        return null;
    }

    @Override
    public List<PaymentTransferType> getMakePosPaymentTypes() {
        return Collections.emptyList();
    }

    @Override
    public int getMaxAdDescriptionSize() {
        return 0;
    }

    @Override
    public int getMaxAddressesPerAd() {
        return 0;
    }

    @Override
    public int getMaxAdImages() {
        return 0;
    }

    @Override
    public TimeInterval getMaxAdPublicationTime() {
        return null;
    }

    @Override
    public int getMaxAds() {
        return 0;
    }

    @Override
    public int getMaxCategoriesPerAd() {
        return 0;
    }

    @Override
    public int getMaxContactInfos() {
        return 0;
    }

    @Override
    public List<MemberProduct> getMemberProducts() {
        return ((MemberProductAccessor)this.delegate).getMemberProducts();
    }

    @Override
    public BooleanPropertiesHolder<AdCustomField> getMyAdFields() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public List<PaymentTransferType> getMyApproveTicketPaymentTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<PaymentTransferType> getMyCreateTicketPaymentTypes() {
        if (!this.scopes.contains(Scope.TICKETS)) {
            return Collections.emptyList();
        }
        List<PaymentTransferType> list = ((MemberProductAccessor)this.delegate).getMyCreateTicketPaymentTypes();
        list.retainAll(this.accessor.getTickets());
        return list;
    }

    @Override
    public List<PaymentTransferType> getMyExternalPaymentTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<PaymentTransferType> getMyPaymentRequestsSendToSystem() {
        return Collections.emptyList();
    }

    @Override
    public List<PaymentTransferType> getMyPaymentRequestsSendToUser() {
        return Collections.emptyList();
    }

    @Override
    public List<PaymentTransferType> getMyPaymentRequestTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<PaymentTransferType> getMyPaymentTypes() {
        if (!this.scopes.contains(Scope.PAYMENT)) {
            return Collections.emptyList();
        }
        List<PaymentTransferType> list = ((MemberProductAccessor)this.delegate).getMyPaymentTypes();
        list.retainAll(this.accessor.getPayments());
        return list;
    }

    @Override
    public BooleanPropertiesHolder<TokenPrincipalType> getMyTokenTypes() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public List<TransferFilter> getMyTransferFilters() {
        return Collections.emptyList();
    }

    @Override
    public List<PaymentTransferType> getReceivePaymentRequestTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<PaymentTransferType> getReceivePosPaymentTypes() {
        return Collections.emptyList();
    }

    @Override
    public List<UserGroupAccessibility> getSearchUsersOnGroups() {
        return Collections.singletonList(UserGroupAccessibility.NONE);
    }

    @Override
    public List<PaymentTransferType> getSelfPayments() {
        return Collections.emptyList();
    }

    @Override
    public List<MessageCategory> getSendMessagesToAdmin() {
        return Collections.emptyList();
    }

    @Override
    public AccountProfileVisibility getShowAccountInProfile() {
        return AccountProfileVisibility.HIDDEN;
    }

    @Override
    public List<UserProfileActivity> getShowActivitiesInProfile() {
        return Collections.emptyList();
    }

    @Override
    public BrokerVisibility getShowBrokers() {
        return BrokerVisibility.NONE;
    }

    @Override
    public List<PaymentTransferType> getSystemPayments() {
        return Collections.emptyList();
    }

    @Override
    public List<UserAccountType> getUserAccounts() {
        HashSet hashSet = new HashSet();
        if (this.scopes.contains(Scope.ACCOUNT_STATUS) || this.scopes.contains(Scope.ACCOUNT_HISTORY)) {
            hashSet.addAll(this.accessor.getAccounts());
        }
        if (this.scopes.contains(Scope.PAYMENT)) {
            this.accessor.getPayments().stream().map(TransferType::getFrom).filter(UserAccountType.class::isInstance).map(accountType -> (UserAccountType)accountType).forEach(hashSet::add);
        }
        if (this.scopes.contains(Scope.TICKETS)) {
            this.accessor.getTickets().stream().map(TransferType::getTo).filter(UserAccountType.class::isInstance).map(accountType -> (UserAccountType)accountType).forEach(hashSet::add);
        }
        if (hashSet.isEmpty()) {
            return Collections.emptyList();
        }
        List<UserAccountType> list = ((MemberProductAccessor)this.delegate).getUserAccounts();
        list.retainAll(hashSet);
        return list;
    }

    @Override
    public List<PaymentTransferType> getUserPayments() {
        if (!this.scopes.contains(Scope.PAYMENT)) {
            return Collections.emptyList();
        }
        List<PaymentTransferType> list = ((MemberProductAccessor)this.delegate).getUserPayments();
        list.retainAll(this.accessor.getPayments());
        return list;
    }

    @Override
    public List<Currency> getViewAdsInOtherCurrencies() {
        return Collections.emptyList();
    }

    @Override
    public List<UserGroupAccessibility> getViewProfileOnGroups() {
        return Collections.emptyList();
    }

    @Override
    public BooleanPropertiesHolder<VoucherConfiguration> getVouchers() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public BooleanPropertiesHolder<UserWizard> getWizards() {
        return BooleanPropertiesHolderImpl.empty();
    }

    @Override
    public boolean isAdsRequireAuthorization() {
        return false;
    }

    @Override
    public boolean isShowAdExpirationDate() {
        return false;
    }

    @Override
    public boolean isShowAdPublicationDate() {
        return false;
    }

    @Override
    public boolean isViewMyAccounts() {
        return (this.scopes.contains(Scope.ACCOUNT_STATUS) || this.scopes.contains(Scope.ACCOUNT_HISTORY)) && ((MemberProductAccessor)this.delegate).isViewMyAccounts();
    }

    @Override
    public boolean isWebShopAdsRequireAuthorization() {
        return false;
    }
}

