/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.impl.users.GroupsHandlerInternal;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.model.access.PermissionDeniedException;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.utils.CollectionHelper;

public class GroupListView<T extends BasicGroup, VO extends BasicGroupVO>
implements Iterable<T> {
    private Set<T> groups;
    private List<VO> sortedGroups;
    private Set<VO> defaultFilter;
    private GroupsHandlerInternal groupsHandler;

    public static <T extends BasicGroup, VO extends BasicGroupVO> GroupListView<T, VO> of(GroupsHandlerInternal groupsHandlerInternal, Set<T> set) {
        return new GroupListView<T, VO>(groupsHandlerInternal, set);
    }

    private GroupListView(GroupsHandlerInternal groupsHandlerInternal, Set<T> set) {
        this.groups = set;
        this.groupsHandler = groupsHandlerInternal;
    }

    public void check(Collection<BasicGroupVO> collection) throws PermissionDeniedException {
        if (CollectionHelper.isEmpty(collection) || CollectionHelper.size(collection) == 1 && CollectionHelper.first(collection) == null) {
            return;
        }
        Set<BasicGroup> set = this.groupsHandler.getConversionHandler().convertSet(BasicGroup.class, collection);
        PermissionHelper.checkSelection(this.items(), set, true);
    }

    public boolean containsAny(BasicGroup ... basicGroupArray) {
        if (basicGroupArray == null || basicGroupArray.length == 0) {
            return false;
        }
        return Arrays.asList(basicGroupArray).stream().anyMatch(basicGroup -> this.items().contains(basicGroup));
    }

    public Set<VO> defaultFilter() {
        if (this.defaultFilter == null) {
            this.defaultFilter = this.groupsHandler.getDefaultGroupFilter(this.groups, this.sorted());
        }
        return this.defaultFilter;
    }

    public boolean isEmpty() {
        return CollectionHelper.isEmpty(this.items());
    }

    public boolean isNotEmpty() {
        return CollectionHelper.isNotEmpty(this.items());
    }

    public Set<T> items() {
        return this.groups;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items().iterator();
    }

    public List<VO> sorted() {
        if (this.sortedGroups == null) {
            this.sortedGroups = this.groupsHandler.sortHierarchy(this.groups);
        }
        return this.sortedGroups;
    }

    public Stream<T> stream() {
        return this.items().stream();
    }
}

