/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.cyclos.impl.sql.CachingConnection;
import org.cyclos.impl.sql.DelegatingStatement;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.system.ProfilingQueryEvent;
import org.cyclos.model.system.profiling.StartProfilingParams;

public class ProfilingStatement
extends DelegatingStatement {
    protected final StartProfilingParams profilingParams;
    protected final ProfilingEntry profilingEntry;
    protected List<ProfilingQueryEvent> batch;

    public ProfilingStatement(StartProfilingParams startProfilingParams, ProfilingEntry profilingEntry, Statement statement) {
        super(statement);
        this.profilingParams = startProfilingParams;
        this.profilingEntry = profilingEntry;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (this.batch == null) {
            this.batch = new ArrayList<ProfilingQueryEvent>();
        }
        this.batch.add(new ProfilingQueryEvent(string));
        super.addBatch(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string) throws SQLException {
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        try {
            boolean bl = super.execute(string);
            return bl;
        }
        finally {
            this.finishExecution(profilingQueryEvent, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int n) throws SQLException {
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        try {
            boolean bl = super.execute(string, n);
            return bl;
        }
        finally {
            this.finishExecution(profilingQueryEvent, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        try {
            boolean bl = super.execute(string, nArray);
            return bl;
        }
        finally {
            this.finishExecution(profilingQueryEvent, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        try {
            boolean bl = super.execute(string, stringArray);
            return bl;
        }
        finally {
            this.finishExecution(profilingQueryEvent, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray = null;
        try {
            int[] nArray2 = nArray = super.executeBatch();
            return nArray2;
        }
        finally {
            if (nArray == null) {
                this.batch.forEach(profilingQueryEvent -> this.finishExecution((ProfilingQueryEvent)profilingQueryEvent, null));
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    this.finishExecution(this.batch.get(i), nArray[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        long[] lArray = null;
        try {
            long[] lArray2 = lArray = super.executeLargeBatch();
            return lArray2;
        }
        finally {
            if (lArray == null) {
                this.batch.forEach(profilingQueryEvent -> this.finishExecution((ProfilingQueryEvent)profilingQueryEvent, null));
            } else {
                for (int i = 0; i < lArray.length; ++i) {
                    this.finishExecution(this.batch.get(i), (int)lArray[i]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        long l;
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        Long l2 = null;
        try {
            l2 = super.executeLargeUpdate(string);
            l = l2;
            this.finishExecution(profilingQueryEvent, l2 == null ? null : Integer.valueOf(l2.intValue()));
        }
        catch (Throwable throwable) {
            this.finishExecution(profilingQueryEvent, l2 == null ? null : Integer.valueOf(l2.intValue()));
            throw throwable;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, int n) throws SQLException {
        long l;
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        Long l2 = null;
        try {
            l2 = super.executeLargeUpdate(string, n);
            l = l2;
            this.finishExecution(profilingQueryEvent, l2 == null ? null : Integer.valueOf(l2.intValue()));
        }
        catch (Throwable throwable) {
            this.finishExecution(profilingQueryEvent, l2 == null ? null : Integer.valueOf(l2.intValue()));
            throw throwable;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        long l;
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        Long l2 = null;
        try {
            l2 = super.executeLargeUpdate(string, nArray);
            l = l2;
            this.finishExecution(profilingQueryEvent, l2 == null ? null : Integer.valueOf(l2.intValue()));
        }
        catch (Throwable throwable) {
            this.finishExecution(profilingQueryEvent, l2 == null ? null : Integer.valueOf(l2.intValue()));
            throw throwable;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        long l;
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        Long l2 = null;
        try {
            l2 = super.executeLargeUpdate(string, stringArray);
            l = l2;
            this.finishExecution(profilingQueryEvent, l2 == null ? null : Integer.valueOf(l2.intValue()));
        }
        catch (Throwable throwable) {
            this.finishExecution(profilingQueryEvent, l2 == null ? null : Integer.valueOf(l2.intValue()));
            throw throwable;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        try {
            ResultSet resultSet = super.executeQuery(string);
            return resultSet;
        }
        finally {
            this.finishExecution(profilingQueryEvent, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string) throws SQLException {
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        int n = -1;
        try {
            int n2 = n = super.executeUpdate(string);
            return n2;
        }
        finally {
            this.finishExecution(profilingQueryEvent, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        int n2 = -1;
        try {
            int n3 = n2 = super.executeUpdate(string, n);
            return n3;
        }
        finally {
            this.finishExecution(profilingQueryEvent, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        int n = -1;
        try {
            int n2 = n = super.executeUpdate(string, nArray);
            return n2;
        }
        finally {
            this.finishExecution(profilingQueryEvent, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        ProfilingQueryEvent profilingQueryEvent = this.newProfilingQuery(string);
        int n = -1;
        try {
            int n2 = n = super.executeUpdate(string, stringArray);
            return n2;
        }
        finally {
            this.finishExecution(profilingQueryEvent, n);
        }
    }

    private void finishExecution(ProfilingQueryEvent profilingQueryEvent, Integer n) {
        if (profilingQueryEvent != null) {
            profilingQueryEvent.end();
            if (n != null && n >= 0) {
                profilingQueryEvent.setRowsUpdated(n);
            }
            this.profilingEntry.addEvent(profilingQueryEvent);
        }
    }

    private ProfilingQueryEvent newProfilingQuery(String string) {
        if (this.profilingParams.isIncludeLowLevelQueries() || !CachingConnection.isLowLevelQuery(string)) {
            return new ProfilingQueryEvent(string);
        }
        return null;
    }
}

