/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.logging;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cyclos.entities.system.LogConfiguration;
import org.cyclos.impl.logging.LoggingHandler;
import org.cyclos.impl.logging.ServiceLogParams;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.utils.Pair;

public class LogContext {
    private static final LogContext EMPTY_INSTANCE = new LogContext(null, null);
    private final LoggingHandler loggingHandler;
    private final JsonConverter jsonConverter;
    private LogConfiguration logConfiguration;
    private ServiceLogParams logParams;
    private boolean isWrite;
    private boolean skipSuccess;

    public static LogContext empty() {
        return EMPTY_INSTANCE;
    }

    public LogContext(LoggingHandler loggingHandler, JsonConverter jsonConverter) {
        this.loggingHandler = loggingHandler;
        this.jsonConverter = jsonConverter;
    }

    public void logService() {
        if (!(this.logParams == null || this.logParams.getError() == null && this.skipSuccess)) {
            if (this.loggingHandler == null || this.logConfiguration == null) {
                throw new IllegalStateException("Invalid log context: null logging handler or configuration!");
            }
            this.loggingHandler.logService(this.logConfiguration, this.logParams, this.isWrite);
        }
    }

    public void setError(Throwable throwable) {
        if (this.logParams != null) {
            this.logParams.setError(throwable);
            this.logParams.setErrorStackTrace(throwable == null ? null : ExceptionUtils.getStackTrace((Throwable)throwable));
            try {
                this.logParams.setErrorJson(throwable == null ? null : this.jsonConverter.writeValueAsString((Object)this.jsonConverter.errorToLogNode(throwable)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LogContext setLogConfiguration(LogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
        return this;
    }

    public LogContext setResult(Pair<Object, JsonNode> pair) {
        if (this.logParams != null && pair != null) {
            this.logParams.setResult(pair.getFirst());
            try {
                JsonNode jsonNode = (JsonNode)pair.getSecond();
                this.logParams.setResultJson(jsonNode == null ? null : this.jsonConverter.writeValueAsString((Object)jsonNode));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public LogContext setServiceLogParams(ServiceLogParams serviceLogParams) {
        this.logParams = serviceLogParams;
        return this;
    }

    public void setSkipSuccess(boolean bl) {
        this.skipSuccess = bl;
    }

    public LogContext setTimeTaken(long l) {
        if (this.logParams != null) {
            this.logParams.setTimeTaken(l);
        }
        return this;
    }

    public LogContext setWrite(boolean bl) {
        this.isWrite = bl;
        return this;
    }
}

