/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.mysema.commons.lang.CloseableIterator;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherChargeback;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.impl.banking.VoucherDetailsOnPayment;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.vouchers.SendVoucherDTO;
import org.cyclos.model.banking.vouchers.VoucherTransactionNature;
import org.cyclos.model.utils.Transaction;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.services.banking.VoucherService;

public interface VoucherServiceLocal
extends VoucherService {
    public static final int MASKED_TOKEN_LENGTH = 4;
    public static final String ATTR_VOUCHER_TYPE = "voucherType";
    public static final String ATTR_VOUCHER = "voucher";
    public static final String ATTR_VOUCHER_CREATION_TYPE = "voucherCreationType";

    public void block(Voucher var1);

    public VoucherChargeback chargeback(Payment var1);

    public int countTotalOpenVouchers();

    public void expire(Voucher var1);

    public void expireActivation(Voucher var1);

    public void fill(AccountHistoryEntryVO var1, Long var2, List<String> var3, String var4, VoucherTransactionNature var5, Long var6);

    public Voucher findByToken(String var1, Collection<VoucherConfiguration> var2);

    public String formatMobilePhone(Voucher var1);

    public String formatToken(Voucher var1);

    public VoucherDetailsOnPayment getDetailsOnPayment(Payment var1);

    public boolean hasAmountReservation(Voucher var1);

    public CloseableIterator<Voucher> iterateVouchers(VoucherPack var1);

    public void notifyAboutToExpire(Voucher var1);

    @Transaction(value=TransactionLevel.READ_WRITE)
    @Deprecated
    default public List<String> resendPinForRedeem(@NotNull String string) throws FrameworkException {
        return this.resendPinForRedeem(string, null);
    }

    public Voucher sendByImport(SendVoucherDTO var1);

    public boolean showPinOnDetails(Voucher var1);

    public boolean showQrCode(Voucher var1);

    public boolean usePin(Voucher var1);

    public void validate(SendVoucherDTO var1);
}

