/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.ChannelSettingsAccessor;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.system.InternetAddressList;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.PinChannelConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.ConfigurationHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.SessionDataSubjectId;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.IpAddressServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.access.InvalidNetworkException;
import org.cyclos.model.access.InvalidSessionDataException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.system.channelconfigurations.RegistrationWithIdentityProviders;
import org.cyclos.model.system.channelconfigurations.UserChannelAccess;
import org.cyclos.utils.StringHelper;
import org.springframework.context.ApplicationContext;

public abstract class AbstractSessionData
implements SessionData {
    protected final RequestData requestData;
    private ApplicationContext applicationContext;
    private RawEntityManagerHandler _rawEntityManagerHandler;
    private IpAddressServiceLocal _ipAddressService;
    private String channelName;
    private String accessChannelName;
    private Long configurationId;
    private ConfigurationAccessor configurationAccessor;
    private ProductsAccessor products;
    private SessionDataSubjectId subjectId;

    public AbstractSessionData(RequestData requestData) {
        if (requestData == null) {
            throw new NullPointerException("RequestData is null");
        }
        this.requestData = requestData;
    }

    @Override
    public void checkConsistency() throws InvalidSessionDataException {
        if (this.shouldCheckRemoteAddress() && !this.getIpAddressService().isAllowed(this.getRemoteAddress())) {
            throw new RemoteAddressBlockedException();
        }
        Network network = this.getNetwork();
        if (network != null && !network.isEnabled()) {
            throw new InvalidNetworkException();
        }
    }

    @Override
    public final Channel getAccessChannel() {
        if (this.accessChannelName == null) {
            this.accessChannelName = StringHelper.trimToNull((Object)this.getAccessChannelName());
            if (this.accessChannelName == null) {
                this.accessChannelName = BuiltInChannel.MAIN.getInternalName();
            }
        }
        return this.bean(ChannelServiceLocal.class).find(this.accessChannelName, this.getNetwork());
    }

    public AccessClient getAccessClient() {
        return null;
    }

    @Override
    public OidcAccessToken getAccessToken() {
        return null;
    }

    public UserAccountType getAccountType() {
        return null;
    }

    public BasicUser getBasicUser() {
        return null;
    }

    @Override
    public final Channel getChannel() {
        if (this.channelName == null) {
            this.channelName = StringHelper.trimToNull((Object)this.getChannelName());
            if (this.channelName == null) {
                this.channelName = BuiltInChannel.MAIN.getInternalName();
            }
        }
        return this.bean(ChannelServiceLocal.class).find(this.channelName, this.getNetwork());
    }

    @Override
    public ChannelAccessAccessor getChannelAccessAccessor() {
        return new SessionDataChannelAccessAccessor(this.getConfiguration());
    }

    public ChannelConfiguration getChannelConfiguration() {
        return this.getConfiguration().getChannelConfiguration(this.getChannel());
    }

    @Override
    public ChannelSettingsAccessor getChannelSettingsAccessor() {
        return this.getChannelConfiguration();
    }

    @Override
    public final ConfigurationAccessor getConfiguration() {
        if (this.configurationAccessor == null) {
            this.configurationAccessor = this.doGetConfigurationAccessor();
        }
        return this.configurationAccessor;
    }

    public UserCustomFieldValue getCustomFieldValue() {
        return null;
    }

    @Override
    public IdentityProvider getIdentityProvider() {
        return null;
    }

    public IpAddressServiceLocal getIpAddressService() {
        if (this._ipAddressService == null) {
            this._ipAddressService = this.bean(IpAddressServiceLocal.class);
        }
        return this._ipAddressService;
    }

    @Override
    public final Operator getLoggedOperator() {
        BasicUser basicUser = this.getLoggedBasicUser();
        return basicUser == null || !basicUser.isOperator() ? null : (Operator)basicUser;
    }

    @Override
    public final User getLoggedUser() {
        BasicUser basicUser = this.getLoggedBasicUser();
        return basicUser == null ? null : basicUser.getUser();
    }

    public MobilePhone getMobilePhone() {
        return null;
    }

    @Override
    public final Network getNetwork() {
        Long l = this.resolveNetworkId();
        return l == null ? null : this.getRawEntityManagerHandler().find(Network.class, l);
    }

    @Override
    public Pin getPin() {
        return null;
    }

    public String getPrincipal() {
        return null;
    }

    public PrincipalType getPrincipalType() {
        return null;
    }

    @Override
    public final ProductsAccessor getProducts() {
        if (this.products == null) {
            this.products = this.doGetProducts();
        }
        return this.products;
    }

    @Override
    public String getRemoteAddress() {
        return this.getRequestData().getRemoteAddress();
    }

    @Override
    public final RequestData getRequestData() {
        return this.requestData;
    }

    @Override
    public Session getSession() {
        return null;
    }

    @Override
    public SessionDataSubjectId getSubjectId() {
        if (this.subjectId == null) {
            this.subjectId = this.doGetSubjectId();
        }
        return this.subjectId;
    }

    public Token getToken() {
        return null;
    }

    public TrustedDevice getTrustedDevice() {
        return null;
    }

    @Override
    public final boolean hasPermission(Permission permission) {
        if (permission == null) {
            return false;
        }
        return this.doHasPermission(permission);
    }

    public boolean isAdmin() {
        return false;
    }

    @Override
    public boolean isAdminOf(BasicUser basicUser) {
        return false;
    }

    public boolean isAliasOperator() {
        return false;
    }

    public boolean isBroker() {
        return false;
    }

    @Override
    public boolean isBrokerOf(BasicUser basicUser) {
        return false;
    }

    public boolean isGlobalAdmin() {
        return false;
    }

    @Override
    public boolean isGlobalAdminInNetwork() {
        return this.isAdmin() && this.getNetwork() != null && this.getLoggedUser().isGlobal();
    }

    @Override
    public boolean isGuest() {
        return false;
    }

    @Override
    public boolean isLoggedIn() {
        return false;
    }

    @Override
    public boolean isManagerOf(BasicUser basicUser) {
        return this.isAdminOf(basicUser) || this.isBrokerOf(basicUser);
    }

    public boolean isMember() {
        return false;
    }

    public boolean isMemberOnly() {
        return false;
    }

    @Override
    public boolean isMultiNetworkAdminInGlobalMode() {
        return this.isAdmin() && this.getNetwork() == null && !this.getLoggedUser().isGlobalAdmin();
    }

    public boolean isNetworkAdmin() {
        return false;
    }

    public boolean isOperator() {
        return false;
    }

    @Override
    public boolean isOwnerOf(BasicUser basicUser) {
        return false;
    }

    public boolean isRestrictedOperator() {
        return false;
    }

    @Override
    public boolean isScript() {
        return false;
    }

    @Override
    public boolean isSelf(BasicUser basicUser) {
        if (basicUser == null) {
            return false;
        }
        return basicUser.getUser().equals((Object)this.getLoggedUser());
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public boolean isTrusted() {
        return this.getTrustedDevice() != null;
    }

    public boolean isUserManager() {
        return this.isAdmin() || this.isBroker();
    }

    @Override
    public SessionData unwrap() {
        return this;
    }

    protected <T> T bean(Class<T> clazz) {
        return (T)this.getApplicationContext().getBean(clazz);
    }

    protected ConfigurationAccessor doGetConfigurationAccessor() {
        List<String> list = this.doGetPreferredLocales();
        return this.bean(ConfigurationHandler.class).getAccessor(this.getConfigurationEntity(), list);
    }

    protected abstract Long doGetConfigurationId();

    protected List<String> doGetPreferredLocales() {
        RequestData requestData = this.getRequestData();
        return requestData == null ? null : requestData.getLocales();
    }

    protected abstract ProductsAccessor doGetProducts();

    protected abstract SessionDataSubjectId doGetSubjectId();

    protected abstract boolean doHasPermission(Permission var1);

    protected ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            this.applicationContext = InvocationContext.getApplicationContext();
        }
        return this.applicationContext;
    }

    protected final Configuration getConfigurationEntity() {
        if (this.configurationId == null) {
            this.configurationId = this.doGetConfigurationId();
        }
        return this.configurationId == null ? null : this.getRawEntityManagerHandler().find(Configuration.class, this.configurationId);
    }

    protected RawEntityManagerHandler getRawEntityManagerHandler() {
        if (this._rawEntityManagerHandler == null) {
            this._rawEntityManagerHandler = this.bean(RawEntityManagerHandler.class);
        }
        return this._rawEntityManagerHandler;
    }

    protected <T> T runAsSystem(Callable<T> callable) {
        return this.runAsSystem(callable, true);
    }

    protected <T> T runAsSystem(Callable<T> callable, boolean bl) {
        SessionData sessionData = bl ? SessionDataFactory.system(this.getRequestData(), this.getChannelName()) : SessionDataFactory.system(this.getRequestData());
        return InvocationContext.bean(InvokerHandler.class).runAs(sessionData, callable);
    }

    protected boolean shouldCheckRemoteAddress() {
        return true;
    }

    private Long resolveNetworkId() {
        RequestData requestData = this.getRequestData();
        Long l = requestData == null ? null : requestData.getNetworkId();
        return l;
    }

    public class SessionDataChannelAccessAccessor
    implements ChannelAccessAccessor {
        private final ConfigurationAccessor configuration;
        private ChannelConfiguration _channel;
        private ChannelConfiguration _access;

        public SessionDataChannelAccessAccessor(ConfigurationAccessor configurationAccessor) {
            this.configuration = configurationAccessor;
        }

        public PasswordType getAccessPassword() {
            return this.access().getAccessPassword();
        }

        public Channel getChannel() {
            return this.access().getChannel();
        }

        public CredentialsConfiguration getConfirmation() {
            return this.access().getConfirmation();
        }

        public PrincipalType getDefaultPrincipalType() {
            return this.access().getDefaultPrincipalType();
        }

        public Set<IdentityProvider> getIdentityProviders() {
            return this.access().getIdentityProviders();
        }

        public CredentialsConfiguration getLoginConfirmation() {
            return this.access().getLoginConfirmation();
        }

        public PinChannelConfiguration getPinConfiguration() {
            return this.access().getPinConfiguration();
        }

        public Set<PrincipalType> getPrincipalTypes() {
            return this.access().getPrincipalTypes();
        }

        public RegistrationWithIdentityProviders getRegistrationWithIdentityProviders() {
            return this.access().getRegistrationWithIdentityProviders();
        }

        public TimeInterval getSessionTimeout() {
            return this.access().getSessionTimeout();
        }

        public Integer getTrustedDeviceOnStartup() {
            return this.access().getTrustedDeviceOnStartup();
        }

        public UserChannelAccess getUserAccess() {
            return this.access().getUserAccess();
        }

        public InternetAddressList getWhitelist() {
            return this.access().getWhitelist();
        }

        public boolean isConfirmationOncePerSession() {
            return this.channel().isConfirmationOncePerSession();
        }

        public boolean isRequireAuthenticationForDeviceConfirmation() {
            return this.access().isRequireAuthenticationForDeviceConfirmation();
        }

        public boolean isRequireTrustedDeviceForLogin() {
            return this.channel().isRequireTrustedDeviceForLogin();
        }

        public boolean isSkipConfirmationForTrustedDevices() {
            return this.channel().isSkipConfirmationForTrustedDevices();
        }

        public boolean isUseIpWhitelist() {
            return this.access().isUseIpWhitelist();
        }

        private ChannelConfiguration access() {
            if (this._access == null) {
                this._access = this.configuration.getChannelConfiguration(AbstractSessionData.this.getAccessChannel());
            }
            return this._access;
        }

        private ChannelConfiguration channel() {
            if (this._channel == null) {
                this._channel = this.configuration.getChannelConfiguration(AbstractSessionData.this.getChannel());
            }
            return this._channel;
        }
    }
}

