/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.CollectionPathBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cyclos.entities.system.CustomField;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.PropertyLogDescriptor;
import org.cyclos.impl.TablePropertyLogDescriptor;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.CustomFieldPropertyAccess;
import org.cyclos.impl.utils.validation.EntityPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.IterableProperty;
import org.cyclos.model.NestedProperty;
import org.cyclos.model.Property;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;

public class EntityLogDescriptor<B extends Bean> {
    private Set<String> missingProperties = new HashSet<String>();
    private List<PropertyLogDescriptor<B>> properties = new ArrayList<PropertyLogDescriptor<B>>();
    private EntityLogDescriptor<?> containerDescriptor;
    private Property<B, ?> nestedBeanProperty;
    private Function<Property<?, ?>, PropertyAccess> nestedAccessMapper;
    private MessageKey nestedPropertyLabelKey;
    private Class<B> beanType;

    public EntityLogDescriptor(Class<B> clazz) {
        this.beanType = clazz;
        Bean bean = (Bean)ClassHelper.instantiate(clazz);
        this.missingProperties.addAll(bean.propertyMap().keySet());
        this.defaultIgnore(this.missingProperties);
    }

    private EntityLogDescriptor(Property<B, ?> property, MessageKey messageKey, Function<Property<?, ?>, PropertyAccess> function, EntityLogDescriptor<?> entityLogDescriptor) {
        this(property.getType());
        this.containerDescriptor = entityLogDescriptor;
        this.nestedBeanProperty = property;
        this.nestedAccessMapper = function;
        this.nestedPropertyLabelKey = messageKey;
    }

    public <T extends Bean> EntityLogDescriptor<T> addNested() {
        if (this.containerDescriptor != null) {
            this.validate();
            this.properties.stream().forEach(propertyLogDescriptor -> this.containerDescriptor.addPropertyDescriptor((PropertyLogDescriptor<?>)propertyLogDescriptor));
            this.containerDescriptor.ignore(this.nestedBeanProperty);
            return this.containerDescriptor;
        }
        return this;
    }

    public <T extends B> EntityLogDescriptor<T> cast() {
        return this;
    }

    public EntityLogDescriptor<B> customField(final CustomField<?, ?, ?> customField, CustomFieldValueHandler customFieldValueHandler) {
        CustomField<?, ?, ?> customField2;
        PropertyAccess propertyAccess;
        final CustomFieldPropertyAccess customFieldPropertyAccess = new CustomFieldPropertyAccess(customField, customFieldValueHandler, false);
        if (this.nestedBeanProperty != null) {
            final BeanPropertyAccess beanPropertyAccess = new BeanPropertyAccess(this.nestedBeanProperty);
            propertyAccess = new PropertyAccess(){

                @Override
                public Object get(Object object) {
                    Object object2 = beanPropertyAccess.get(object);
                    return object2 == null ? null : customFieldPropertyAccess.get(object2);
                }

                @Override
                public Object getIdentifier() {
                    return customField;
                }

                @Override
                public String getPropertyName() {
                    return EntityLogDescriptor.this.nestedBeanProperty.getName() + "." + customField.getInternalName();
                }
            };
            customField2 = this.nestedPropertyLabelKey == null ? customField : this.nestedLabel(this.nestedPropertyLabelKey, customField);
        } else {
            propertyAccess = customFieldPropertyAccess;
            customField2 = customField;
        }
        return this.addPropertyDescriptor(new PropertyLogDescriptor(this, propertyAccess).label(customField2));
    }

    public EntityLogDescriptor<B> customFields(Iterable<? extends CustomField<?, ?, ?>> iterable, CustomFieldValueHandler customFieldValueHandler) {
        if (iterable != null) {
            iterable.forEach(customField -> this.customField((CustomField<?, ?, ?>)customField, customFieldValueHandler));
        }
        return this;
    }

    public Set<String> getMissingProperties() {
        return this.missingProperties;
    }

    public List<PropertyLogDescriptor<B>> getProperties() {
        return this.properties;
    }

    public EntityLogDescriptor<B> ignore(Property<?, ? super B> property) {
        return this.ignore(property.getName());
    }

    public EntityLogDescriptor<B> ignore(String string) {
        this.missingProperties.remove(string);
        return this;
    }

    public boolean isIgnored(Property<?, ?> property) {
        return !this.missingProperties.contains(property.getName());
    }

    public <N extends Bean> EntityLogDescriptor<N> nested(Property<N, ? super B> property) {
        return this.nested(property, null);
    }

    public <N extends Bean> EntityLogDescriptor<N> nested(Property<N, ? super B> property2, MessageKey messageKey) {
        return this.nested(property2, messageKey, property -> this.toAccess((Property<?, ?>)property));
    }

    public <N extends Bean> EntityLogDescriptor<N> nested(Property<N, ? super B> property, MessageKey messageKey, Function<Property<?, ?>, PropertyAccess> function) {
        return new EntityLogDescriptor<N>(property, messageKey, function, this);
    }

    public EntityLogDescriptor<B> property(Property<?, ? super B> property, MessageKey messageKey) {
        MessageKey messageKey2;
        PropertyAccess propertyAccess;
        if (this.nestedBeanProperty != null) {
            NestedProperty nestedProperty = NestedProperty.nested(this.nestedBeanProperty, property);
            propertyAccess = this.nestedAccessMapper.apply((Property<?, ?>)nestedProperty);
            messageKey2 = this.nestedPropertyLabelKey == null ? messageKey : this.nestedLabel(this.nestedPropertyLabelKey, messageKey);
        } else {
            propertyAccess = this.toAccess(property);
            messageKey2 = messageKey;
        }
        this.addPropertyDescriptor(new PropertyLogDescriptor(this, propertyAccess).label(messageKey2));
        return this.ignore(property);
    }

    public EntityLogDescriptor<B> property(PropertyAccess propertyAccess, MessageKey messageKey) {
        this.addPropertyDescriptor(new PropertyLogDescriptor(this, propertyAccess).label(messageKey));
        return this.ignore(propertyAccess.getPropertyName());
    }

    public EntityLogDescriptor<B> propertyOrIgnore(Property<?, ? super B> property, MessageKey messageKey, boolean bl) {
        if (bl) {
            return this.property(property, messageKey);
        }
        return this.ignore(property);
    }

    public <R extends EntityDTO> TablePropertyLogDescriptor<R, B> tableProperty(CollectionPathBase<?, ?, ?> collectionPathBase, Object object) {
        return new TablePropertyLogDescriptor(this, this.toAccess((Path<?>)collectionPathBase)).label(object);
    }

    public <R extends EntityDTO> TablePropertyLogDescriptor<R, B> tableProperty(IterableProperty<R, ?, ? super B> iterableProperty, Object object) {
        return this.tableProperty(this.toAccess((Property<?, ?>)iterableProperty), object);
    }

    public <R extends EntityDTO> TablePropertyLogDescriptor<R, B> tableProperty(PropertyAccess propertyAccess, Object object) {
        return new TablePropertyLogDescriptor(this, propertyAccess).label(object);
    }

    public void validate() {
        if (CollectionHelper.isNotEmpty(this.missingProperties)) {
            throw new IllegalStateException("Some properties were not mapped / ignored for bean: " + String.valueOf(this.beanType) + ". Please check the corresponding entity log handler. Properties: " + String.valueOf(this.missingProperties));
        }
    }

    private FormatterImpl getFormatter() {
        InvocationContext invocationContext = InvocationContext.get();
        return invocationContext.formatter(invocationContext.sessionData().getConfiguration());
    }

    private String nestedLabel(Object ... objectArray) {
        FormatterImpl formatterImpl = this.getFormatter();
        return Stream.of(objectArray).map(formatterImpl::format).collect(Collectors.joining(" - "));
    }

    EntityLogDescriptor<B> addPropertyDescriptor(PropertyLogDescriptor<B> propertyLogDescriptor) {
        this.properties.add(propertyLogDescriptor);
        return this;
    }

    void defaultIgnore(Set<String> set) {
        set.remove(EntityDTO.ID.getName());
        set.remove(EntityDTO.VERSION.getName());
    }

    EntityPropertyAccess toAccess(Path<?> path) {
        return new EntityPropertyAccess(path);
    }

    BeanPropertyAccess toAccess(Property<?, ?> property) {
        return new BeanPropertyAccess(property);
    }
}

