package v4_13

import org.cyclos.impl.InvokerHandler
import org.cyclos.impl.banking.TicketServiceLocal
import org.cyclos.impl.banking.TicketWebhookSender
import org.cyclos.impl.utils.notifications.NotificationHandler
import org.springframework.jdbc.core.ColumnMapRowMapper
import org.springframework.jdbc.core.JdbcTemplate

import groovy.transform.Field
import groovy.transform.TypeChecked

@Field JdbcTemplate jdbc = binding.jdbc
@Field InvokerHandler invokerHandler = binding.invokerHandler
@Field TicketServiceLocal ticketService = binding.ticketService
@Field NotificationHandler notificationHandler = binding.notificationHandler

@TypeChecked
int process() {
    def mapper = new ColumnMapRowMapper()
    def webhooks = jdbc.query("select * from pending_ticket_webhooks", mapper)
    webhooks.each { row ->
        def ticketNumber = row.ticket_number as String
        def url = row.url as String
        def sender = new TicketWebhookSender(ticketNumber, url, invokerHandler, ticketService, notificationHandler)
        invokerHandler.executorService.submit(sender)
    }
    jdbc.execute("drop table pending_ticket_webhooks")
    return webhooks.size()
}

return process()
