import org.cyclos.bootstrap.BootstrapConfiguration
import org.cyclos.bootstrap.ServicesConfiguration
import org.cyclos.entities.system.Network
import org.cyclos.entities.users.BasicUser
import org.cyclos.entities.users.UserPrincipal
import org.cyclos.entities.utils.UserPrincipals
import org.cyclos.impl.InvocationContext
import org.cyclos.impl.InvokerHandler
import org.cyclos.impl.access.SessionData
import org.cyclos.impl.access.SessionDataFactory
import org.cyclos.impl.system.ScriptHelper
import org.cyclos.impl.users.LocateUserOption
import org.cyclos.impl.users.UserLocatorHandler
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler
import org.cyclos.model.users.users.UserLocatorVO
import org.cyclos.model.utils.TransactionLevel
import org.cyclos.server.utils.IOHelper
import org.cyclos.server.utils.PropertiesHelper
import org.springframework.context.annotation.AnnotationConfigApplicationContext

import groovy.cli.picocli.CliBuilder

/*
 * WARNING:
 * This file is deprecated, and will no longer be provided with Cyclos 4.17 onwards.
 * For more details, refer to
 * https://documentation.cyclos.org/current/cyclos-reference/#scripting-debug
 */

// Parser for command-line arguments
def cli = new CliBuilder(usage: "RunScript <options>", header: "Options:")
cli.network(args: 1, "The network internal name. Default: run in global mode")
cli.config(args: 1, "The cyclos.properties file to use."
+ " Default: cyclos.properties in the current directory.")
cli.init(args: 1, "The script that will return a Map with bindings to emulate the real execution of the script."
+ " Default: no initialization script.")
cli.params(args: 1, "The properties file passed to the script as scriptParameters."
+ " Default: no parameters.")
cli.script(args: 1, required: true, "The script file to run. Required.")
def options = cli.parse(args)
if (!options) {
    System.exit(10)
}

// Read the script file
def scriptFile = new File(options.script)
if (!scriptFile.exists()) {
    println("Script file not found: ${scriptFile.absolutePath}")
    System.exit(11)
}

// Read the initialization file
def initFile = options.init ? new File(options.init) : null
if (initFile != null && !initFile.exists()) {
    println("Initialization script file not found: ${initFile.absolutePath}")
    System.exit(12)
}

// Read the parameters file
def paramsFile = options.params ? new File(options.params) : null
if (paramsFile != null && !paramsFile.exists()) {
    println("Parameters file not found: ${paramsFile.absolutePath}")
    System.exit(13)
}

// Read the configuration file
def configStr = options.config ?: 'src/cyclos.properties'
def configFile = new File(configStr)
if (!configFile.exists()) {
    println("Configuration file not found: ${configFile.absolutePath}")
    System.exit(14)
}

// Show the configuration arguments
println("""Running with arguments:
* Network: ${options.network ?: '<global mode>'}
* Configuration file: ${configFile.absolutePath}
* Script file: ${scriptFile.absolutePath}
* Initialization script file: ${initFile?.absolutePath ?: '<none>'}
* Parameters file: ${paramsFile?.absolutePath ?: '<none>'}
""")

// Initialize the Spring context
System.setProperty("cyclos.maxBackgroundTasks", "0");
System.setProperty("cyclos.maxRecurringTasks", "0");
System.setProperty("cyclos.properties", configFile.getAbsolutePath())
System.setProperty("file.encoding", "UTF-8")
def appCtx = new AnnotationConfigApplicationContext()
appCtx.register(BootstrapConfiguration.class)
appCtx.register(ServicesConfiguration.class)
appCtx.refresh();
try {
    def scriptHelper = appCtx.getBean(ScriptHelper)
    def invokerHandler = appCtx.getBean(InvokerHandler)
    def rawEntityManagerHandler = appCtx.getBean(RawEntityManagerHandler)
    def scriptParameters = paramsFile ? PropertiesHelper.from(new FileInputStream(paramsFile)) : [:]

    // Load the script and run in a transaction
    def result = invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE) { status ->
        def entityManager = rawEntityManagerHandler.entityManager
        def shell = new GroovyShell()

        // When running in a network, initialize the corresponding session data. Otherwise, global system
        def sessionData = SessionDataFactory.system()
        if (options.network) {
            def network = entityManager.createQuery("from Network n where n.internalName = :net")
                    .setParameter('net', options.network)
                    .singleResult
            sessionData = SessionDataFactory.system(network)
        }

        // Helper to run a script with the current context
        def runScript = { file, extra ->
            def script = shell.parse(file)

            // Initialize the script binding with each exposed bean to scripts
            script.binding.scriptHelper = scriptHelper
            scriptHelper.beanMap.forEach(script.binding.&setVariable)
            script.binding.entityManager = entityManager
            script.binding.formatter = InvocationContext.getFormatter()
            script.binding.scriptParameters = scriptParameters
            extra.forEach(script.binding.&setVariable)
            if (extra.sessionData instanceof SessionData) {
                sessionData = extra.sessionData
            } else if (extra.runAs) {
                UserPrincipal principal
                if (extra.runAs instanceof BasicUser) {
                    principal = UserPrincipals.username(extra.runAs)
                } else {
                    def userLocatorHandler = appCtx.getBean(UserLocatorHandler)
                    def find = { Network network ->
                        return userLocatorHandler.locate(
                                network,
                                new UserLocatorVO(principal: extra.runAs.toString()),
                                EnumSet.of(LocateUserOption.IGNORE_HIDDEN))
                    }
                    try {
                        // Find in the network itself
                        principal = find(sessionData.network)
                    } catch (Exception e) {
                        // Find in the global
                        principal = find(null)
                    }
                }
                sessionData = SessionDataFactory.direct(principal)
                        .basedOn(sessionData)
                        .build()
            }
            script.binding.sessionData = SessionDataFactory.script(sessionData, extra.runAsSystem == true)

            return invokerHandler.runAs(script.binding.sessionData) {
                return script.run()
            }
        }

        // Run the initialization script, if any
        def extra = initFile ? runScript(initFile, [:]) ?: [:] : [:]

        // Run the real script
        println()
        return runScript(scriptFile, extra) as String
    }
    println("\nReturn value from script:\n${result}")
} finally {
    IOHelper.close(appCtx)
}
System.exit(0)
