-- OTHER TABLES

-- Full text search configuration
create text search configuration unaccent (copy = simple);
alter text search configuration unaccent
    alter mapping for hword, hword_part, word
    with unaccent, simple;

-- Create the geography columns
alter table addresses add column geography geography(Point);
create index on addresses using gist (geography);

-- Create the tsvector columns
alter table users add column name_tsvector tsvector;
alter table ads add column name_tsvector tsvector, add column description_tsvector tsvector;
alter table user_custom_field_values add column value_tsvector tsvector;
alter table contact_custom_field_values add column value_tsvector tsvector;
alter table ad_custom_field_values add column value_tsvector tsvector;
alter table record_custom_field_values add column value_tsvector tsvector;
alter table addresses
    add column full_tsvector tsvector,
    add column address_tsvector tsvector,
    add column neighborhood_tsvector tsvector,
    add column city_tsvector tsvector,
    add column region_tsvector tsvector;

create index ix_users_name_tsvector on users using gin(name_tsvector);
create index ix_ads_name_tsvector on ads using gin(name_tsvector);
create index ix_ads_description_tsvector on ads using gin(description_tsvector);
create index ix_user_custom_field_values_value_tsvector on user_custom_field_values using gin(value_tsvector);
create index ix_contact_custom_field_values_value_tsvector on contact_custom_field_values using gin(value_tsvector);
create index ix_ad_custom_field_values_value_tsvector on ad_custom_field_values using gin(value_tsvector); 
create index ix_record_custom_field_values_value_tsvector on record_custom_field_values using gin(value_tsvector); 
create index ix_addresses_full_tsvector on addresses using gin(full_tsvector);
create index ix_addresses_address_tsvector on addresses using gin(address_tsvector);
create index ix_addresses_neighborhood_tsvector on addresses using gin(neighborhood_tsvector);
create index ix_addresses_city_tsvector on addresses using gin(city_tsvector);
create index ix_addresses_region_tsvector on addresses using gin(region_tsvector);

-- Additional columns 
alter table addresses
    add column normalized_zip varchar(255),
    add column normalized_po_box varchar(255);

create index ix_addresses_normalized_zip on addresses(normalized_zip);
create index ix_addresses_normalized_po_box on addresses(normalized_po_box);

alter table stored_files add column lo_id oid;

-- Additional sequences
create sequence seq_transaction_numbers;

-- Drop redundant indexes (other multi-column indexes replaces them)
drop index if exists ix_account_balances_fk_account_balances_transfer_id;
drop index if exists ix_dirty_account_balances_fk_dirty_account_balances_transfer_id;
drop index if exists ix_dirty_account_balances_fk_dirty_account_balances_account_id;
drop index if exists srccntntfcationsettingsfksrccntntificationsettingsaccounttypeid;
drop index if exists srccntntificationsettingsfksrccntnotificationsettingssettingsid;
drop index if exists prtrgrpccntntfctnsttingsfkprtrgrpccntntfctnsttingsaccounttypeid;
drop index if exists prtrgrpccntntfctonsettingsfkprtrgrpccntntfcationsettingsgroupid;
drop index if exists ix_transfers_fk_transfers_from_id;
drop index if exists ix_transfers_fk_transfers_to_id;
drop index if exists ix_amount_reservations_fk_amount_reservations_account_id;
drop index if exists closed_account_balances_fk_closed_account_balances_account_id;
drop index if exists ix_transactions_fk_transactions_from_id;
drop index if exists ix_transactions_fk_transactions_to_id;

-- Recreate indexes as covering indexes
drop index if exists ix_transfers_from_id_date;
create index ix_transfers_from_id_date on transfers (from_id, date) include (amount);
drop index if exists ix_transfers_to_id_date;
create index ix_transfers_to_id_date on transfers (to_id, date) include (amount);
drop index if exists ix_amount_reservations_account_id_date;
create index ix_amount_reservations_account_id_date on amount_reservations (account_id, date) include (amount);

-- The background task context can be very large. Use a hash instead for uniqueness.
drop index if exists ix_background_task_executions;
create unique index ix_background_task_executions on background_task_executions (class_name, digest(context, 'sha512'));

-- Creates partial indexes
drop index if exists ix_accounts_fk_accounts_account_rates_id;
drop index if exists ix_accounts_archiving_date;

create index ix_accounts_fk_accounts_account_rates_id on accounts (account_rates_id) where account_rates_id is not null;
create index ix_accounts_archiving_date on accounts (archiving_date) where archiving_date is not null;

drop index if exists ix_type_ownerEntityId;
drop index if exists ix_type_relatedEntityId;

create index ix_type_ownerEntityId on entity_logs (type, owner_entity_id) where owner_entity_id is not null;
create index ix_type_relatedEntityId on entity_logs (type, related_entity_id) where related_entity_id is not null;

drop index if exists ix_transactions_creation_type;
drop index if exists ix_transactions_fk_transactions_by_id;
drop index if exists ix_transactions_fk_transactions_transaction_id;
drop index if exists ix_transactions_fk_transactions_received_by_id;
drop index if exists ix_transactions_fk_transactions_external_principal_type_id;
drop index if exists ix_transactions_fk_transactions_principal_type_id;
drop index if exists ix_transactions_status;
drop index if exists ix_transactions_show_to_receiver;
drop index if exists ix_transactions_fk_transactions_next_authorization_level_id;
drop index if exists ix_transactions_fk_transactions_access_client_id;
drop index if exists ix_external_principal_value;
drop index if exists ix_ticket_number;
drop index if exists ix_transactions_transaction_number;
drop index if exists ix_transactions_fk_transactions_oidc_client_id;
drop index if exists ix_transactions_pending_notification;
drop index if exists ix_transactions_sms_code;

create index ix_transactions_creation_type on transactions (creation_type) where creation_type is not null;
create index ix_transactions_fk_transactions_by_id on transactions (by_id) where by_id is not null;
create index ix_transactions_fk_transactions_transaction_id on transactions (transaction_id) where transaction_id is not null;
create index ix_transactions_fk_transactions_received_by_id on transactions (received_by_id) where received_by_id is not null;
create index ix_transactions_fk_transactions_external_principal_type_id on transactions (external_principal_type_id) where external_principal_type_id is not null;
create index ix_transactions_fk_transactions_principal_type_id on transactions (principal_type_id) where principal_type_id is not null;
create index ix_transactions_status on transactions (status) where status is not null;
create index ix_transactions_show_to_receiver on transactions (show_to_receiver) where show_to_receiver = true;
create index ix_transactions_fk_transactions_next_authorization_level_id on transactions (next_authorization_level_id) where next_authorization_level_id is not null;
create index ix_transactions_fk_transactions_access_client_id on transactions (access_client_id) where access_client_id is not null;
create index ix_external_principal_value on transactions (external_principal_value) where external_principal_value is not null;
create index ix_ticket_number on transactions (lower(ticket_number)) where ticket_number is not null;
create index ix_transactions_transaction_number on transactions (lower(transaction_number)) where transaction_number is not null;
create index ix_transactions_fk_transactions_oidc_client_id on transactions (oidc_client_id) where oidc_client_id is not null;
create index ix_transactions_pending_notification on transactions (pending_notification) where pending_notification is true;
create index ix_transactions_sms_code on transactions (sms_code) where sms_code is not null;

drop index if exists ix_vouchers_fk_vouchers_activation_id;
drop index if exists ix_vouchers_email;
drop index if exists ix_vouchers_mobile_phone;

create index ix_vouchers_fk_vouchers_activation_id on vouchers (activation_id) where activation_id is not null;
create index ix_vouchers_email on vouchers (lower(email)) where email is not null;
create index ix_vouchers_mobile_phone on vouchers (mobile_phone) where mobile_phone is not null;

drop index if exists ix_transfers_fk_transfers_chargeback_of_id;
drop index if exists ix_transfers_fk_transfers_charged_back_by_id;
drop index if exists ix_transfers_fk_transfers_installment_id;
drop index if exists ix_transfers_fk_transfers_parent_id;
drop index if exists ix_transfers_fk_transfers_transaction_id;
drop index if exists ix_transfers_fk_transfers_transfer_fee_id;
drop index if exists ix_transfers_fk_transfers_account_fee_log_id;
drop index if exists ix_transfers_transaction_number;
drop index if exists ix_transfers_pending_notification;

create index ix_transfers_fk_transfers_chargeback_of_id on transfers (chargeback_of_id) where chargeback_of_id is not null;
create index ix_transfers_fk_transfers_transaction_id on transfers (transaction_id) where transaction_id is not null;
create index ix_transfers_fk_transfers_transfer_fee_id on transfers (transfer_fee_id) where transfer_fee_id is not null;
create index ix_transfers_fk_transfers_charged_back_by_id on transfers (charged_back_by_id) where charged_back_by_id is not null;
create unique index ix_transfers_fk_transfers_installment_id on transfers (installment_id) where installment_id is not null;
create index ix_transfers_fk_transfers_parent_id on transfers (parent_id) where parent_id is not null;
create index ix_transfers_fk_transfers_account_fee_log_id on transfers (account_fee_log_id) where account_fee_log_id is not null;
create index ix_transfers_transaction_number on transfers (lower(transaction_number)) where transaction_number is not null;
create index ix_transfers_pending_notification on transfers (pending_notification) where pending_notification is true;

drop index if exists ix_amount_reservations_fk_amount_reservations_transaction_id;
drop index if exists ix_amount_reservations_fk_amount_reservations_order_id;
drop index if exists ix_amount_reservations_fk_amount_reservations_voucher_id;
drop index if exists ix_amount_reservations_fk_amount_reservations_voucher_transaction_id;
drop index if exists ix_amount_reservations_fk_amount_reservations_voucher_pack_id;
drop index if exists ix_amount_reservations_fk_amount_reservations_installment_id;

create index ix_amount_reservations_fk_amount_reservations_transaction_id on amount_reservations (transaction_id) where transaction_id is not null;
create index ix_amount_reservations_fk_amount_reservations_order_id on amount_reservations (order_id) where order_id is not null;
create index ix_amount_reservations_fk_amount_reservations_voucher_id on amount_reservations (voucher_id) where voucher_id is not null;
create index ix_amount_reservations_fk_amount_reservations_voucher_transaction_id on amount_reservations (voucher_transaction_id) where voucher_transaction_id is not null;
create index ix_amount_reservations_fk_amount_reservations_voucher_pack_id on amount_reservations (voucher_pack_id) where voucher_pack_id is not null;
create index ix_amount_reservations_fk_amount_reservations_installment_id on amount_reservations (installment_id) where installment_id is not null;

drop index if exists ix_pins_fk_pins_access_client_id;
drop index if exists ix_pins_fk_pins_account_type_id;
drop index if exists ix_pins_fk_pins_trusted_device_id;
drop index if exists ix_pins_fk_pins_user_custom_field_value_id;
drop index if exists ix_pins_fk_pins_mobile_phone_id;
drop index if exists ix_pins_fk_pins_token_id;

create index ix_pins_fk_pins_access_client_id on pins (access_client_id) where access_client_id is not null;
create index ix_pins_fk_pins_account_type_id on pins (account_type_id) where account_type_id is not null;
create index ix_pins_fk_pins_trusted_device_id on pins (trusted_device_id) where trusted_device_id is not null;
create index ix_pins_fk_pins_user_custom_field_value_id on pins (user_custom_field_value_id) where user_custom_field_value_id is not null;
create index ix_pins_fk_pins_mobile_phone_id on pins (mobile_phone_id) where mobile_phone_id is not null;
create index ix_pins_fk_pins_token_id on pins (token_id) where token_id is not null;

drop index if exists ix_stored_files_fk_stored_files_record_custom_field_id;
drop index if exists ix_stored_files_fk_stored_files_transaction_value_id;
drop index if exists ix_stored_files_fk_stored_files_voucher_type_id;
drop index if exists ix_stored_files_fk_stored_files_voucher_category_id;
drop index if exists ix_stored_files_fk_stored_files_contact_info_value_id;
drop index if exists ix_stored_files_fk_stored_files_by_user_id;
drop index if exists ix_stored_files_fk_stored_files_user_custom_field_id;
drop index if exists ix_stored_files_fk_stored_files_ad_value_id;
drop index if exists ix_stored_files_fk_stored_files_network_id;
drop index if exists ix_stored_files_fk_stored_files_ad_id;
drop index if exists ix_stored_files_fk_stored_files_imported_file_id;
drop index if exists ix_stored_files_fk_stored_files_user_id;
drop index if exists ix_stored_files_fk_stored_files_contact_info_field_id;
drop index if exists ix_stored_files_fk_stored_files_contact_value_id;
drop index if exists ix_stored_files_fk_stored_files_ad_custom_field_id;
drop index if exists ix_stored_files_fk_stored_files_transaction_custom_field_id;
drop index if exists ix_stored_files_fk_stored_files_configuration_id;
drop index if exists ix_stored_files_fk_stored_files_record_value_id;
drop index if exists ix_stored_files_fk_stored_files_contact_info_id;
drop index if exists ix_stored_files_fk_stored_files_system_image_category_id;
drop index if exists ix_stored_files_fk_stored_files_user_value_id;
drop index if exists ix_stored_files_fk_stored_files_oidc_client_id;
drop index if exists ix_stored_files_fk_stored_files_theme_id;
drop index if exists ix_stored_files_fk_stored_files_ad_category_id;
drop index if exists ix_stored_files_fk_stored_files_contact_custom_field_id;

create index ix_stored_files_fk_stored_files_record_custom_field_id on stored_files (record_custom_field_id)  where record_custom_field_id is not null;
create index ix_stored_files_fk_stored_files_transaction_value_id on stored_files (transaction_value_id) where transaction_value_id is not null;
create index ix_stored_files_fk_stored_files_voucher_type_id on stored_files (voucher_type_id) where voucher_type_id is not null;
create index ix_stored_files_fk_stored_files_voucher_category_id on stored_files (voucher_category_id) where voucher_category_id is not null;
create index ix_stored_files_fk_stored_files_contact_info_value_id on stored_files (contact_info_value_id) where contact_info_value_id is not null;
create index ix_stored_files_fk_stored_files_by_user_id on stored_files (by_user_id) where by_user_id is not null;
create index ix_stored_files_fk_stored_files_user_custom_field_id on stored_files (user_custom_field_id) where user_custom_field_id is not null;
create index ix_stored_files_fk_stored_files_ad_value_id on stored_files (ad_value_id) where ad_value_id is not null;
create index ix_stored_files_fk_stored_files_network_id on stored_files (network_id) where network_id is not null;
create index ix_stored_files_fk_stored_files_ad_id on stored_files (ad_id) where ad_id is not null;
create index ix_stored_files_fk_stored_files_imported_file_id on stored_files (imported_file_id) where imported_file_id is not null;
create index ix_stored_files_fk_stored_files_user_id on stored_files (user_id) where user_id is not null;
create index ix_stored_files_fk_stored_files_contact_info_field_id on stored_files (contact_info_field_id) where contact_info_field_id is not null;
create index ix_stored_files_fk_stored_files_contact_value_id on stored_files (contact_value_id) where contact_value_id is not null;
create index ix_stored_files_fk_stored_files_ad_custom_field_id on stored_files (ad_custom_field_id) where ad_custom_field_id is not null;
create index ix_stored_files_fk_stored_files_transaction_custom_field_id on stored_files (transaction_custom_field_id) where transaction_custom_field_id is not null;
create index ix_stored_files_fk_stored_files_configuration_id on stored_files (configuration_id) where configuration_id is not null;
create index ix_stored_files_fk_stored_files_record_value_id on stored_files (record_value_id) where record_value_id is not null;
create index ix_stored_files_fk_stored_files_contact_info_id on stored_files (contact_info_id) where contact_info_id is not null;
create index ix_stored_files_fk_stored_files_system_image_category_id on stored_files (system_image_category_id) where system_image_category_id is not null;
create index ix_stored_files_fk_stored_files_user_value_id on stored_files (user_value_id) where user_value_id is not null;
create index ix_stored_files_fk_stored_files_oidc_client_id on stored_files (oidc_client_id) where oidc_client_id is not null;
create index ix_stored_files_fk_stored_files_theme_id on stored_files (theme_id) where theme_id is not null;
create index ix_stored_files_fk_stored_files_ad_category_id on stored_files (ad_category_id) where ad_category_id is not null;
create index ix_stored_files_fk_stored_files_contact_custom_field_id on stored_files (contact_custom_field_id) where contact_custom_field_id is not null;

drop index if exists ix_ad_custom_field_values_linked_entity_id;
drop index if exists ix_contact_custom_field_values_linked_entity_id;
drop index if exists ix_contact_info_field_values_linked_entity_id;
drop index if exists ix_record_custom_field_values_linked_entity_id;
drop index if exists ix_transaction_custom_field_values_linked_entity_id;
drop index if exists ix_user_custom_field_values_linked_entity_id;

create index ix_ad_custom_field_values_linked_entity_id on ad_custom_field_values (linked_entity_id) where linked_entity_id is not null;
create index ix_contact_custom_field_values_linked_entity_id on contact_custom_field_values (linked_entity_id) where linked_entity_id is not null;
create index ix_contact_info_field_values_linked_entity_id on contact_info_field_values (linked_entity_id) where linked_entity_id is not null;
create index ix_record_custom_field_values_linked_entity_id on record_custom_field_values (linked_entity_id) where linked_entity_id is not null;
create index ix_transaction_custom_field_values_linked_entity_id on transaction_custom_field_values (linked_entity_id) where linked_entity_id is not null;
create index ix_user_custom_field_values_linked_entity_id on user_custom_field_values (linked_entity_id) where linked_entity_id is not null;

drop index if exists ix_users_new_email;
drop index if exists ix_users_fk_users_invited_by_id;
create index ix_users_new_email on users (lower(new_email)) where new_email is not null;
create index ix_users_fk_users_invited_by_id on users (invited_by_id) where invited_by_id is not null;

drop index if exists ix_accounts_system;
create index ix_accounts_system on accounts (subclass) where subclass = 'SYSTEM';

drop index if exists backgroundtaskexecutionsfk_background_task_executions_custom_id;
create index backgroundtaskexecutionsfk_background_task_executions_custom_id on background_task_executions (custom_id) where custom_id is not null;

drop index if exists ix_addresses_latlng;
create index ix_addresses_latlng on addresses (latitude, longitude) where latitude is null and longitude is null;

drop index if exists ix_ad_orders_pending_by_admin;
create index ix_ad_orders_pending_by_admin on ad_orders (pending_by_admin) where pending_by_admin is true;

alter table ad_dyna_values alter column value type text;
alter table contact_dyna_values alter column value type text;
alter table transaction_dyna_values alter column value type text;
alter table user_dyna_values alter column value type text;
alter table record_dyna_values alter column value type text;
alter table contact_info_dyna_values alter column value type text;

-- Create the table to keep track of the already imported system images
create table imported_system_images (
    name varchar(255) not null primary key
);
 
-- These tables are only used by cyclos4-archive, and are here to improve performance
create table transactions_to_archive (
    id bigint not null primary key
);
create table installments_to_archive (
    id bigint not null primary key
);
create table transfers_to_archive (
    id bigint not null primary key,
    transaction_id bigint
);
create table referenced_transfers (
    id bigint not null primary key,
    transaction_id bigint
);
create table referenced_transactions (
    id bigint not null primary key
);
create table transfers_hierarchy (
    id bigint not null primary key,
    transaction_id bigint
);
create index ix_transfers_hierarchy_transaction_id on transfers_hierarchy (transaction_id) where transaction_id is not null;

create table reservations_to_archive (
    id bigint not null primary key,
    transaction_id bigint
);
