/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.thymeleaf;

import java.util.List;
import java.util.stream.Stream;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.AccountWrapper;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.thymeleaf.ThymeleafExpressionObject;
import org.cyclos.impl.utils.thymeleaf.ThymeleafWrappers;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountsExpressionObject
implements ThymeleafExpressionObject {
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private AccountHandler accountHandler;
    @Autowired
    private ConversionHandler conversionHandler;
    @Autowired
    private ThymeleafWrappers thymeleafWrappers;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;

    public Stream<AccountWrapper> all() {
        InternalAccountOwner internalAccountOwner = this.accountHandler.locateOrCurrent(null).getInternalAccountOwner();
        if (internalAccountOwner == null) {
            return Stream.empty();
        }
        List list = this.accountService.listVisible(internalAccountOwner);
        return list.stream().map(this.thymeleafWrappers::wrap);
    }

    public AccountWrapper first() {
        return this.get("account");
    }

    public AccountWrapper get(Object object) {
        try {
            Account account = null;
            if (object instanceof CharSequence) {
                account = this.accountService.load(this.accountHandler.getAccountOwner(), object.toString());
            } else if (object instanceof IEntity) {
                AccountType accountType = (AccountType)this.conversionHandler.convert(AccountType.class, object);
                account = this.accountService.load(this.accountHandler.getAccountOwner(), accountType);
            }
            return account == null || !this.accountServiceSecurity.hasVisibility(account) ? null : this.thymeleafWrappers.wrap(account);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return "accounts";
    }
}

