/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.tasks;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import org.cyclos.entities.QSimpleEntity;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionRecurringTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.IdRangeBackgroundTask;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class IdRangeDispatchingRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    private QSimpleEntity $;
    private Class<? extends IdRangeBackgroundTask> bgTaskClass;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;

    public IdRangeDispatchingRecurringTask(QSimpleEntity qSimpleEntity, Class<? extends IdRangeBackgroundTask> clazz) {
        this.$ = qSimpleEntity;
        this.bgTaskClass = clazz;
    }

    protected void afterExecute() {
    }

    protected abstract long batchSize();

    protected boolean beforeExecute() {
        return true;
    }

    @Override
    protected final long execute() throws Throwable {
        long l;
        if (!this.beforeExecute()) {
            return 0L;
        }
        long l2 = this.batchSize();
        if (l2 < 1L) {
            l2 = Long.MAX_VALUE;
        }
        long l3 = this.getMaxId();
        String string = this.getJoinCode();
        Long l4 = null;
        if (string != null) {
            l = (long)Math.ceil((double)l3 / (double)l2);
            l4 = this.backgroundTaskHandler.newForkJoin(l, string, new String[0]);
        }
        l = this.nativeQueryHandler.insertIdRangeBackgroundTasks(this.bgTaskClass, l3, l2, this.getPayload(), l4);
        this.afterExecute();
        if (l > 0L) {
            this.recurringTaskHandler.scheduleAwake(BackgroundTaskExecutionRecurringTask.class);
        }
        return l;
    }

    protected String getJoinCode() {
        return null;
    }

    protected String getPayload() {
        return null;
    }

    @Override
    protected final boolean isRunInTransaction() {
        return true;
    }

    private long getMaxId() {
        return (Long)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).select((Expression)this.$.id.max()).fetchOne();
    }
}

