/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.system.PaymentSmsOperationConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.utils.sms.BaseSmsOperation;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.SmsOperationFormatterImpl;
import org.cyclos.impl.utils.sms.SmsParameterProcessor;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.banking.InsufficientBalanceException;
import org.cyclos.model.banking.MaxAmountPerDayExceededException;
import org.cyclos.model.banking.MaxAmountPerMonthExceededException;
import org.cyclos.model.banking.MaxAmountPerWeekExceededException;
import org.cyclos.model.banking.MaxAmountPerYearExceededException;
import org.cyclos.model.banking.MaxPaymentAmountExceededException;
import org.cyclos.model.banking.MaxPaymentsPerDayExceededException;
import org.cyclos.model.banking.MaxPaymentsPerMonthExceededException;
import org.cyclos.model.banking.MaxPaymentsPerWeekExceededException;
import org.cyclos.model.banking.MinTimeBetweenPaymentsException;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.UpperCreditLimitReachedException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.transactions.PaymentVO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transfertypes.PaymentTransferTypeRestrictTo;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.security.Security;
import org.cyclos.services.banking.PaymentService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;

public class PaymentSmsOperation
extends BaseSmsOperation {
    private static final Logger LOG = LogManager.getLogger(PaymentSmsOperation.class);
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    @Security
    protected PaymentService paymentService;
    String msgText = "";

    public static void handleTransferException(AccountOwner accountOwner, BigDecimal bigDecimal, TransferException transferException, SmsOperationFormatterImpl smsOperationFormatterImpl, PaymentTransferType paymentTransferType) {
        try {
            throw transferException;
        }
        catch (InsufficientBalanceException insufficientBalanceException) {
            throw new SmsOperationException((Throwable)insufficientBalanceException, (Object)PaymentError.PAYER_INSUFICIENT_BALANCE.getMessageKey(), new Object[]{new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal), smsOperationFormatterImpl.format(accountOwner)});
        }
        catch (MaxAmountPerDayExceededException maxAmountPerDayExceededException) {
            throw new SmsOperationException((Throwable)maxAmountPerDayExceededException, (Object)PaymentError.PAYER_MAX_AMOUNT_PER_DAY_EXCEEDED.getMessageKey(), new Object[]{smsOperationFormatterImpl.format((INamedEntity)paymentTransferType), smsOperationFormatterImpl.format(accountOwner), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal)});
        }
        catch (MaxAmountPerWeekExceededException maxAmountPerWeekExceededException) {
            throw new SmsOperationException((Throwable)maxAmountPerWeekExceededException, (Object)PaymentError.PAYER_MAX_AMOUNT_PER_WEEK_EXCEEDED.getMessageKey(), new Object[]{smsOperationFormatterImpl.format((INamedEntity)paymentTransferType), smsOperationFormatterImpl.format(accountOwner), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal)});
        }
        catch (MaxAmountPerMonthExceededException maxAmountPerMonthExceededException) {
            throw new SmsOperationException((Throwable)maxAmountPerMonthExceededException, (Object)PaymentError.PAYER_MAX_AMOUNT_PER_MONTH_EXCEEDED.getMessageKey(), new Object[]{smsOperationFormatterImpl.format((INamedEntity)paymentTransferType), smsOperationFormatterImpl.format(accountOwner), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal)});
        }
        catch (MaxAmountPerYearExceededException maxAmountPerYearExceededException) {
            throw new SmsOperationException((Throwable)maxAmountPerYearExceededException, (Object)PaymentError.PAYER_MAX_AMOUNT_PER_YEAR_EXCEEDED.getMessageKey(), new Object[]{smsOperationFormatterImpl.format((INamedEntity)paymentTransferType), smsOperationFormatterImpl.format(accountOwner), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal)});
        }
        catch (MaxPaymentAmountExceededException maxPaymentAmountExceededException) {
            throw new SmsOperationException((Throwable)maxPaymentAmountExceededException, (Object)PaymentError.PAYER_MAX_PAYMENT_AMOUNT_EXCEEDED.getMessageKey(), new Object[]{smsOperationFormatterImpl.format((INamedEntity)paymentTransferType), smsOperationFormatterImpl.format(accountOwner), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal)});
        }
        catch (MaxPaymentsPerDayExceededException maxPaymentsPerDayExceededException) {
            throw new SmsOperationException((Throwable)maxPaymentsPerDayExceededException, (Object)PaymentError.PAYER_MAX_TRANSFERS_PER_DAY_EXCEEDED.getMessageKey(), new Object[]{smsOperationFormatterImpl.format((INamedEntity)paymentTransferType), smsOperationFormatterImpl.format(accountOwner), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal)});
        }
        catch (MaxPaymentsPerWeekExceededException maxPaymentsPerWeekExceededException) {
            throw new SmsOperationException((Throwable)maxPaymentsPerWeekExceededException, (Object)PaymentError.PAYER_MAX_TRANSFERS_PER_WEEK_EXCEEDED.getMessageKey(), new Object[]{smsOperationFormatterImpl.format((INamedEntity)paymentTransferType), smsOperationFormatterImpl.format(accountOwner), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal)});
        }
        catch (MaxPaymentsPerMonthExceededException maxPaymentsPerMonthExceededException) {
            throw new SmsOperationException((Throwable)maxPaymentsPerMonthExceededException, (Object)PaymentError.PAYER_MAX_TRANSFERS_PER_MONTH_EXCEEDED.getMessageKey(), new Object[]{smsOperationFormatterImpl.format((INamedEntity)paymentTransferType), smsOperationFormatterImpl.format(accountOwner), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal)});
        }
        catch (MinTimeBetweenPaymentsException minTimeBetweenPaymentsException) {
            throw new SmsOperationException((Throwable)minTimeBetweenPaymentsException, (Object)PaymentError.PAYER_MIN_TIME_BETWEEN_TRANSFERS.getMessageKey(), new Object[]{smsOperationFormatterImpl.format((INamedEntity)paymentTransferType), smsOperationFormatterImpl.format(accountOwner), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal)});
        }
        catch (UpperCreditLimitReachedException upperCreditLimitReachedException) {
            throw new SmsOperationException((Throwable)upperCreditLimitReachedException, (Object)PaymentError.PAYEE_UPPER_CREDIT_LIMIT_REACHED.getMessageKey(), new Object[]{smsOperationFormatterImpl.format((INamedEntity)paymentTransferType), smsOperationFormatterImpl.format(accountOwner), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal)});
        }
    }

    @Override
    protected void checkParametersCount(SmsOperationConfiguration smsOperationConfiguration, List<String> list) throws SmsOperationException {
        PaymentSmsOperationConfiguration paymentSmsOperationConfiguration = (PaymentSmsOperationConfiguration)smsOperationConfiguration;
        boolean bl = paymentSmsOperationConfiguration.isUsePassword();
        int n = bl ? 3 : 2;
        PaymentTransferType paymentTransferType = paymentSmsOperationConfiguration.getPaymentType();
        if (paymentTransferType.isUseFixedAmount()) {
            --n;
        }
        if (paymentTransferType.isToSystem() || this.isFixedPayee(paymentTransferType)) {
            --n;
        }
        if (CollectionHelper.size(list) != n) {
            throw new SmsOperationException((Object)BaseSmsOperation.BaseError.INVALID_PARAMETERS_COUNT.getMessageKey(), new Object[]{n, n});
        }
    }

    @Override
    protected void doExecute(SmsOperationConfiguration smsOperationConfiguration, MobilePhone mobilePhone, InboundSmsData inboundSmsData, SmsParameterProcessor smsParameterProcessor) throws SmsOperationException {
        BigDecimal bigDecimal;
        LOG.debug(String.format("Executing SMS Payment operation (user: %1$s, sms: %2$s)", mobilePhone.getUser().getUsername(), inboundSmsData));
        PaymentSmsOperationConfiguration paymentSmsOperationConfiguration = (PaymentSmsOperationConfiguration)smsOperationConfiguration;
        PaymentTransferType paymentTransferType = paymentSmsOperationConfiguration.getPaymentType();
        PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
        performPaymentDTO.setType((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)paymentTransferType));
        performPaymentDTO.setOwner((InternalAccountOwner)mobilePhone.getUser());
        Object object = paymentTransferType.isToSystem() ? SystemAccountOwner.instance() : (this.isFixedPayee(paymentTransferType) ? (InternalAccountOwner)CollectionHelper.first((Iterable)paymentTransferType.getRestrictToUsers()) : smsParameterProcessor.nextUserForPayment((Object)MessagingKeys.Notifications.SMS_PAYMENT_PARAMETER_PAYEE));
        performPaymentDTO.setSubject((InternalAccountOwner)object);
        BigDecimal bigDecimal2 = paymentTransferType.isUseFixedAmount() ? paymentTransferType.getFixedAmount() : smsParameterProcessor.nextAmount((Object)MessagingKeys.Notifications.SMS_PAYMENT_PARAMETER_AMOUNT, paymentTransferType.getFrom().getCurrency().getPrecision());
        performPaymentDTO.setAmount(bigDecimal2);
        PaymentVO paymentVO = null;
        try {
            paymentVO = this.paymentService.perform(performPaymentDTO);
        }
        catch (TransferException transferException) {
            PaymentSmsOperation.handleTransferException((AccountOwner)performPaymentDTO.getSubject(), bigDecimal2, transferException, this.getFormatter(), paymentTransferType);
        }
        AccountType accountType = paymentTransferType.getFrom();
        Account account = this.accountService.load((InternalAccountOwner)mobilePhone.getUser(), accountType);
        try {
            bigDecimal = this.accountService.getAvailableBalance(account, null);
        }
        catch (IllegalActionException illegalActionException) {
            bigDecimal = null;
        }
        boolean bl = paymentTransferType.getCurrency().isTransactionNumberEnabled();
        AccountVO accountVO = paymentVO.getTo();
        Object[] objectArray = new Object[]{paymentTransferType, paymentTransferType.isToSystem() ? accountVO.getType().getName() : this.formatShort((AccountOwner)accountVO.getOwner()), paymentVO.getCurrencyAmount(), new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal), bl ? this.message(MessagingKeys.Notifications.TRANSACTION_NUMBER, paymentVO.getTransactionNumber()) : ""};
        if (paymentVO.getAuthorizationStatus() == TransactionAuthorizationStatus.PENDING_AUTHORIZATION) {
            this.sendResponse(mobilePhone, this.message(bigDecimal == null ? MessagingKeys.Notifications.SMS_PAYMENT_RESPONSE_PENDING_AUTHORIZATION_NO_BALANCE : MessagingKeys.Notifications.SMS_PAYMENT_RESPONSE_PENDING_AUTHORIZATION, objectArray));
        } else {
            this.sendResponse(mobilePhone, this.message(bigDecimal == null ? MessagingKeys.Notifications.SMS_PAYMENT_RESPONSE_SUCCESSFULLY_NO_BALANCE : MessagingKeys.Notifications.SMS_PAYMENT_RESPONSE_SUCCESSFULLY, objectArray));
        }
    }

    @Override
    protected List<String> getHelpComponents(SmsOperationConfiguration smsOperationConfiguration) {
        PaymentSmsOperationConfiguration paymentSmsOperationConfiguration = (PaymentSmsOperationConfiguration)smsOperationConfiguration;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (paymentSmsOperationConfiguration.isUsePassword()) {
            PasswordType passwordType = smsOperationConfiguration.getChannelConfiguration().getAccessPassword();
            arrayList.add(this.dataTranslationHandler.getName((NamedEntity)passwordType));
        }
        if (!this.isFixedPayee(paymentSmsOperationConfiguration.getPaymentType())) {
            arrayList.add(this.message(MessagingKeys.Notifications.SMS_PAYMENT_PARAMETER_PAYEE, new Object[0]));
        }
        if (!paymentSmsOperationConfiguration.getPaymentType().isUseFixedAmount()) {
            arrayList.add(this.message(MessagingKeys.Notifications.SMS_PAYMENT_PARAMETER_AMOUNT, new Object[0]));
        }
        return arrayList;
    }

    private boolean isFixedPayee(PaymentTransferType paymentTransferType) {
        return paymentTransferType.getRestrictTo() == PaymentTransferTypeRestrictTo.SPECIFIC_USERS && CollectionHelper.size((Collection)paymentTransferType.getRestrictToUsers()) == 1;
    }

    private static enum PaymentError implements HasMessageKey
    {
        PAYER_INSUFICIENT_BALANCE(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_INSUFICIENT_BALANCE),
        PAYER_MAX_AMOUNT_PER_DAY_EXCEEDED(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_MAX_AMOUNT_PER_DAY_EXCEEDED),
        PAYER_MAX_AMOUNT_PER_WEEK_EXCEEDED(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_MAX_AMOUNT_PER_WEEK_EXCEEDED),
        PAYER_MAX_AMOUNT_PER_MONTH_EXCEEDED(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_MAX_AMOUNT_PER_MONTH_EXCEEDED),
        PAYER_MAX_AMOUNT_PER_YEAR_EXCEEDED(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_MAX_AMOUNT_PER_YEAR_EXCEEDED),
        PAYER_MAX_PAYMENT_AMOUNT_EXCEEDED(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_MAX_PAYMENT_AMOUNT_EXCEEDED),
        PAYER_MAX_TRANSFERS_PER_DAY_EXCEEDED(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_MAX_TRANSFERS_PER_DAY_EXCEEDED),
        PAYER_MAX_TRANSFERS_PER_WEEK_EXCEEDED(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_MAX_TRANSFERS_PER_WEEK_EXCEEDED),
        PAYER_MAX_TRANSFERS_PER_MONTH_EXCEEDED(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_MAX_TRANSFERS_PER_MONTH_EXCEEDED),
        PAYER_MIN_TIME_BETWEEN_TRANSFERS(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYER_MIN_TIME_BETWEEN_TRANSFERS),
        PAYEE_UPPER_CREDIT_LIMIT_REACHED(MessagingKeys.Notifications.SMS_PAYMENT_ERROR_PAYEE_UPPER_CREDIT_LIMIT_REACHED);

        private MessageKey key;

        private PaymentError(MessageKey messageKey) {
            this.key = messageKey;
        }

        public MessageKey getMessageKey() {
            return this.key;
        }
    }
}

