/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.system.OutboundSmsConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.sms.SmsSender;
import org.cyclos.model.messaging.sms.OutboundSmsStatus;
import org.cyclos.model.system.configurations.SmsRequestType;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;

public class GatewaySmsSender
implements SmsSender {
    protected static final int TIMEOUT = 10000;
    private static final Logger LOG = LogManager.getLogger(GatewaySmsSender.class);
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    @Override
    public OutboundSmsStatus send(ConfigurationAccessor configurationAccessor, @Nullable MobilePhone mobilePhone, String string, String string2) {
        String string3;
        Map<String, String> map;
        OutboundSmsConfiguration outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration();
        string2 = this.preProcessMessage(configurationAccessor, string2);
        try {
            map = this.resolveVariables(configurationAccessor, mobilePhone, string, string2);
        }
        catch (Exception exception) {
            LOG.error("Error resolving variables for sending SMS to " + string, (Throwable)exception);
            return OutboundSmsStatus.INVALID;
        }
        String string4 = null;
        if (outboundSmsConfiguration.getRequestType() == SmsRequestType.POST) {
            try {
                string4 = this.resolvePostBody(configurationAccessor, mobilePhone, string, string2, map);
            }
            catch (Exception exception) {
                LOG.error("Error resolving the POST body for sending SMS to " + string, (Throwable)exception);
                return OutboundSmsStatus.INVALID;
            }
        }
        try {
            string3 = this.resolveGatewayUrl(configurationAccessor, mobilePhone, string, string2, map);
        }
        catch (Exception exception) {
            LOG.error("Error resolving the gareway URL for sending SMS to " + string, (Throwable)exception);
            return OutboundSmsStatus.INVALID;
        }
        HttpUriRequest httpUriRequest = this.buildRequest(configurationAccessor, string3, mobilePhone, string, string2);
        try {
            this.applyAuthentication(configurationAccessor, mobilePhone, string, string2, httpUriRequest);
        }
        catch (Exception exception) {
            LOG.error("Error applying the authentication on the request to " + string3 + " for sending SMS to " + string, (Throwable)exception);
            return OutboundSmsStatus.REJECTED;
        }
        Properties properties = PropertiesHelper.from((String)outboundSmsConfiguration.getHeaders());
        this.applyHeaders(configurationAccessor, mobilePhone, string, string2, httpUriRequest, properties);
        if (httpUriRequest instanceof HttpPost) {
            this.applyPostBody(configurationAccessor, mobilePhone, string, string2, (HttpPost)httpUriRequest, string4);
        }
        try {
            return this.doSend(configurationAccessor, mobilePhone, string, string2, httpUriRequest);
        }
        catch (ConnectException connectException) {
            LOG.error("Connection error sending the request to " + string3 + " for sending SMS to " + string, (Throwable)connectException);
            return OutboundSmsStatus.GATEWAY_UNREACHABLE;
        }
        catch (Exception exception) {
            LOG.error("Error sending the request to " + string3 + " for sending SMS to " + string, (Throwable)exception);
            return OutboundSmsStatus.UNKNOWN_ERROR;
        }
    }

    protected void applyAuthentication(ConfigurationAccessor configurationAccessor, @Nullable MobilePhone mobilePhone, String string, String string2, HttpUriRequest httpUriRequest) throws Exception {
        OutboundSmsConfiguration outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration();
        String string3 = outboundSmsConfiguration.getUsername();
        String string4 = outboundSmsConfiguration.getPassword();
        if (StringHelper.isNotBlank((Object)string3) && StringHelper.isNotBlank((Object)string4)) {
            BasicHttpContext basicHttpContext = new BasicHttpContext();
            httpUriRequest.addHeader(new BasicScheme().authenticate((Credentials)new UsernamePasswordCredentials(string3, string4), (HttpRequest)httpUriRequest, (HttpContext)basicHttpContext));
        }
    }

    protected void applyHeaders(ConfigurationAccessor configurationAccessor, MobilePhone mobilePhone, String string, String string2, HttpUriRequest httpUriRequest, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            httpUriRequest.setHeader(Objects.toString(entry.getKey(), ""), Objects.toString(entry.getValue(), ""));
        }
    }

    protected void applyPostBody(ConfigurationAccessor configurationAccessor, @Nullable MobilePhone mobilePhone, String string, String string2, HttpPost httpPost, String string3) {
        String string4 = configurationAccessor.getOutboundSmsConfiguration().getEncoding();
        httpPost.setEntity((HttpEntity)new StringEntity(string3, ContentType.create((String)"text/plain", (String)string4)));
    }

    protected HttpUriRequest buildRequest(ConfigurationAccessor configurationAccessor, String string, @Nullable MobilePhone mobilePhone, String string2, String string3) {
        OutboundSmsConfiguration outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration();
        Object object = outboundSmsConfiguration.getRequestType() == SmsRequestType.POST ? new HttpPost(string) : new HttpGet(string);
        return object;
    }

    /*
     * Exception decompiling
     */
    protected OutboundSmsStatus doSend(ConfigurationAccessor var1_1, @Nullable MobilePhone var2_2, String var3_3, String var4_4, HttpUriRequest var5_5) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String preProcessMessage(ConfigurationAccessor configurationAccessor, String string) {
        if (configurationAccessor.getOutboundSmsConfiguration().isAsciiOnly()) {
            String string2 = StringHelper.unaccent((String)string);
            return StringHelper.asciiOnly((String)string2);
        }
        return string;
    }

    protected String resolveGatewayUrl(ConfigurationAccessor configurationAccessor, @Nullable MobilePhone mobilePhone, String string, String string2, Map<String, String> map) throws Exception {
        OutboundSmsConfiguration outboundSmsConfiguration = configurationAccessor.getOutboundSmsConfiguration();
        Object object = outboundSmsConfiguration.getGatewayUrl();
        String string3 = StringUtils.substringAfter((String)object, (String)"?");
        if (StringUtils.isNotEmpty((CharSequence)string3)) {
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
            for (String string4 : StringUtils.split((String)string3, (String)"&")) {
                String[] stringArray = StringUtils.split((String)string4, (String)"=");
                String string5 = stringArray[0];
                String string6 = "";
                if (stringArray.length > 1) {
                    string6 = StringHelper.replaceVariables((String)stringArray[1], map);
                }
                arrayList.add(new BasicNameValuePair(string5, string6));
            }
            string3 = URLEncodedUtils.format(arrayList, (String)outboundSmsConfiguration.getEncoding());
            object = StringUtils.substringBefore((String)object, (String)"?") + "?" + string3;
        }
        return object;
    }

    protected String resolvePostBody(ConfigurationAccessor configurationAccessor, @Nullable MobilePhone mobilePhone, String string, String string2, Map<String, String> map) throws Exception {
        String string3 = configurationAccessor.getOutboundSmsConfiguration().getPostBody();
        return StringHelper.replaceVariables((String)string3, map);
    }

    protected OutboundSmsStatus resolveStatus(ConfigurationAccessor configurationAccessor, @Nullable MobilePhone mobilePhone, String string, HttpUriRequest httpUriRequest, int n, HttpEntity httpEntity) {
        HttpStatus httpStatus = HttpStatus.valueOf((int)n);
        if (httpStatus.is2xxSuccessful()) {
            return OutboundSmsStatus.SUCCESS;
        }
        if (httpStatus.is4xxClientError()) {
            return OutboundSmsStatus.REJECTED;
        }
        return OutboundSmsStatus.UNKNOWN_ERROR;
    }

    protected Map<String, String> resolveVariables(ConfigurationAccessor configurationAccessor, @Nullable MobilePhone mobilePhone, String string, String string2) throws Exception {
        PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(string, configurationAccessor);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("number", phoneNumberDescriptor == null ? string : phoneNumberDescriptor.toE164());
        linkedHashMap.put("country_code", phoneNumberDescriptor == null ? null : String.valueOf(phoneNumberDescriptor.getCountryCode()));
        linkedHashMap.put("national_number", phoneNumberDescriptor == null ? string : StringHelper.numbersOnly((String)phoneNumberDescriptor.toNationalFormat()));
        linkedHashMap.put("message", string2);
        return linkedHashMap;
    }
}

