/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.sms;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.system.AccountInformationSmsOperationConfiguration;
import org.cyclos.entities.system.SmsOperationConfiguration;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.utils.sms.BaseSmsOperation;
import org.cyclos.impl.utils.sms.InboundSmsData;
import org.cyclos.impl.utils.sms.SmsOperationException;
import org.cyclos.impl.utils.sms.SmsParameterProcessor;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.security.Security;
import org.cyclos.services.banking.AccountService;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Page;
import org.springframework.beans.factory.annotation.Autowired;

public class AccountInformationSmsOperation
extends BaseSmsOperation {
    private static final String DATE_TIME_PATTERN = "dd-MM HH:mm";
    private static final Logger LOG = LogManager.getLogger(AccountInformationSmsOperation.class);
    private final int TRANSACTIONS_PAGE_SIZE = 2;
    @Autowired
    private AccountServiceLocal accountServiceLocal;
    @Autowired
    @Security
    private AccountService accountService;

    @Override
    protected void checkParametersCount(SmsOperationConfiguration smsOperationConfiguration, List<String> list) throws SmsOperationException {
        AccountInformationSmsOperationConfiguration accountInformationSmsOperationConfiguration = (AccountInformationSmsOperationConfiguration)smsOperationConfiguration;
        boolean bl = accountInformationSmsOperationConfiguration.isUsePassword();
        int n = bl ? 1 : 0;
        int n2 = bl ? 2 : 1;
        int n3 = CollectionHelper.size(list);
        if (n3 < n || n3 > n2) {
            throw new SmsOperationException((Object)BaseSmsOperation.BaseError.INVALID_PARAMETERS_COUNT.getMessageKey(), new Object[]{n, n2});
        }
    }

    @Override
    protected void doExecute(SmsOperationConfiguration smsOperationConfiguration, MobilePhone mobilePhone, InboundSmsData inboundSmsData, SmsParameterProcessor smsParameterProcessor) throws SmsOperationException {
        LOG.debug(String.format("Executing SMS Account information operation (user: %1$s, sms: %2$s)", mobilePhone.getUser().getUsername(), inboundSmsData));
        AccountInformationSmsOperationConfiguration accountInformationSmsOperationConfiguration = (AccountInformationSmsOperationConfiguration)smsOperationConfiguration;
        try {
            BigDecimal bigDecimal;
            UserAccountType userAccountType = accountInformationSmsOperationConfiguration.getAccountType();
            Account account = this.accountServiceLocal.load((InternalAccountOwner)mobilePhone.getUser(), (AccountType)userAccountType);
            try {
                bigDecimal = this.accountServiceLocal.getAvailableBalance(account, null);
            }
            catch (IllegalActionException illegalActionException) {
                bigDecimal = null;
            }
            int n = !smsParameterProcessor.hasNext() ? 1 : smsParameterProcessor.nextInt((Object)MessagingKeys.Notifications.SMS_ACCOUNT_INFORMATION_PARAMETER_PAGE.key());
            Page<AccountHistoryEntryVO> page = this.searchAccountHistory(account, n - 1);
            CurrencyAmountDTO currencyAmountDTO = new CurrencyAmountDTO();
            currencyAmountDTO.setAmount(bigDecimal);
            currencyAmountDTO.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)account.getCurrency()));
            MessageKey messageKey = bigDecimal == null ? MessagingKeys.Notifications.SMS_ACCOUNT_INFORMATION_RESPONSE_NO_BALANCE : MessagingKeys.Notifications.SMS_ACCOUNT_INFORMATION_RESPONSE;
            this.sendResponse(mobilePhone, this.message(messageKey, this.createResponseParameters(currencyAmountDTO, page, n)));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            if (UserAccount.class.getSimpleName().equals(entityNotFoundException.getEntityType())) {
                throw new SmsOperationException((Throwable)entityNotFoundException, (Object)AccountInformationError.NOT_ACCESSIBLE_ACCOUNT.getMessageKey(), new Object[]{accountInformationSmsOperationConfiguration.getAccountType()});
            }
            throw entityNotFoundException;
        }
    }

    @Override
    protected List<String> getHelpComponents(SmsOperationConfiguration smsOperationConfiguration) {
        AccountInformationSmsOperationConfiguration accountInformationSmsOperationConfiguration = (AccountInformationSmsOperationConfiguration)smsOperationConfiguration;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (accountInformationSmsOperationConfiguration.isUsePassword()) {
            PasswordType passwordType = smsOperationConfiguration.getChannelConfiguration().getAccessPassword();
            arrayList.add(this.dataTranslationHandler.getName((NamedEntity)passwordType));
        }
        arrayList.add(this.message(MessagingKeys.Notifications.SMS_ACCOUNT_INFORMATION_PARAMETER_PAGE, new Object[0]));
        return arrayList;
    }

    private Object[] createResponseParameters(CurrencyAmountDTO currencyAmountDTO, Page<AccountHistoryEntryVO> page, int n) {
        Object[] objectArray = new Object[]{currencyAmountDTO, this.getTransactionsText(page, currencyAmountDTO.getCurrency(), n), (page.getCurrentPage() + 1) * 2 < page.getTotalCount() ? this.message(MessagingKeys.Notifications.SMS_ACCOUNT_INFORMATION_RESPONSE_NEXT, new Object[0]) : ""};
        return objectArray;
    }

    private String format(BigDecimal bigDecimal, int n) {
        return (BigDecimalHelper.isPositive((BigDecimal)bigDecimal) ? "+" : "") + this.getFormatter().format(bigDecimal, n);
    }

    private String format(DateTime dateTime) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_PATTERN);
        simpleDateFormat.setTimeZone(this.getSessionData().getConfiguration().getTimeZone());
        simpleDateFormat.setLenient(false);
        return simpleDateFormat.format(this.conversionHandler.toDate((IDate)dateTime));
    }

    private String getTransactionsText(Page<AccountHistoryEntryVO> page, CurrencyVO currencyVO, int n) {
        if (page.getPageItems().isEmpty()) {
            return this.message(MessagingKeys.Notifications.SMS_ACCOUNT_INFORMATION_RESPONSE_HISTORY_ENTRIES_WITHOUT, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 1;
        Iterator iterator = page.getPageItems().iterator();
        while (iterator.hasNext()) {
            AccountHistoryEntryVO accountHistoryEntryVO = (AccountHistoryEntryVO)iterator.next();
            Object[] objectArray = new Object[]{String.valueOf(n2++), this.format(accountHistoryEntryVO.getDate()), this.formatShort((AccountOwner)accountHistoryEntryVO.getRelatedAccount().getOwner()), this.format(accountHistoryEntryVO.getAmount(), currencyVO.getPrecision())};
            stringBuilder.append(this.message(MessagingKeys.Notifications.SMS_ACCOUNT_INFORMATION_RESPONSE_HISTORY_ENTRIES_TEMPLATE, objectArray));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(this.message(MessagingKeys.Notifications.SMS_ACCOUNT_INFORMATION_RESPONSE_HISTORY_ENTRIES_SEPARATOR, objectArray));
        }
        return this.message(MessagingKeys.Notifications.SMS_ACCOUNT_INFORMATION_RESPONSE_HISTORY_ENTRIES, stringBuilder.toString());
    }

    private Page<AccountHistoryEntryVO> searchAccountHistory(Account account, int n) {
        AccountHistoryQuery accountHistoryQuery = new AccountHistoryQuery();
        accountHistoryQuery.setAccount((AccountVO)this.conversionHandler.convert(AccountVO.class, (Object)account));
        accountHistoryQuery.setCurrentPage(Integer.valueOf(n));
        accountHistoryQuery.setPageSize(Integer.valueOf(2));
        return this.accountService.searchAccountHistory(accountHistoryQuery);
    }

    private static enum AccountInformationError implements HasMessageKey
    {
        NOT_ACCESSIBLE_ACCOUNT(MessagingKeys.Notifications.SMS_ACCOUNT_INFORMATION_ERROR_NOT_ACCESSIBLE_ACCOUNT);

        private MessageKey key;

        private AccountInformationError(MessageKey messageKey) {
            this.key = messageKey;
        }

        public MessageKey getMessageKey() {
            return this.key;
        }
    }
}

