/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.pdf;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.support.ICUBidiReorderer;
import com.openhtmltopdf.bidi.support.ICUBidiSplitter;
import com.openhtmltopdf.extend.FSStreamFactory;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import com.openhtmltopdf.util.XRLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javassist.util.proxy.Proxy;
import javax.annotation.PostConstruct;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.impl.utils.BarcodeHandler;
import org.cyclos.impl.utils.BarcodeResolution;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.pdf.PdfHandler;
import org.cyclos.impl.utils.pdf.PdfTemplate;
import org.cyclos.impl.utils.pdf.PdfTemplateEngine;
import org.cyclos.impl.utils.pdf.StreamFactory;
import org.cyclos.impl.utils.thymeleaf.ThymeleafContext;
import org.cyclos.model.ReportExecutionException;
import org.cyclos.model.RetryException;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.images.ImageSize;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.MessageKey;
import org.jsoup.Jsoup;
import org.jsoup.helper.W3CDom;
import org.jsoup.nodes.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.templatemode.TemplateMode;

@Component
public class PdfHandlerImpl
extends BaseGlobalHandlerImpl
implements PdfHandler {
    private static final int PERMITS = (int)Math.ceil((double)Runtime.getRuntime().maxMemory() / 1.073741824E9);
    private final Semaphore semaphore = new Semaphore(PERMITS);
    @Autowired
    @Lazy
    private ConfigurationImageServiceLocal configurationImageService;
    @Autowired
    @Lazy
    private BarcodeHandler barcodeHandler;
    @Autowired
    @Lazy
    private StoredFileHandler storedFileHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private PdfTemplateEngine pdfTemplateEngine;
    @Autowired
    private RichTextHandler richTextHandler;
    private List<StreamFactory> defaultStreamFactories;

    @PostConstruct
    public void initialize() {
        this.defaultStreamFactories = new ArrayList<StreamFactory>();
        this.defaultStreamFactories.add(new StreamFactory("classpath", this.getClass()::getResourceAsStream));
        this.defaultStreamFactories.add(new StreamFactory("image", string -> {
            long l = Long.parseLong(string);
            Image image = this.find(Image.class, l);
            return this.storedFileHandler.getContent((StoredFile)image);
        }));
        this.defaultStreamFactories.add(new StreamFactory("configimage", string -> {
            ConfigurationImageType configurationImageType = ConfigurationImageType.valueOf((String)string);
            return this.configurationImageService.readByConfigurationAndType(null, configurationImageType);
        }));
        this.defaultStreamFactories.add(new StreamFactory("qrcode", string -> this.barcodeHandler.qrcode(string, ImageSize.SMALL)));
        this.defaultStreamFactories.add(new StreamFactory("barcode", string -> this.barcodeHandler.barcode(string, BarcodeResolution.SMALL)));
        XRLog.setLoggingEnabled((boolean)false);
    }

    public PdfTemplate newTemplate(String string, String string2) {
        return new PdfTemplateImpl(string, string2);
    }

    private class PdfTemplateImpl
    implements PdfTemplate {
        private final ThymeleafContext context;
        private List<StreamFactory> factories = new ArrayList<StreamFactory>();
        private IdentityHashMap<Object, Proxy> resolved = new IdentityHashMap();
        private Language language;

        private PdfTemplateImpl(String string, String string2) {
            this.context = new ThymeleafContext();
            this.language = PdfHandlerImpl.this.getSessionData().getConfiguration().getLanguage();
            this.factories.addAll(PdfHandlerImpl.this.defaultStreamFactories);
            this.bindAll(PdfHandlerImpl.this.richTextHandler.getBasicThymeleafBinding());
            this.bind("contentPage", string);
            this.bind("customStyle", string2);
            this.bind("showHeader", true);
            this.bind("showFooter", true);
            this.landscape(false);
        }

        public PdfTemplate bind(String string, Object object) {
            this.context.setVariable(string, PdfHandlerImpl.this.dataTranslationProxy(object, this.language, this.resolved));
            return this;
        }

        public PdfTemplate bindAll(Map<String, Object> map) {
            this.context.setVariables(map);
            return this;
        }

        public PdfTemplate landscape(boolean bl) {
            return this.bind("landscape", bl);
        }

        public PdfTemplate noFooter() {
            return this.bind("showFooter", false);
        }

        public PdfTemplate noHeader() {
            return this.bind("showHeader", false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SerializableInputStream render() {
            try {
                FileOutputStream fileOutputStream;
                block19: {
                    PdfHandlerImpl.this.semaphore.acquire();
                    TemplateSpec templateSpec = new TemplateSpec("layout", TemplateMode.XML);
                    String string = PdfHandlerImpl.this.pdfTemplateEngine.process(templateSpec, this.context);
                    string = string.replaceAll(" color=\"([^\"]+)\"", " style=\"color:$1\"");
                    string = string.replace("<font ", "<span ");
                    string = string.replace("</font>", "</span>");
                    if (PdfHandlerImpl.this.cyclosProperties.isDevelopment()) {
                        PdfHandlerImpl.this.getLogger().debug("----- BEGIN PDF HTML -----\n{}\n-----  END PDF PRINT HTML  -----", (Object)string);
                    }
                    Document document = Jsoup.parse((String)string);
                    org.w3c.dom.Document document2 = new W3CDom().fromJsoup(document);
                    boolean bl = false;
                    File file = PdfHandlerImpl.this.cyclosProperties.newTempFile("cyclos-report-", ".pdf");
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        try {
                            PdfRendererBuilder pdfRendererBuilder = (PdfRendererBuilder)((PdfRendererBuilder)((PdfRendererBuilder)((PdfRendererBuilder)new PdfRendererBuilder().useUnicodeBidiReorderer((BidiReorderer)new ICUBidiReorderer())).useUnicodeBidiSplitter((BidiSplitterFactory)new ICUBidiSplitter.ICUBidiSplitterFactory())).useFastMode()).withW3cDocument(document2, "classpath:/");
                            ArrayList<StreamFactory> arrayList = new ArrayList<StreamFactory>();
                            arrayList.addAll(this.factories);
                            for (StreamFactory streamFactory : arrayList) {
                                pdfRendererBuilder.useProtocolsStreamImplementation((FSStreamFactory)streamFactory, new String[]{streamFactory.getProtocol()});
                            }
                            pdfRendererBuilder.toStream((OutputStream)fileOutputStream).run();
                        }
                        finally {
                            ((OutputStream)fileOutputStream).close();
                        }
                        bl = true;
                        fileOutputStream = new SerializableInputStream(file);
                        if (bl) break block19;
                        file.delete();
                    }
                    catch (Throwable throwable) {
                        try {
                            if (!bl) {
                                file.delete();
                            }
                            throw throwable;
                        }
                        catch (RetryException retryException) {
                            throw retryException;
                        }
                        catch (IOException iOException) {
                            throw new UncheckedIOException(iOException);
                        }
                        catch (Throwable throwable2) {
                            throw new ReportExecutionException(throwable2);
                        }
                    }
                }
                return fileOutputStream;
            }
            finally {
                PdfHandlerImpl.this.semaphore.release();
            }
        }

        public PdfTemplate streamFactory(StreamFactory streamFactory) {
            this.factories.add(streamFactory);
            return this;
        }

        public PdfTemplate title(MessageKey messageKey, Object ... objectArray) {
            return this.title(PdfHandlerImpl.this.translationHandler.message(messageKey, objectArray));
        }

        public PdfTemplate title(String string) {
            return this.bind("title", string);
        }
    }
}

