/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.notifications;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.ProcessableForProxying;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionAuthorization;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.messaging.AdminNotification;
import org.cyclos.entities.messaging.Alert;
import org.cyclos.entities.messaging.ErrorLog;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.messaging.Notification;
import org.cyclos.entities.messaging.QAdminNotification;
import org.cyclos.entities.messaging.QAdminNotificationSettings;
import org.cyclos.entities.messaging.QAdminNotificationTypeSettings;
import org.cyclos.entities.messaging.SystemAlert;
import org.cyclos.entities.messaging.UserAlert;
import org.cyclos.entities.messaging.UserNotification;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.MobilePhone;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.QAdminGroup;
import org.cyclos.entities.users.QAdminProductAuthorizationRole;
import org.cyclos.entities.users.QProductAdminVoucher;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserProductNotification;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.messaging.CustomNotificationSendingBackgroundTask;
import org.cyclos.impl.messaging.NotificationSendingBackgroundTask;
import org.cyclos.impl.messaging.NotificationServiceLocal;
import org.cyclos.impl.messaging.NotificationSettingsServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.appnotifications.AppNotificationHandler;
import org.cyclos.impl.utils.appnotifications.AppNotificationMessage;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.notifications.AccountNotificationsHandler;
import org.cyclos.impl.utils.notifications.AdminNotificationsHandler;
import org.cyclos.impl.utils.notifications.AdminsToNotifyCacheKey;
import org.cyclos.impl.utils.notifications.BrokeringNotificationsHandler;
import org.cyclos.impl.utils.notifications.CustomNotification;
import org.cyclos.impl.utils.notifications.CustomNotificationResult;
import org.cyclos.impl.utils.notifications.CustomNotificationSender;
import org.cyclos.impl.utils.notifications.EntityNotificationProcessingHandler;
import org.cyclos.impl.utils.notifications.FeedbackAndReferenceNotificationsHandler;
import org.cyclos.impl.utils.notifications.MailContent;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.notifications.MarketplaceBuyerNotificationsHandler;
import org.cyclos.impl.utils.notifications.MarketplaceSellerNotificationsHandler;
import org.cyclos.impl.utils.notifications.NotificationHandlerImplementor;
import org.cyclos.impl.utils.notifications.NotificationProcessingEntityType;
import org.cyclos.impl.utils.notifications.NotificationScriptResult;
import org.cyclos.impl.utils.notifications.NotificationURL;
import org.cyclos.impl.utils.notifications.NotificationsHandlerAccessorInvocationHandlerImpl;
import org.cyclos.impl.utils.notifications.PersonalNotificationsHandler;
import org.cyclos.impl.utils.notifications.UserNotificationMapping;
import org.cyclos.impl.utils.notifications.UserNotificationsHandlerAccessor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.model.IEntity;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.messaging.notifications.AccountNotificationCategory;
import org.cyclos.model.messaging.notifications.AccountNotificationType;
import org.cyclos.model.messaging.notifications.AdminNotificationType;
import org.cyclos.model.messaging.notifications.NewNotificationPushNotificationData;
import org.cyclos.model.messaging.notifications.NotificationVO;
import org.cyclos.model.messaging.notifications.OperatorNotificationPropagation;
import org.cyclos.model.messaging.notifications.UserNotificationType;
import org.cyclos.model.messaging.notificationsettings.NotificationTypeSettingsDTO;
import org.cyclos.model.messaging.sms.OutboundSmsStatus;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.PushNotificationEventType;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class NotificationHandlerImpl
extends BaseNetworkedHandlerImpl
implements NotificationHandlerImplementor {
    private static final Class<?>[] USER_INTERFACES = new Class[]{UserNotificationsHandlerAccessor.class, AccountNotificationsHandler.class, MarketplaceBuyerNotificationsHandler.class, MarketplaceSellerNotificationsHandler.class, BrokeringNotificationsHandler.class, FeedbackAndReferenceNotificationsHandler.class, PersonalNotificationsHandler.class};
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private NotificationSettingsServiceLocal settingsService;
    @Autowired
    private AdminNotificationsHandler adminNotificationsHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private NetworkPathRegistry networkPathRegistry;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private PushNotificationHandler pushNotificationHandler;
    @Autowired
    private NotificationServiceLocal notificationService;
    @Autowired
    private NotificationSettingsServiceLocal notificationSettingsService;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    private Map<UserNotificationType, Function<UserNotificationContext, CloseableIterator<BasicUser>>> customHandlers;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;
    @Autowired
    private CacheHandler cacheHandler;
    private Cache<AdminsToNotifyCacheKey, ArrayList<Long>> adminsCache;
    private Map<NotificationProcessingEntityType<?>, EntityNotificationProcessingHandler<?>> notificationProcessingHandlers;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AppNotificationHandler appNotificationHandler;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;

    public AdminNotificationsHandler admin() {
        return this.adminNotificationsHandler;
    }

    public CustomNotificationSender custom(BasicUser basicUser) {
        CustomNotification customNotification = new CustomNotification();
        customNotification.setUser(basicUser);
        return new CustomNotificationSenderImpl(customNotification);
    }

    public <E extends SimpleEntity> EntityNotificationProcessingHandler<E> getProcessingHandler(NotificationProcessingEntityType<E> notificationProcessingEntityType) {
        return this.notificationProcessingHandlers.get(notificationProcessingEntityType);
    }

    @PostConstruct
    public void initialize() {
        this.customHandlers = new HashMap<UserNotificationType, Function<UserNotificationContext, CloseableIterator<BasicUser>>>();
        Function<UserNotificationContext, CloseableIterator> function = userNotificationContext -> {
            BasePayment basePayment = (BasePayment)userNotificationContext.getEntity();
            PaymentTransferType paymentTransferType = (PaymentTransferType)basePayment.getType();
            TransactionAuthorization transactionAuthorization = (TransactionAuthorization)CollectionHelper.last((List)basePayment.getAuthorizations());
            CloseableIterator closeableIterator = this.operatorService.iteratePossibleAuthorizers((Operator)userNotificationContext.getDestination(), paymentTransferType);
            if (transactionAuthorization != null) {
                closeableIterator = CloseableIteratorHelper.filtered((CloseableIterator)closeableIterator, basicUser -> basicUser != null && !basicUser.equals((Object)transactionAuthorization.getBy()));
            }
            return closeableIterator;
        };
        Function<UserNotificationContext, CloseableIterator> function2 = userNotificationContext -> {
            BasePayment basePayment = (BasePayment)userNotificationContext.getEntity();
            TransactionAuthorization transactionAuthorization = (TransactionAuthorization)CollectionHelper.last((List)basePayment.getAuthorizations());
            CloseableIterator closeableIterator = CloseableIteratorHelper.empty();
            if (transactionAuthorization == null || !userNotificationContext.getDestination().equals((Object)transactionAuthorization.getBy())) {
                closeableIterator = CloseableIteratorHelper.singleton(userNotificationContext.getDestination());
            }
            return CloseableIteratorHelper.chained((CloseableIterator[])new CloseableIterator[]{closeableIterator, (CloseableIterator)function.apply((UserNotificationContext)userNotificationContext)});
        };
        this.customHandlers.put((UserNotificationType)AccountNotificationType.OPERATOR_PAYMENT_AWAITING_AUTHORIZATION, function);
        this.customHandlers.put((UserNotificationType)AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_SUCCEEDED, function2);
        this.customHandlers.put((UserNotificationType)AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_APPROVED_STILL_PENDING, function2);
        this.customHandlers.put((UserNotificationType)AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_CANCELED, function2);
        this.customHandlers.put((UserNotificationType)AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_DENIED, function2);
        this.customHandlers.put((UserNotificationType)AccountNotificationType.OPERATOR_AUTHORIZED_PAYMENT_EXPIRED, function2);
        List list = UserNotificationMapping.list().stream().filter(userNotificationType -> userNotificationType.getPropagation() == OperatorNotificationPropagation.CUSTOM).filter(userNotificationType -> !this.customHandlers.containsKey(userNotificationType)).collect(Collectors.toList());
        if (!list.isEmpty()) {
            throw new IllegalStateException("The following custom notification types have no mapping: " + String.valueOf(list));
        }
        this.adminsCache = this.cacheHandler.getCache(CacheType.ADMINS_TO_NOTIFY);
        this.notificationProcessingHandlers = this.applicationContext.getBeansOfType(EntityNotificationProcessingHandler.class).values().stream().collect(Collectors.toMap(EntityNotificationProcessingHandler::getType, entityNotificationProcessingHandler -> entityNotificationProcessingHandler));
        for (NotificationProcessingEntityType notificationProcessingEntityType : NotificationProcessingEntityType.values()) {
            if (this.notificationProcessingHandlers.containsKey(notificationProcessingEntityType)) continue;
            throw new IllegalStateException("Missing notification processing handler for type: " + String.valueOf(notificationProcessingEntityType));
        }
    }

    @Override
    public void notify(BasicUser basicUser, UserNotificationType userNotificationType, NotificationURL notificationURL, SimpleEntity simpleEntity, User user, Object ... objectArray) {
        UserNotification userNotification = new UserNotification();
        userNotification.setType(userNotificationType);
        this.notify(basicUser, (Notification)userNotification, notificationURL, simpleEntity, user, objectArray);
    }

    @Override
    public CustomNotificationResult notifyCustom(CustomNotification customNotification, boolean bl) {
        if (customNotification == null || !customNotification.isValid()) {
            throw new ValidationException("Invalid notification parameters");
        }
        if (bl) {
            BasicUser basicUser = customNotification.getUser();
            return (CustomNotificationResult)this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)basicUser), () -> this.doNotifyCustom(customNotification));
        }
        this.backgroundTaskHandler.schedule(CustomNotificationSendingBackgroundTask.scheduling(customNotification));
        return null;
    }

    public UserNotificationsHandlerAccessor user(BasicUser basicUser) {
        return (UserNotificationsHandlerAccessor)this.createProxy(USER_INTERFACES, new NotificationsHandlerAccessorInvocationHandlerImpl(basicUser, this, this.translationHandler, this.invokerHandler));
    }

    protected boolean networkCheck(User user, NetworkedEntity networkedEntity) {
        Network network = user.getNetwork();
        Network network2 = networkedEntity.getNetwork();
        Class<?> clazz = networkedEntity.getClass();
        if (network != null && !network.isEnabled()) {
            return false;
        }
        return !(this.networkPathRegistry.showGlobals(clazz) ? network2 != null && !network2.equals((Object)network) : (!user.isGlobal() || !(networkedEntity instanceof ErrorLog) && !(networkedEntity instanceof SystemAlert)) && !Objects.equals(network, network2));
    }

    private List<Long> adminsToNotify(NetworkedEntity networkedEntity, AdminNotificationType adminNotificationType) {
        Network network = networkedEntity.getNetwork();
        Object object = this.resolveAdminFilter(networkedEntity);
        AdminsToNotifyCacheKey adminsToNotifyCacheKey = new AdminsToNotifyCacheKey(adminNotificationType, SimpleEntity.id((SimpleEntity)network), object);
        return (List)this.adminsCache.get((Serializable)adminsToNotifyCacheKey, () -> {
            QAdminNotificationTypeSettings qAdminNotificationTypeSettings = QAdminNotificationTypeSettings.adminNotificationTypeSettings;
            return this.getQueryFor(adminNotificationType, object).stream((Expression)qAdminNotificationTypeSettings.notificationSettings().user().id).collect(Collectors.toCollection(ArrayList::new));
        });
    }

    private Object createProxy(Class<?>[] classArray, InvocationHandler invocationHandler) {
        Object object = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), classArray, invocationHandler);
        return object;
    }

    private CustomNotificationResult doNotifyCustom(CustomNotification customNotification) {
        CustomNotificationResult customNotificationResult = new CustomNotificationResult();
        customNotificationResult.setEmail(this.notifyCustomByEmail(customNotification));
        customNotificationResult.setSms(this.notifyCustomBySms(customNotification));
        customNotificationResult.setApp(this.notifyCustomByApp(customNotification));
        return customNotificationResult;
    }

    private DBQuery<?> getQueryFor(AdminNotificationType adminNotificationType, Object object) {
        QAdminNotificationSettings qAdminNotificationSettings = QAdminNotificationSettings.adminNotificationSettings;
        QAdminNotificationTypeSettings qAdminNotificationTypeSettings = QAdminNotificationTypeSettings.adminNotificationTypeSettings;
        adminNotificationType = this.settingsService.getTypeBasedOnSetting(adminNotificationType);
        QUser qUser = QUser.user;
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qAdminNotificationSettings}).innerJoin((EntityPath)qAdminNotificationSettings.user(), (Path)qUser._super)).innerJoin((EntityPath)qAdminNotificationTypeSettings)).on((Predicate)qAdminNotificationSettings.eq((Expression)qAdminNotificationTypeSettings.notificationSettings()))).where(new Predicate[]{qAdminNotificationTypeSettings.type.eq((Object)adminNotificationType), qAdminNotificationTypeSettings.notifyByInternal.isTrue()});
        switch (adminNotificationType) {
            case APPLICATION_ERROR: {
                Network network = (Network)object;
                QAdminGroup qAdminGroup = QAdminGroup.adminGroup;
                BooleanExpression booleanExpression = qAdminGroup.adminType.eq((Object)AdminGroupType.GLOBAL);
                if (network != null) {
                    DBQuery dBQuery2 = (DBQuery)this.rawEntityManagerHandler.subQuery(new EntityPath[]{qAdminGroup}).where(new Predicate[]{qAdminGroup.eq((Expression)qUser.group()), qAdminGroup.managedNetworks.contains((Object)network)});
                    booleanExpression = booleanExpression.or((Predicate)qAdminGroup.network().eq((Object)network)).or((Predicate)dBQuery2.exists());
                }
                ((DBQuery)dBQuery.innerJoin((EntityPath)qUser.group(), (Path)qAdminGroup._super)).where((Predicate)booleanExpression);
                break;
            }
            case AD_PENDING_AUTHORIZATION: {
                break;
            }
            case NETWORK_CREATED: {
                Network network = (Network)object;
                QAdminGroup qAdminGroup = QAdminGroup.adminGroup;
                BooleanExpression booleanExpression = qAdminGroup.adminType.eq((Object)AdminGroupType.GLOBAL);
                DBQuery dBQuery3 = (DBQuery)this.subQuery(new EntityPath[]{qAdminGroup}).where(new Predicate[]{qAdminGroup.eq((Expression)qUser.group()), network.getRegisteredByGroup() == null ? booleanExpression : booleanExpression.or((Predicate)qUser.group().eq((Object)network.getRegisteredByGroup()))});
                dBQuery.where((Predicate)dBQuery3.exists());
                break;
            }
            case EXTERNAL_PAYMENT_EXPIRED: {
                dBQuery.where((Predicate)qAdminNotificationSettings.externalPaymentsExpired.contains((Object)((TransferType)object)));
                break;
            }
            case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                dBQuery.where((Predicate)qAdminNotificationSettings.externalPaymentsFailed.contains((Object)((TransferType)object)));
                break;
            }
            case PAYMENT_AWAITING_AUTHORIZATION: {
                dBQuery.where((Predicate)qAdminNotificationSettings.authorizablePayments.contains((Object)((TransferType)object)));
                break;
            }
            case PAYMENT_PERFORMED: {
                dBQuery.where((Predicate)qAdminNotificationSettings.payments.contains((Object)((TransferType)object)));
                break;
            }
            case SYSTEM_ALERT: {
                dBQuery.where((Predicate)qAdminNotificationSettings.systemAlerts.contains((Object)((SystemAlertType)object)));
                break;
            }
            case USER_ALERT: {
                dBQuery.where((Predicate)qAdminNotificationSettings.userAlerts.contains((Object)((UserAlertType)object)));
                break;
            }
            case USER_REGISTRATION: {
                dBQuery.where((Predicate)qAdminNotificationSettings.userGroups.contains((Object)((Group)object)));
                break;
            }
            case GENERATED_VOUCHERS_EXPIRED: {
                dBQuery.where((Predicate)qAdminNotificationSettings.voucherConfigurations.contains((Object)((VoucherConfiguration)object)));
                break;
            }
            case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                dBQuery.where((Predicate)qAdminNotificationSettings.voucherConfigurationsBuying.contains((Object)((VoucherConfiguration)object)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown admin notification type: " + String.valueOf(adminNotificationType));
            }
        }
        return dBQuery;
    }

    private String htmlText(MessageKey messageKey, Language language, Object[] objectArray, Function<String, String> function) {
        String string = this.message(MessageFormat.HTML, language, messageKey, objectArray);
        string = StringHelper.replaceVariables((String)string, function);
        return string;
    }

    private String mailSubject(MessageKey messageKey, Language language, Object[] objectArray, Function<String, String> function) {
        String string = this.message(language, messageKey, objectArray);
        string = StringHelper.replaceVariables((String)string, function);
        return this.message(language, ContentManagementKeys.Emails.NOTIFICATION_SUBJECT, string);
    }

    private NewNotificationPushNotificationData newNotificationData(Notification notification) {
        return (NewNotificationPushNotificationData)this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)notification.getUser()), () -> {
            NewNotificationPushNotificationData newNotificationPushNotificationData = new NewNotificationPushNotificationData();
            newNotificationPushNotificationData.setNotification((NotificationVO)this.conversionHandler.convert(NotificationVO.class, (Object)notification));
            newNotificationPushNotificationData.setNotificationsStatus(this.notificationService.getNotificationsStatus());
            return newNotificationPushNotificationData;
        });
    }

    private void notify(BasicUser basicUser, Notification notification, NotificationURL notificationURL, SimpleEntity simpleEntity, User user, Object ... objectArray) {
        notification.setDate(DateHelper.now());
        notification.setUser(basicUser);
        notification.setRelatedUser((BasicUser)user);
        NotificationScriptResult notificationScriptResult = this.setNotificationData(notification, simpleEntity, objectArray);
        if (!notificationScriptResult.isSkip()) {
            NotificationURL notificationURL2 = notificationURL = notificationScriptResult.isPreventNavigation() ? null : notificationURL;
            if (notificationURL != null) {
                notification.setLocation(notificationURL.getLocation());
                notification.setEntityId(notificationURL.getIdToFindEntity());
            }
            if (notification instanceof UserNotification) {
                this.persistAndPropagate(new UserNotificationContext(basicUser, (UserNotification)notification, notificationURL));
            } else {
                this.persistAndSendPush(basicUser, notification, notificationURL);
            }
        }
    }

    private CustomNotificationResult.SendStatus notifyCustomByApp(CustomNotification customNotification) {
        if (!customNotification.isApp()) {
            return CustomNotificationResult.SendStatus.SKIPPED;
        }
        BasicUser basicUser = customNotification.getUser();
        if (!this.appNotificationHandler.canReceiveNotifications(basicUser)) {
            return CustomNotificationResult.SendStatus.UNAVAILABLE;
        }
        try {
            AppNotificationMessage appNotificationMessage = AppNotificationMessage.builder().setUser(basicUser).setTitle(customNotification.getAppTitle()).setBody(customNotification.getAppBody()).setCustomUrl(customNotification.getAppCustomUrl()).setImageUrl(customNotification.getAppImageUrl()).setAndroidIconColor(customNotification.getAppAndroidIconColor()).setIosUseBadge(customNotification.isAppIosUseBadge()).setVariables(customNotification.getAppVariables()).build();
            boolean bl = this.appNotificationHandler.notify(appNotificationMessage);
            return bl ? CustomNotificationResult.SendStatus.SUCCESS : CustomNotificationResult.SendStatus.ERROR;
        }
        catch (Exception exception) {
            return CustomNotificationResult.SendStatus.ERROR;
        }
    }

    private CustomNotificationResult.SendStatus notifyCustomByEmail(CustomNotification customNotification) {
        if (!customNotification.isEmail()) {
            return CustomNotificationResult.SendStatus.SKIPPED;
        }
        BasicUser basicUser = customNotification.getUser();
        if (StringHelper.isBlank((Object)basicUser.getEmail())) {
            return CustomNotificationResult.SendStatus.UNAVAILABLE;
        }
        try {
            FileInfo[] fileInfoArray = (FileInfo[])CollectionHelper.orEmpty((List)customNotification.getEmailAttachments()).stream().toArray(FileInfo[]::new);
            this.mailHandler.send(null, basicUser, MailContext.CUSTOM_NOTIFICATION, () -> new MailContent(customNotification.getEmailSubject(), customNotification.getEmailBody()), fileInfoArray);
            return CustomNotificationResult.SendStatus.SUCCESS;
        }
        catch (Exception exception) {
            return CustomNotificationResult.SendStatus.ERROR;
        }
    }

    private CustomNotificationResult.SendStatus notifyCustomBySms(CustomNotification customNotification) {
        if (!customNotification.isSms()) {
            return CustomNotificationResult.SendStatus.SKIPPED;
        }
        BasicUser basicUser = customNotification.getUser();
        List list = basicUser.getMobilePhones().stream().filter(mobilePhone -> customNotification.isSmsEvenIfDisabled() ? true : mobilePhone.isEnabledForSms()).collect(Collectors.toList());
        if (list.isEmpty()) {
            return CustomNotificationResult.SendStatus.UNAVAILABLE;
        }
        try {
            List list2 = customNotification.isSmsEvenIfDisabled() ? this.outboundSmsHandler.sendEvenIfDisabled(list, customNotification.getSmsMessage(), OutboundSmsType.CUSTOM_NOTIFICATION) : this.outboundSmsHandler.send(list, customNotification.getSmsMessage(), OutboundSmsType.CUSTOM_NOTIFICATION);
            boolean bl = list2.stream().anyMatch(outboundSms -> outboundSms.getStatus() == OutboundSmsStatus.SUCCESS);
            return bl ? CustomNotificationResult.SendStatus.SUCCESS : CustomNotificationResult.SendStatus.ERROR;
        }
        catch (Exception exception) {
            return CustomNotificationResult.SendStatus.ERROR;
        }
    }

    private boolean paymentAwaitingAuthorizatonNotificationExists(User user, Transaction transaction) {
        if (!user.isAdmin()) {
            return false;
        }
        QAdminNotification qAdminNotification = QAdminNotification.adminNotification;
        return ((DBQuery)this.from(new EntityPath[]{qAdminNotification}).where(new Predicate[]{qAdminNotification.user().eq((Object)user), qAdminNotification.entityId.eq((Object)transaction.getId()), qAdminNotification.type.eq((Object)AdminNotificationType.PAYMENT_AWAITING_AUTHORIZATION)})).hasResults();
    }

    private void persistAndPropagate(UserNotificationContext userNotificationContext) {
        UserNotificationType userNotificationType = userNotificationContext.getType();
        SimpleEntity simpleEntity = userNotificationContext.getEntity();
        NotificationURL notificationURL = userNotificationContext.getUrl();
        UserNotification userNotification = userNotificationContext.getNotification();
        this.processBatch(this.resolveUsersToNotify(userNotificationContext), (T basicUser) -> {
            if (this.notificationSettingsService.isEnabled(userNotificationType, basicUser, simpleEntity)) {
                UserNotification userNotification2 = new UserNotification();
                userNotification2.setDate(userNotification.getDate());
                userNotification2.setUser(basicUser);
                userNotification2.setRelatedUser(userNotification.getRelatedUser());
                userNotification2.setType(userNotificationType);
                userNotification2.setLocation(userNotification.getLocation());
                userNotification2.setEntityId(userNotification.getEntityId());
                userNotification2.setHtmlText(userNotification.getHtmlText());
                userNotification2.setSms(userNotification.getSms());
                userNotification2.setMailSubject(userNotification.getMailSubject());
                userNotification2.setFcmConfiguration(userNotification.getFcmConfiguration());
                this.persistAndSendPush((BasicUser)basicUser, (Notification)userNotification2, notificationURL);
            }
        });
    }

    private void persistAndSendPush(BasicUser basicUser, Notification notification, NotificationURL notificationURL) {
        UserNotificationType userNotificationType = (UserNotificationType)ObjectHelper.ifType((Object)notification.getType(), UserNotificationType.class);
        if (userNotificationType != null && this.shouldSkipUser(userNotificationType, basicUser, notificationURL)) {
            return;
        }
        this.persist((IEntity)notification);
        PushNotificationEventContext pushNotificationEventContext = PushNotificationEventContext.user((PushNotificationEventType)PushNotificationEventType.NEW_NOTIFICATION, (Long)basicUser.getId());
        this.pushNotificationHandler.publish(pushNotificationEventContext, SimpleEntity.id((SimpleEntity)basicUser.getNetwork()), () -> {
            Notification notification2 = this.find(Notification.class, notification.getId());
            return this.newNotificationData(notification2);
        });
        NotificationTypeSettingsDTO notificationTypeSettingsDTO = this.notificationSettingsService.getNotificationTypeSettings(notification);
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if (this.shouldNotifyByEmail(notification, notificationTypeSettingsDTO)) {
            arrayList.add("email");
        }
        if (this.shouldNotifyBySms(notification, notificationTypeSettingsDTO)) {
            arrayList.add("sms");
        }
        if (this.shouldNotifyByApp(notification, notificationTypeSettingsDTO)) {
            arrayList.add("app");
        }
        if (!arrayList.isEmpty()) {
            this.backgroundTaskHandler.schedule(NotificationSendingBackgroundTask.scheduling(basicUser, notification, arrayList));
        }
    }

    private Pair<Object, Object> processArgument(Object object, int n, Notification notification, FormatterImpl formatterImpl) {
        if (object instanceof ProcessableForProxying) {
            object = this.dataTranslationProxy(object);
        }
        if (object instanceof BasicUser) {
            return Pair.create((Object)StringUtils.left((String)formatterImpl.format((BasicUser)object), (int)25), (Object)object);
        }
        if (notification.getType().equals((Object)AccountNotificationType.LIMIT_CHANGE) && n == 1 && (object == null || object instanceof CurrencyAmount && ((CurrencyAmount)object).getAmount() == null)) {
            String string = this.message(BankingKeys.Accounts.LIMIT_MODE_UNLIMITED, new Object[0]);
            return Pair.create((Object)string, (Object)string);
        }
        return Pair.create((Object)object, (Object)object);
    }

    private Object resolveAdminFilter(NetworkedEntity networkedEntity) {
        if (networkedEntity instanceof ErrorLog) {
            return networkedEntity.getNetwork();
        }
        if (networkedEntity instanceof Trans) {
            return ((Trans)networkedEntity).getType();
        }
        if (networkedEntity instanceof Alert) {
            return ((Alert)networkedEntity).getType();
        }
        if (networkedEntity instanceof Voucher) {
            return ((Voucher)networkedEntity).getConfiguration();
        }
        if (networkedEntity instanceof VoucherType) {
            return ((VoucherType)networkedEntity).getConfiguration();
        }
        return networkedEntity;
    }

    private CloseableIterator<BasicUser> resolveUsersToNotify(UserNotificationContext userNotificationContext) {
        ProductsAccessor productsAccessor;
        boolean bl;
        UserNotificationType userNotificationType = userNotificationContext.getType();
        OperatorNotificationPropagation operatorNotificationPropagation = userNotificationContext.getPropagation();
        if (operatorNotificationPropagation == OperatorNotificationPropagation.CUSTOM) {
            return this.customHandlers.get(userNotificationType).apply(userNotificationContext);
        }
        Object u = userNotificationContext.getDestination();
        CloseableIterator closeableIterator = CloseableIteratorHelper.singleton(u);
        CloseableIterator closeableIterator2 = CloseableIteratorHelper.empty();
        CloseableIterator closeableIterator3 = CloseableIteratorHelper.empty();
        if (operatorNotificationPropagation != OperatorNotificationPropagation.DESTINATION_ONLY && (bl = (productsAccessor = this.productsHandler.getAccessor((BasicUser)u.getUser())).product().hasPermission(Permission.MY_OPERATORS_ENABLE))) {
            if (u.isOperator()) {
                closeableIterator2 = CloseableIteratorHelper.singleton((Object)u.getUser());
            }
            boolean bl2 = operatorNotificationPropagation != OperatorNotificationPropagation.ALL_OPERATORS;
            QUserProductNotification qUserProductNotification = QUserProductNotification.userProductNotification;
            boolean bl3 = productsAccessor.memberOrBroker().getNotifications().get((Object)userNotificationType).isSet((Path)qUserProductNotification.enabled);
            closeableIterator3 = this.operatorService.iterateOperatorsToNotify(u, userNotificationType, bl2, bl3);
        }
        return CloseableIteratorHelper.chained((CloseableIterator[])new CloseableIterator[]{closeableIterator, closeableIterator2, closeableIterator3});
    }

    private NotificationScriptResult setNotificationData(Notification notification, SimpleEntity simpleEntity, Object ... objectArray) {
        BasicUser basicUser = notification.getUser();
        return (NotificationScriptResult)this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)basicUser), () -> {
            Pair<Object, Object> pair;
            Object[] objectArray2;
            SessionData sessionData = this.getSessionData();
            ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
            FormatterImpl formatterImpl = this.getFormatter(configurationAccessor);
            Language language = configurationAccessor.getLanguage();
            boolean bl = CollectionHelper.isNotEmpty((Object[])objectArray);
            Object[] objectArray3 = bl ? new Object[objectArray.length] : ArrayUtils.EMPTY_OBJECT_ARRAY;
            Object[] objectArray4 = objectArray2 = bl ? new Object[objectArray.length] : ArrayUtils.EMPTY_OBJECT_ARRAY;
            if (bl) {
                for (int i = 0; i < objectArray.length; ++i) {
                    pair = this.processArgument(objectArray[i], i, notification, formatterImpl);
                    objectArray3[i] = pair.getFirst();
                    objectArray2[i] = pair.getSecond();
                }
            }
            Function function = this.profileFieldHandler.getUserVariablesFunction(basicUser);
            pair = configurationAccessor.getNotificationConfiguration();
            NotificationScriptResult notificationScriptResult = null;
            if (pair != null && pair.getScript() != null) {
                notificationScriptResult = (NotificationScriptResult)this.customScriptService.newAccessor(pair.getScript(), pair.getScriptParameters()).bind("user", (Object)basicUser).bind("type", (Object)notification.getType()).bind("entity", (Object)simpleEntity).run(NotificationScriptResult.class);
            }
            if ((notificationScriptResult = (NotificationScriptResult)ObjectHelper.defaultValue(notificationScriptResult, NotificationScriptResult::empty)).isSkip()) {
                return notificationScriptResult;
            }
            String string = notificationScriptResult.getSms(() -> this.smsText(notification.getType().getKeyForSms(), language, objectArray3, function));
            String string2 = notificationScriptResult.getTitle(() -> this.mailSubject(notification.getType().getMessageKey(), language, objectArray2, function));
            String string3 = notificationScriptResult.getBody(() -> this.htmlText(notification.getType().getKeyForText(), language, objectArray2, function));
            notification.setSms(string);
            notification.setMailSubject(string2);
            notification.setHtmlText(string3);
            if (notificationScriptResult.getFcm() != null) {
                try {
                    notification.setFcmConfiguration(this.jacksonConfiguration.getObjectMapper().writeValueAsString((Object)notificationScriptResult.getFcm()));
                }
                catch (JsonProcessingException jsonProcessingException) {
                    throw new IllegalStateException(jsonProcessingException);
                }
            }
            return notificationScriptResult;
        });
    }

    private boolean shouldNotifyByApp(Notification notification, NotificationTypeSettingsDTO notificationTypeSettingsDTO) {
        return this.appNotificationHandler.canReceiveNotifications(notification.getUser()) && Boolean.TRUE.equals(notificationTypeSettingsDTO.getNotifyByApp());
    }

    private boolean shouldNotifyByEmail(Notification notification, NotificationTypeSettingsDTO notificationTypeSettingsDTO) {
        return !notification.isSkipEmail() && Boolean.TRUE.equals(notificationTypeSettingsDTO.getNotifyByEmail()) && StringHelper.isNotBlank((Object)notification.getUser().getEmail());
    }

    private boolean shouldNotifyBySms(Notification notification, NotificationTypeSettingsDTO notificationTypeSettingsDTO) {
        return !notification.isSkipSms() && Boolean.TRUE.equals(notificationTypeSettingsDTO.getNotifyBySms()) && notification.getUser().getMobilePhones().stream().anyMatch(MobilePhone::isEnabledForSms);
    }

    private boolean shouldSkipAdmin(AdminNotificationType adminNotificationType, User user, NetworkedEntity networkedEntity) {
        if (!this.networkCheck(user, networkedEntity) || !this.settingsService.isAllowedNotificationType(adminNotificationType, user)) {
            return true;
        }
        AdminProductAccessor adminProductAccessor = this.productsHandler.getAccessor((BasicUser)user).admin();
        boolean bl = false;
        switch (adminNotificationType) {
            case PAYMENT_AWAITING_AUTHORIZATION: {
                Object object;
                Transaction transaction = (Transaction)networkedEntity;
                if (this.paymentAwaitingAuthorizatonNotificationExists(user, transaction)) {
                    return true;
                }
                List list = this.settingsService.getAvailableOptionsFor(user, adminNotificationType);
                boolean bl2 = bl = !list.contains(this.conversionHandler.convert(TransferTypeVO.class, (Object)transaction.getType()));
                if (!bl && transaction instanceof BasePayment) {
                    object = (BasePayment)transaction;
                    Set set = adminProductAccessor.getAuthorizationRoles().keysSet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.view);
                    boolean bl3 = bl = !CollectionHelper.containsAny((Collection)set, (Collection)object.getNextAuthorizationLevel().getRoles());
                }
                if (bl) {
                    return true;
                }
                object = (permission, permission2) -> {
                    Transaction transaction = (Transaction)networkedEntity;
                    boolean bl = adminProductAccessor.hasPermission(permission);
                    boolean bl2 = adminProductAccessor.hasPermission(permission2);
                    if (transaction.isFromSystem() && transaction.isToSystem()) {
                        return !bl;
                    }
                    if (transaction.isFromSystem() || transaction.isToSystem()) {
                        return !bl && !bl2;
                    }
                    return !bl2;
                };
                switch (transaction.getNature()) {
                    case EXTERNAL_PAYMENT: {
                        if (!((Boolean)object.apply(Permission.SYSTEM_EXTERNAL_PAYMENTS_VIEW, Permission.USER_EXTERNAL_PAYMENTS_VIEW)).booleanValue()) break;
                        return true;
                    }
                    case PAYMENT_REQUEST: {
                        if (!((Boolean)object.apply(Permission.SYSTEM_PAYMENT_REQUESTS_VIEW, Permission.USER_PAYMENT_REQUESTS_VIEW)).booleanValue()) break;
                        return true;
                    }
                    case SCHEDULED_PAYMENT: 
                    case RECURRING_PAYMENT: {
                        if (!((Boolean)object.apply(Permission.SYSTEM_SCHEDULED_PAYMENTS_VIEW, Permission.USER_SCHEDULED_PAYMENTS_VIEW)).booleanValue()) break;
                        return true;
                    }
                    case TICKET: {
                        if (adminProductAccessor.hasPermission(Permission.USER_PAYMENT_TICKETS_VIEW)) break;
                        return true;
                    }
                }
                if (!transaction.isFromUser() || this.groupsHandler.getAccessibleUserGroups(user).contains(transaction.getFromUser().getGroup())) break;
                return true;
            }
            case PAYMENT_PERFORMED: {
                Transaction transaction = (Transaction)networkedEntity;
                List list = this.settingsService.getAvailableOptionsFor(user, adminNotificationType);
                if (!list.contains(this.conversionHandler.convert(TransferTypeVO.class, (Object)transaction.getType()))) {
                    return true;
                }
                if (transaction.isFromUser()) {
                    boolean bl4 = bl = !this.groupsHandler.getAccessibleUserGroups(user).contains(transaction.getFromUser().getGroup());
                }
                bl = transaction.isToUser() ? (bl &= !this.groupsHandler.getAccessibleUserGroups(user).contains(transaction.getToUser().getGroup())) : false;
                return bl;
            }
            case USER_ALERT: {
                return !this.groupsHandler.getAccessibleUserGroups(user).contains(((UserAlert)networkedEntity).getUser().getGroup());
            }
            case AD_PENDING_AUTHORIZATION: {
                return !this.groupsHandler.getAccessibleUserGroups(user).contains(((BasicAd)networkedEntity).getOwner().getGroup());
            }
            case EXTERNAL_PAYMENT_EXPIRED: 
            case EXTERNAL_PAYMENT_PERFORMED_FAILED: {
                return !adminProductAccessor.getSystemAccounts().contains(((ExternalPayment)networkedEntity).getFromType());
            }
            case VOUCHER_BUYING_ABOUT_TO_EXPIRE: {
                return !adminProductAccessor.getVouchers().isSet((Object)((VoucherType)networkedEntity).getConfiguration(), (Path)QProductAdminVoucher.productAdminVoucher.view);
            }
            case GENERATED_VOUCHERS_EXPIRED: 
            case GENERATED_VOUCHERS_ABOUT_TO_EXPIRE: {
                return !adminProductAccessor.getVouchers().isSet((Object)((Voucher)networkedEntity).getConfiguration(), (Path)QProductAdminVoucher.productAdminVoucher.view);
            }
            case USER_REGISTRATION: 
            case USER_IMPORT_REGISTRATION: {
                return !this.settingsService.getAvailableOptionsFor(user, adminNotificationType).contains(networkedEntity);
            }
        }
        return false;
    }

    private boolean shouldSkipUser(UserNotificationType userNotificationType, BasicUser basicUser, NotificationURL notificationURL) {
        SimpleEntity simpleEntity;
        if (basicUser.isRestrictedOperator() && userNotificationType.getPropagation() == OperatorNotificationPropagation.OWNER_ONLY) {
            return true;
        }
        SimpleEntity simpleEntity2 = simpleEntity = notificationURL == null ? null : notificationURL.getEntity();
        if (simpleEntity instanceof Trans && userNotificationType instanceof AccountNotificationType) {
            UserAccountType userAccountType;
            Account account;
            AccountNotificationType accountNotificationType = (AccountNotificationType)userNotificationType;
            boolean bl = accountNotificationType.getCategory() == AccountNotificationCategory.PERFORMED_TRANSACTION;
            boolean bl2 = accountNotificationType.getCategory() == AccountNotificationCategory.RECEIVED_TRANSACTION;
            Trans trans = (Trans)simpleEntity;
            Object object = bl ? trans.getFrom() : (account = bl2 ? trans.getTo() : null);
            if (account instanceof UserAccount && !this.notificationSettingsService.isPaymentAmountInRange(basicUser, userAccountType = (UserAccountType)account.getType(), trans.getAmount())) {
                return true;
            }
        }
        return false;
    }

    private String smsText(MessageKey messageKey, Language language, Object[] objectArray, Function<String, String> function) {
        String string = this.message(MessageFormat.PLAIN, language, messageKey, objectArray);
        string = StringHelper.replaceVariables((String)string, function);
        string = StringHelper.replace((String)string, (String)"<br>", (String)"\n");
        string = StringHelper.trim((Object)string);
        return string;
    }

    void notify(AdminNotificationType adminNotificationType, NetworkedEntity networkedEntity, NotificationURL notificationURL, User user, Object ... objectArray) {
        this.notifyWithSkip(adminNotificationType, networkedEntity, notificationURL, user, false, false, objectArray);
    }

    void notifyWithSkip(AdminNotificationType adminNotificationType, NetworkedEntity networkedEntity, NotificationURL notificationURL, User user, boolean bl, boolean bl2, Object ... objectArray) {
        this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
            this.adminsToNotify(networkedEntity, adminNotificationType).stream().map(l -> (User)this.rawEntityManagerHandler.find(User.class, l)).filter(user -> !this.shouldSkipAdmin(adminNotificationType, (User)user, networkedEntity)).forEach(user2 -> {
                AdminNotification adminNotification = new AdminNotification();
                adminNotification.setSkipEmail(bl);
                adminNotification.setSkipSms(bl2);
                adminNotification.setType(adminNotificationType);
                this.notify((BasicUser)user2, (Notification)adminNotification, notificationURL, notificationURL.getEntity(), user, objectArray);
            });
            return null;
        });
    }

    private class CustomNotificationSenderImpl
    implements CustomNotificationSender {
        private CustomNotification notification;

        public CustomNotificationSenderImpl(CustomNotification customNotification) {
            this.notification = customNotification;
        }

        public CustomNotificationSender app(String string, String string2) {
            this.notification.setApp(true);
            this.notification.setAppTitle(string);
            this.notification.setAppBody(string2);
            return this;
        }

        public CustomNotificationSender appAndroidIconColor(String string) {
            this.ensureAppEnabled();
            this.notification.setAppAndroidIconColor(string);
            return this;
        }

        public CustomNotificationSender appCustomUrl(String string) {
            this.ensureAppEnabled();
            this.notification.setAppCustomUrl(string);
            return this;
        }

        public CustomNotificationSender appImageUrl(String string) {
            this.ensureAppEnabled();
            this.notification.setAppImageUrl(string);
            return this;
        }

        public CustomNotificationSender appIosUseBadge(boolean bl) {
            this.ensureAppEnabled();
            this.notification.setAppIosUseBadge(bl);
            return this;
        }

        public CustomNotificationSender appVariable(String string, String string2) {
            this.ensureAppEnabled();
            this.notification.addAppVariable(string, string2);
            return this;
        }

        public CustomNotificationSender email(String string, String string2) {
            this.notification.setEmail(true);
            this.notification.setEmailSubject(string);
            this.notification.setEmailBody(string2);
            return this;
        }

        public CustomNotificationSender emailAttachment(FileInfo fileInfo) {
            this.ensureEmailEnabled();
            this.notification.addEmailAttachment(fileInfo);
            return this;
        }

        public void send() {
            NotificationHandlerImpl.this.notifyCustom(this.notification, false);
        }

        public CustomNotificationResult sendSync() {
            return NotificationHandlerImpl.this.notifyCustom(this.notification, true);
        }

        public CustomNotificationSender sms(String string) {
            this.notification.setSms(true);
            this.notification.setSmsMessage(string);
            return this;
        }

        public CustomNotificationSender smsEvenIfDisabled() {
            this.ensureSmsEnabled();
            this.notification.setSmsEvenIfDisabled(true);
            return this;
        }

        private void ensureAppEnabled() {
            if (!this.notification.isApp()) {
                throw new ValidationException("App notifications are not enabled");
            }
        }

        private void ensureEmailEnabled() {
            if (!this.notification.isEmail()) {
                throw new ValidationException("Email is not enabled");
            }
        }

        private void ensureSmsEnabled() {
            if (!this.notification.isSms()) {
                throw new ValidationException("SMS is not enabled");
            }
        }
    }

    private static class UserNotificationContext {
        private final BasicUser destination;
        private final UserNotification notification;
        private final NotificationURL url;
        private OperatorNotificationPropagation propagation;

        public UserNotificationContext(BasicUser basicUser, UserNotification userNotification, NotificationURL notificationURL) {
            this.destination = basicUser;
            this.notification = userNotification;
            this.url = notificationURL;
            this.propagation = userNotification.getType() == AccountNotificationType.PAYMENT_RECEIVED && basicUser.isOperator() ? OperatorNotificationPropagation.DESTINATION_ONLY : userNotification.getType().getPropagation();
        }

        public <U extends BasicUser> U getDestination() {
            return (U)this.destination;
        }

        public SimpleEntity getEntity() {
            return this.url == null ? null : this.url.getEntity();
        }

        public UserNotification getNotification() {
            return this.notification;
        }

        public OperatorNotificationPropagation getPropagation() {
            return this.propagation;
        }

        public UserNotificationType getType() {
            return this.notification.getType();
        }

        public NotificationURL getUrl() {
            return this.url;
        }
    }
}

