/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cluster;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.bootstrap.DataSourceShutdownHandler;
import org.cyclos.bootstrap.DatabaseManager;
import org.cyclos.entities.utils.QBackgroundTaskExecution;
import org.cyclos.impl.ApplicationInitializationListener;
import org.cyclos.impl.ApplicationUpgradeInitializationListener;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.CyclosThreadFactory;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.sql.DbLock;
import org.cyclos.impl.sql.DbLockHandler;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.ScriptHelper;
import org.cyclos.impl.system.SystemMonitorServiceLocal;
import org.cyclos.impl.utils.GuavaLocalStorage;
import org.cyclos.impl.utils.GuavaSharedStorage;
import org.cyclos.impl.utils.LocalStorage;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.PushNotificationHandlerImplementor;
import org.cyclos.impl.utils.ReplicatedStorage;
import org.cyclos.impl.utils.SharedStorage;
import org.cyclos.impl.utils.cache.CacheHandlerImplementor;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.LocalStorageType;
import org.cyclos.impl.utils.cluster.MapReplicatedStorage;
import org.cyclos.impl.utils.cluster.ProfilingManager;
import org.cyclos.impl.utils.cluster.ReplicatedStorageType;
import org.cyclos.impl.utils.cluster.SharedStorageType;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionContext;
import org.cyclos.impl.utils.tasks.BackgroundTaskExecutionRecurringTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandlerImplementor;
import org.cyclos.impl.utils.tasks.RecurringTask;
import org.cyclos.impl.utils.tasks.RecurringTaskHandlerImplementor;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextStoppedEvent;

public abstract class AbstractClusterHandlerImpl
extends BaseGlobalHandlerImpl
implements ClusterHandler {
    public static final String IGNORE_DB_LOCK_PROPERTY = "cyclos.ignoreDatabaseLock";
    private static final Logger LOG = LogManager.getLogger(AbstractClusterHandlerImpl.class);
    private static final int MAX_BACKGROUND_TASK_PER_SECOND = 50;
    private static final double QUEUE_CAPACITY_PCT_FOR_AWAKE = 0.3;
    protected boolean ignoreDbLock = Boolean.getBoolean("cyclos.ignoreDatabaseLock");
    private CacheHandlerImplementor cacheHandler;
    private PushNotificationHandlerImplementor pushNotificationHandler;
    private ProfilingManager clusterProfilingHandler;
    private Map<SharedStorageType<?, ?>, SharedStorage<?, ?>> sharedStorages = new ConcurrentHashMap();
    private Map<LocalStorageType<?, ?>, LocalStorage<?, ?>> localStorages = new ConcurrentHashMap();
    private Map<ReplicatedStorageType, ReplicatedStorage<?, ?>> replicatedStorages = new ConcurrentHashMap();
    protected RecurringTaskHandlerImplementor recurringTaskHandler;
    private ExecutorService backgroundTaskExecutor;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected BeanHandler beanHandler;
    @Autowired
    protected CyclosProperties cyclosProperties;
    @Autowired
    @Lazy
    protected BackgroundTaskHandlerImplementor backgroundTaskHandler;
    @Autowired
    protected InvokerHandler invokerHandler;
    @Autowired
    protected LockHandler lockHandler;
    @Autowired
    @Lazy
    protected ScriptHelper scriptHelper;
    @Autowired
    @Lazy
    protected RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    protected NativeQueryHandler nativeQueryHandler;
    protected DbLockHandler dbLockHandler;
    @Autowired
    protected DatabaseManager databaseManager;
    @Lazy
    @Autowired
    protected SystemMonitorServiceLocal systemMonitorService;
    @Autowired
    private DataSourceShutdownHandler dataSourceShutdownHandler;

    public void awakeRecurringTasks(Set<RecurringTask> set) {
        for (RecurringTask recurringTask : set) {
            LOG.debug("Awaking recurring task '{}' throught the task handler", (Object)recurringTask.getName());
            this.recurringTaskHandler.awakeNow(recurringTask);
        }
    }

    public int getBackgroundTasksQueueSize() {
        return this.getBackgroundTaskQueue().size();
    }

    public final CacheHandlerImplementor getCacheHandler() {
        return this.cacheHandler;
    }

    public ProfilingManager getProfilingManager() {
        return this.clusterProfilingHandler;
    }

    public <K, V> LocalStorage<K, V> getLocalStorage(LocalStorageType<K, V> localStorageType) {
        return this.localStorages.get(localStorageType);
    }

    public int getMaxBackgroundTaskCapacity() {
        int n = this.getBackgroundTaskThreads();
        return n * 50;
    }

    public final PushNotificationHandlerImplementor getPushNotificationHandler() {
        return this.pushNotificationHandler;
    }

    public final RecurringTaskHandlerImplementor getRecurringTaskHandler() {
        return this.recurringTaskHandler;
    }

    public int getRemainingBackgroundTaskCapacity() {
        int n = this.getBackgroundTaskQueue().size();
        return Math.max(0, this.getMaxBackgroundTaskCapacity() - n);
    }

    public <K extends Serializable, V extends Serializable> ReplicatedStorage<K, V> getReplicatedStorage(ReplicatedStorageType replicatedStorageType) {
        return this.replicatedStorages.get(replicatedStorageType);
    }

    public final <K extends Serializable, V extends Serializable> SharedStorage<K, V> getSharedStorage(SharedStorageType<K, V> sharedStorageType) {
        return this.sharedStorages.get(sharedStorageType);
    }

    public boolean isCausedByShutdown(Throwable throwable) {
        return ExceptionUtils.indexOfType((Throwable)throwable, InterruptedException.class) >= 0 || ExceptionUtils.indexOfType((Throwable)throwable, BeanCreationNotAllowedException.class) >= 0;
    }

    public boolean lockDatabase() {
        if (this.ignoreDbLock) {
            LOG.info("Ignoring database lock. If there is another server connected to the same database, this instance will connect anyway.");
            return false;
        }
        this.dbLockHandler.prepare();
        if (this.shouldEnsureDatabaseIsNotLocked()) {
            String string = this.getHostId();
            LOG.info("Checking whether the database is locked from {}", (Object)string);
            DbLock dbLock = this.dbLockHandler.read();
            if (dbLock != null && dbLock.isLocked()) {
                this.dbLockHandler.sleepUntilTryingAgain(dbLock);
                dbLock = this.dbLockHandler.read();
            }
            if (dbLock != null && dbLock.isLocked()) {
                this.doContextShoutdown();
                this.throwDbAlreadyLocked(dbLock);
            }
            this.dbLockHandler.lock(string, dbLock);
            return true;
        }
        return false;
    }

    public final void runBackgroundTasks(List<BackgroundTaskExecutionContext> list) {
        BlockingQueue<BackgroundTaskExecutionContext> blockingQueue = this.getBackgroundTaskQueue();
        list.stream().filter(backgroundTaskExecutionContext -> !blockingQueue.contains(backgroundTaskExecutionContext)).forEach(blockingQueue::offer);
    }

    public boolean runInitialization(ApplicationInitializationListener applicationInitializationListener) {
        LOG.debug("Running initialization {}", (Object)applicationInitializationListener.getInitializationId());
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            applicationInitializationListener.onApplicationInitialization();
            return null;
        });
        return true;
    }

    public boolean runUpgradeInitialization(ApplicationUpgradeInitializationListener applicationUpgradeInitializationListener) {
        LOG.debug("Running upgrade initialization {}", (Object)applicationUpgradeInitializationListener.getInitializationId());
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            applicationUpgradeInitializationListener.onApplicationUpgradeInitialization();
            return null;
        });
        return true;
    }

    protected <K, V> LocalStorage<K, V> createLocalStorage(LocalStorageType<K, V> localStorageType) {
        return new GuavaLocalStorage<K, V>(localStorageType);
    }

    protected <K, V> ReplicatedStorage<K, V> createReplicatedStorage(ReplicatedStorageType replicatedStorageType) {
        return new MapReplicatedStorage();
    }

    protected <K extends Serializable, V extends Serializable> SharedStorage<K, V> createSharedStorage(SharedStorageType<K, V> sharedStorageType) {
        return new GuavaSharedStorage<K, V>(sharedStorageType);
    }

    protected void dbAlreadyLocked(DbLock dbLock) {
    }

    protected abstract void doRemoveFinishedBackgroundTaskExecutions(List<Long> var1);

    protected abstract BlockingQueue<BackgroundTaskExecutionContext> getBackgroundTaskQueue();

    protected abstract int getBackgroundTaskThreads();

    protected void initialize() {
        this.dbLockHandler = this.nativeQueryHandler.getDbLockHandler();
        this.cacheHandler = (CacheHandlerImplementor)this.beanHandler.autowire((Object)this.instantiateCacheHandler());
        this.pushNotificationHandler = (PushNotificationHandlerImplementor)this.beanHandler.autowire((Object)this.instantiatePushNotificationHandler());
        this.recurringTaskHandler = (RecurringTaskHandlerImplementor)this.beanHandler.autowire((Object)this.instantiateRecurringTaskHandler());
        this.clusterProfilingHandler = (ProfilingManager)this.beanHandler.autowire((Object)this.instantiateProfilingManager());
        LocalStorageType.all().forEach(localStorageType -> this.localStorages.put((LocalStorageType<?, ?>)localStorageType, this.createLocalStorage((LocalStorageType)localStorageType)));
        SharedStorageType.all().forEach(sharedStorageType -> this.sharedStorages.put((SharedStorageType<?, ?>)sharedStorageType, this.createSharedStorage((SharedStorageType)sharedStorageType)));
        Arrays.asList(ReplicatedStorageType.values()).forEach(replicatedStorageType -> this.replicatedStorages.put((ReplicatedStorageType)replicatedStorageType, this.createReplicatedStorage((ReplicatedStorageType)replicatedStorageType)));
        int n = this.cyclosProperties.getMaxBackgroundTasks();
        if (n > 0) {
            this.backgroundTaskExecutor = Executors.newFixedThreadPool(n, CyclosThreadFactory.CyclosThreadGroup.BACKGROUND_TASK.factory());
            for (int i = 0; i < n; ++i) {
                this.backgroundTaskExecutor.execute(new BackgroundTaskRunnable());
            }
        }
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.applicationContext;
            configurableApplicationContext.addApplicationListener(this::onContextShutdown);
        }
        if (!this.ignoreDbLock) {
            this.dataSourceShutdownHandler.register(() -> {
                if (this.shouldUnlockDatabase()) {
                    LOG.info("Unlocking database from {}", (Object)this.getHostId());
                    this.dbLockHandler.unlock();
                }
            });
        }
    }

    protected abstract CacheHandlerImplementor instantiateCacheHandler();

    protected abstract ProfilingManager instantiateProfilingManager();

    protected abstract PushNotificationHandler instantiatePushNotificationHandler();

    protected abstract RecurringTaskHandlerImplementor instantiateRecurringTaskHandler();

    protected void runBackgroundTask(BackgroundTaskExecutionContext backgroundTaskExecutionContext) {
        LOG.debug("Running background task '{}'", (Object)backgroundTaskExecutionContext);
        this.backgroundTaskHandler.execute(backgroundTaskExecutionContext);
    }

    protected abstract boolean shouldEnsureDatabaseIsNotLocked();

    protected abstract boolean shouldUnlockDatabase();

    private void doContextShoutdown() {
        if (this.backgroundTaskExecutor != null) {
            this.backgroundTaskExecutor.shutdownNow();
            this.getFinishedBackgroundTaskExecutions().update().remove();
            this.backgroundTaskExecutor = null;
        }
    }

    private void onContextShutdown(ApplicationEvent applicationEvent) {
        if (!(applicationEvent instanceof ContextStoppedEvent) && !(applicationEvent instanceof ContextClosedEvent)) {
            return;
        }
        this.doContextShoutdown();
    }

    private void removeBackgroundTaskExecutions(List<Long> list) {
        ArrayList<Long> arrayList = new ArrayList<Long>(list);
        QBackgroundTaskExecution qBackgroundTaskExecution = QBackgroundTaskExecution.backgroundTaskExecution;
        this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            this.rawEntityManagerHandler.delete((EntityPath)qBackgroundTaskExecution).where(new Predicate[]{qBackgroundTaskExecution.id.in((Collection)arrayList)}).execute();
            InvocationContext.ensure().addCommitListener(false, () -> this.doRemoveFinishedBackgroundTaskExecutions(arrayList));
            return null;
        });
    }

    private void removeFinishedBackgroundTaskExecutions(ClusterHandler.FinishedExecutionsHandler finishedExecutionsHandler) {
        if (finishedExecutionsHandler == null || finishedExecutionsHandler.isEmpty()) {
            return;
        }
        UnmodifiableIterator unmodifiableIterator = Iterators.partition(finishedExecutionsHandler.ids().iterator(), (int)10000);
        unmodifiableIterator.forEachRemaining(this::removeBackgroundTaskExecutions);
    }

    private boolean shouldAwakeBackgroundRecurringTask(int n) {
        return (double)n < Math.ceil((double)this.getMaxBackgroundTaskCapacity() * 0.3);
    }

    private void throwDbAlreadyLocked(DbLock dbLock) {
        this.dbAlreadyLocked(dbLock);
        this.dbLockHandler.throwAlreadyLocked(dbLock);
    }

    private class BackgroundTaskRunnable
    implements Runnable {
        private BackgroundTaskRunnable() {
        }

        @Override
        public void run() {
            BlockingQueue<BackgroundTaskExecutionContext> blockingQueue = AbstractClusterHandlerImpl.this.getBackgroundTaskQueue();
            while (true) {
                try {
                    while (true) {
                        BackgroundTaskExecutionContext backgroundTaskExecutionContext = blockingQueue.take();
                        if (AbstractClusterHandlerImpl.this.shouldAwakeBackgroundRecurringTask(blockingQueue.size())) {
                            AbstractClusterHandlerImpl.this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
                                AbstractClusterHandlerImpl.this.recurringTaskHandler.scheduleAwake(BackgroundTaskExecutionRecurringTask.class);
                                return null;
                            });
                        }
                        AbstractClusterHandlerImpl.this.runBackgroundTask(backgroundTaskExecutionContext);
                    }
                }
                catch (Exception exception) {
                    if (AbstractClusterHandlerImpl.this.isCausedByShutdown(exception)) {
                        return;
                    }
                    AbstractClusterHandlerImpl.this.getLogger().error("Error processing task", (Throwable)exception);
                    continue;
                }
                break;
            }
        }
    }

    public class FinishedExecutionsHandlerImpl
    implements ClusterHandler.FinishedExecutionsHandler {
        private Set<Long> ids;

        public FinishedExecutionsHandlerImpl() {
            this(new HashSet<Long>());
        }

        public FinishedExecutionsHandlerImpl(Set<Long> hashSet) {
            this.ids = Collections.synchronizedSet(hashSet instanceof HashSet ? hashSet : new HashSet(hashSet));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Long> ids() {
            Set<Long> set = this.ids;
            synchronized (set) {
                return new HashSet<Long>(this.ids);
            }
        }

        public boolean isEmpty() {
            return CollectionHelper.isEmpty(this.ids);
        }

        public ClusterHandler.FinishedExecutionsHandler remove() {
            AbstractClusterHandlerImpl.this.removeFinishedBackgroundTaskExecutions(this);
            this.ids.clear();
            return this;
        }

        public ClusterHandler.FinishedExecutionsHandler update() {
            this.ids.addAll(AbstractClusterHandlerImpl.this.getFinishedBackgroundTaskExecutions().ids());
            return this;
        }
    }
}

