/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import java.io.Serializable;
import org.cyclos.impl.utils.cache.AbstractCache;
import org.cyclos.impl.utils.cache.Cache;
import org.cyclos.impl.utils.cache.CacheHandlerImpl;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.cache.GuavaCache;
import org.cyclos.server.utils.CyclosProperties;
import org.springframework.beans.factory.annotation.Autowired;

public class GuavaCacheHandlerImpl
extends CacheHandlerImpl {
    @Autowired
    private CyclosProperties cyclosProperties;

    @Override
    protected <K extends Serializable, V> Cache<K, V> initCache(CacheType<K, V> cacheType) {
        GuavaCache.Builder<K, V> builder = new GuavaCache.Builder<K, V>(this, cacheType);
        com.google.common.cache.Cache<K, V> cache = this.createGuavaCache(cacheType.getName(), builder.getEvictListener());
        return builder.build(cache);
    }

    private <V, K> com.google.common.cache.Cache<K, V> createGuavaCache(String string, AbstractCache.EvictListener evictListener) {
        CacheBuilderSpec cacheBuilderSpec = this.cyclosProperties.getCacheSpec(string);
        CacheBuilder cacheBuilder = CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec);
        if (evictListener != null) {
            cacheBuilder = cacheBuilder.removalListener(removalNotification -> {
                if (removalNotification.wasEvicted()) {
                    evictListener.evict(1);
                }
            });
        }
        return cacheBuilder.build();
    }
}

