/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.messaging.IncomingMessage;
import org.cyclos.entities.system.CustomScriptConfiguration;
import org.cyclos.entities.system.CustomWizardExecution;
import org.cyclos.entities.system.ExternalRedirectExecution;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.InviteToken;
import org.cyclos.entities.users.User;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.messaging.NotificationSettingsServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.CustomWizardExecutionStorage;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.UserFrontendSettingsServiceLocal;
import org.cyclos.impl.utils.IdMask;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.LinkType;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.messaging.notificationsettings.EmailUnsubscribeType;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.utils.Location;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class LinkGeneratorHandlerImpl
extends BaseNetworkedHandlerImpl
implements LinkGeneratorHandler {
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    @Lazy
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    @Lazy
    private UserFrontendSettingsServiceLocal userFrontendSettingsService;
    @Autowired
    @Lazy
    private NotificationSettingsServiceLocal notificationSettingsService;
    @Autowired
    @Lazy
    private VoucherServiceLocal voucherService;
    @Autowired
    private InvokerHandler invokerHandler;

    public String customOperationExternalRedirect(ExternalRedirectExecution externalRedirectExecution) {
        Long l = this.applicationHandler.getIdMask().apply(externalRedirectExecution.getId());
        String string = externalRedirectExecution.getChannel().isMobile() ? "/mobile-redirect/externalRedirect?id=" + l + "&token=" + externalRedirectExecution.getVerificationToken() : (this.newFrontend(externalRedirectExecution.getLoggedUser()) ? "/ui/operations/callback/" + l + "/" + externalRedirectExecution.getVerificationToken() : "/external-redirect-callback/" + l + "/" + externalRedirectExecution.getVerificationToken());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("execution", externalRedirectExecution);
        hashMap.put("externalRedirectExecution", externalRedirectExecution);
        return this.doGenerateLink(LinkType.EXTERNAL_REDIRECT, (BasicUser)externalRedirectExecution.getUser(), string, hashMap);
    }

    public String customWizardExecution(CustomWizardExecution customWizardExecution, CustomWizardExecutionStorage customWizardExecutionStorage) {
        String string = this.newFrontend(customWizardExecution.getLoggedUser()) ? "/ui/wizards/run/" + customWizardExecution.getKey() : "/classic/#system.wizards.run!key=" + customWizardExecution.getKey();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("execution", customWizardExecution);
        hashMap.put("storage", customWizardExecutionStorage);
        return this.doGenerateLink(LinkType.WIZARD_EXECUTION, customWizardExecution.getLoggedUser(), string, hashMap);
    }

    public String customWizardExternalRedirect(CustomWizardExecution customWizardExecution, CustomWizardExecutionStorage customWizardExecutionStorage) {
        String string = customWizardExecution.getChannel().isMobile() ? "/mobile-redirect/wizardExternalRedirect?key=" + customWizardExecution.getKey() : (this.newFrontend(customWizardExecution.getLoggedUser()) ? "/ui/wizards/callback/" + customWizardExecution.getKey() : "/wizard-external-callback/" + customWizardExecution.getKey());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("execution", customWizardExecution);
        hashMap.put("storage", customWizardExecutionStorage);
        return this.doGenerateLink(LinkType.WIZARD_EXTERNAL_REDIRECT, (BasicUser)customWizardExecution.getUser(), string, hashMap);
    }

    public String easyInvoice(LocateUserResult locateUserResult, BigDecimal bigDecimal, String string2, Currency currency, PaymentTransferType paymentTransferType, Map<TransactionCustomField, String> map) {
        IdMask idMask = this.applicationHandler.getIdMask();
        StringBuilder stringBuilder = new StringBuilder("/pay");
        stringBuilder.append("?to=");
        if (locateUserResult.getPrincipalType() != null && locateUserResult.getPrincipalType().getInternalName() != null) {
            stringBuilder.append(locateUserResult.getPrincipalType().getInternalName()).append(":");
        }
        stringBuilder.append(locateUserResult.getPrincipal());
        if (bigDecimal != null) {
            stringBuilder.append("&amount=").append(bigDecimal.toPlainString());
        }
        if (currency != null) {
            stringBuilder.append("&currency=").append(ObjectHelper.defaultValue((Object)this.entityManagerHandler.getQualifiedInternalName((IInternalNamedEntity)currency), (Object)idMask.apply(currency.getId())));
        }
        if (paymentTransferType != null) {
            stringBuilder.append("&type=").append(ObjectHelper.defaultValue((Object)this.entityManagerHandler.getQualifiedInternalName((IInternalNamedEntity)paymentTransferType), (Object)idMask.apply(paymentTransferType.getId())));
        }
        if (StringHelper.isNotBlank((Object)string2)) {
            stringBuilder.append("&description=").append(StringHelper.encodeURIComponent((String)string2));
        }
        if (CollectionHelper.isNotEmpty(map)) {
            map.forEach((transactionCustomField, string) -> stringBuilder.append('&').append(transactionCustomField.getInternalName()).append('=').append(StringHelper.encodeURIComponent((String)string)));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("paymentTo", locateUserResult);
        hashMap.put("paymentAmount", bigDecimal);
        hashMap.put("paymentCurrency", currency);
        hashMap.put("paymentType", paymentTransferType);
        hashMap.put("paymentDescription", string2);
        hashMap.put("paymentCustomValues", map);
        return this.doGenerateLink(LinkType.EASY_INVOICE, (BasicUser)locateUserResult.getUser(), stringBuilder.toString(), hashMap);
    }

    public String emailChange(String string, BasicUser basicUser) {
        String string2 = this.newFrontend(basicUser) ? "/ui/users/validate-email-change/" + string : "/content/users/validateEmailChange?key=" + string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("validationKey", string);
        return this.doGenerateLink(LinkType.EMAIL_CHANGE, basicUser, string2, hashMap);
    }

    public String emailUnsubscribe(EmailUnsubscribeType emailUnsubscribeType, BasicUser basicUser) {
        String string = this.notificationSettingsService.keyForEmailUnsubscribe(basicUser, emailUnsubscribeType);
        String string2 = "/unsubscribe/" + string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("unsubscribeEmailKey", string);
        hashMap.put("unsubscribeEmailType", emailUnsubscribeType);
        return this.doGenerateLink(LinkType.UNSUBSCRIBE_EMAIL, basicUser, string2, hashMap);
    }

    public String home(BasicUser basicUser) {
        String string = this.newFrontend(basicUser) ? "/ui/home" : "/classic/#home";
        return this.doGenerateLink(LinkType.HOME, basicUser, string, Collections.emptyMap());
    }

    public String identityProviderCallback(IdentityProvider identityProvider) {
        String string = "/identity-providers/callback";
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("identityProvider", identityProvider);
        return this.doGenerateLink(LinkType.IDENTITY_PROVIDER_CALLBACK, null, string, this.getRootSupplier(identityProvider), hashMap);
    }

    public String identityProviderRedirect(IdentityProvider identityProvider, String string) {
        String string2 = "/identity-providers/redirect/" + string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("identityProvider", identityProvider);
        hashMap.put("requestId", string);
        return this.doGenerateLink(LinkType.IDENTITY_PROVIDER_REDIRECT, null, string2, this.getRootSupplier(identityProvider), hashMap);
    }

    public String invite(InviteToken inviteToken) {
        String string = this.newFrontend(inviteToken.getBy()) ? "/ui/invite/" + inviteToken.getToken() : "?inviteToken=" + inviteToken.getToken();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("inviteToken", inviteToken);
        return this.doGenerateLink(LinkType.INVITE, null, string, hashMap);
    }

    public String location(Location location, BasicUser basicUser) {
        return this.location(location, (String)null, (String)null, basicUser);
    }

    public String location(Location location, Long l, BasicUser basicUser) {
        return this.location(location, "id", l, basicUser);
    }

    public String location(Location location, String string, Long l, BasicUser basicUser) {
        return this.location(location, string, l == null ? (String)null : String.valueOf(this.applicationHandler.getIdMask().apply(l)), basicUser);
    }

    public String location(Location location, String string, String string2, BasicUser basicUser) {
        String string3;
        if (this.newFrontend(basicUser)) {
            string3 = "/ui/redirect/" + StringHelper.camelize((String)location.name());
            if (string2 != null) {
                string3 = (String)string3 + "?" + string + "=" + string2;
            }
        } else {
            string3 = "/classic/#redirect!location=" + String.valueOf(location);
            if (string2 != null) {
                string3 = string3 + "&" + string + "=" + string2;
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("location", location);
        hashMap.put("entityId", string2);
        hashMap.put("entityIdParam", string);
        return this.doGenerateLink(LinkType.NOTIFICATION, basicUser, string3, hashMap);
    }

    public String login(BasicUser basicUser) {
        String string = this.configurationHandler.getAccessor(basicUser).getFrontend() == Frontend.NEW ? "/ui/login" : "/classic/#login";
        return this.doGenerateLink(LinkType.LOGIN, basicUser, string, Collections.emptyMap());
    }

    public String mobile(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        string = StringUtils.removeStart((String)string, (String)"/");
        hashMap.put("mobileUrlFilePart", string);
        String string2 = this.runLinkGenerationScript(LinkType.MOBILE, null, string, hashMap);
        if (StringHelper.isNotBlank((Object)string2)) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append("cyclos").append("://").append(string).toString();
    }

    public String mobileRedirect(String string, BasicUser basicUser) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("mobileUrlFilePart", string);
        String string2 = "/mobile-redirect/" + StringHelper.removeStart((String)string, (String)"/");
        String string3 = this.runLinkGenerationScript(LinkType.MOBILE_REDIRECT, basicUser, string2, hashMap);
        if (StringHelper.isNotBlank((Object)string3)) {
            return string3;
        }
        return StringHelper.removeEnd((String)this.root(basicUser), (String)"/") + string2;
    }

    public String mobileScheme() {
        try {
            return this.mobile("");
        }
        catch (Exception exception) {
            return "cyclos";
        }
    }

    public String registrationValidation(String string, BasicUser basicUser) {
        String string2 = this.newFrontend(basicUser) ? "/ui/users/validate-registration/" + string : "/content/users/validateRegistration?key=" + string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("validationKey", string);
        return this.doGenerateLink(LinkType.REGISTRATION_VALIDATION, basicUser, string2, hashMap);
    }

    public String registrationWithExternalPayment(ExternalPayment externalPayment) {
        return this.location(Location.PUBLIC_USER_REGISTRATION, "externalPaymentToken", externalPayment.getToken(), (BasicUser)this.getLoggedUser());
    }

    public String replyMessage(IncomingMessage incomingMessage) {
        Long l = this.applicationHandler.getIdMask().apply(incomingMessage.getId());
        User user = incomingMessage.getOwner();
        String string = this.newFrontend((BasicUser)user) ? "/ui/users/messages/reply/" + l : "/classic/#messaging.messages.reply!replyId=" + l;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("replyTo", incomingMessage);
        return this.doGenerateLink(LinkType.REPLY_MESSAGE, (BasicUser)user, string, hashMap);
    }

    public String root(BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor = basicUser == null ? this.getConfiguration() : this.configurationHandler.getAccessor(basicUser);
        return this.doGenerateLink(LinkType.ROOT, basicUser, "", () -> ((ConfigurationAccessor)configurationAccessor).getFullUrl(), Collections.emptyMap());
    }

    public String ticket(Ticket ticket) {
        String string = "/pay/" + ticket.getTicketNumber();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("ticket", ticket);
        return this.doGenerateLink(LinkType.TICKET, (BasicUser)ticket.getFromUser(), string, hashMap);
    }

    public String voucherInfo() {
        String string = "/voucher";
        return this.doGenerateLink(LinkType.VOUCHER_INFO, null, string, Collections.emptyMap());
    }

    public String voucherInfo(Voucher voucher) {
        String string = (String)this.invokerHandler.runAs(SessionDataFactory.system(), () -> this.voucherService.formatToken(voucher));
        Object object = this.voucherInfo();
        if (string != null) {
            object = StringHelper.removeEnd((String)object, (String)"/") + "/" + string;
        }
        return object;
    }

    private String doGenerateLink(LinkType linkType, BasicUser basicUser, String string, Map<String, Object> map) {
        return this.doGenerateLink(linkType, basicUser, string, () -> this.root(basicUser), map);
    }

    private String doGenerateLink(LinkType linkType, BasicUser basicUser, String string, Supplier<String> supplier, Map<String, Object> map) {
        String string2 = this.runLinkGenerationScript(linkType, basicUser, string, map);
        if (StringHelper.isNotBlank((Object)string2)) {
            return string2;
        }
        String string3 = supplier.get();
        return StringHelper.removeEnd((String)(StringHelper.removeEnd((String)string3, (String)"/") + "/" + StringUtils.removeStart((String)string, (String)"/")), (String)"/");
    }

    private Supplier<String> getRootSupplier(IdentityProvider identityProvider) {
        return () -> this.configurationHandler.getAccessor(identityProvider.getNetwork()).getApiUrl();
    }

    private boolean newFrontend(BasicUser basicUser) {
        return this.userFrontendSettingsService.getFrontend(basicUser) == Frontend.NEW;
    }

    private String runLinkGenerationScript(LinkType linkType, BasicUser basicUser, String string, Map<String, Object> map) {
        ConfigurationAccessor configurationAccessor = basicUser == null ? this.getConfiguration() : this.configurationHandler.getAccessor(basicUser);
        CustomScriptConfiguration customScriptConfiguration = configurationAccessor.getLinkGenerationConfiguration();
        if (customScriptConfiguration == null || customScriptConfiguration.getScript() == null) {
            return null;
        }
        String string2 = customScriptConfiguration.getScriptParameters();
        String string3 = (String)this.customScriptService.newAccessor(customScriptConfiguration.getScript(), string2).bind("type", (Object)linkType).bind("user", (Object)basicUser).bind("urlFilePart", (Object)string).bindAll(map).run(String.class);
        return string3;
    }
}

