/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.utils;

import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.owasp.html.AttributePolicy;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class HtmlSanitizerPolicy {
    private static final Pattern COLOR_NAME = Pattern.compile("(?:aqua|black|blue|fuchsia|gray|grey|green|lime|maroon|navy|olive|purple|red|silver|teal|white|yellow)");
    private static final Pattern COLOR_CODE = Pattern.compile("(?:#(?:[0-9a-fA-F]{3}(?:[0-9a-fA-F]{3})?))");
    private static final Pattern NUMBER_OR_PERCENT = Pattern.compile("[0-9]+%?");
    private static final Pattern PARAGRAPH = Pattern.compile("(?:[\\p{L}\\p{N},'\\.\\s\\-_\\(\\)]|&[0-9]{2};)*");
    private static final Pattern HTML_ID = Pattern.compile("[a-zA-Z0-9\\:\\-_\\.]+");
    private static final Pattern HTML_TITLE = Pattern.compile("[\\p{L}\\p{N}\\s\\-_',:\\[\\]!\\./\\\\\\(\\)&]*");
    private static final Pattern HTML_CLASS = Pattern.compile("[a-zA-Z0-9\\s,\\-_]+");
    private static final Pattern ONSITE_URL = Pattern.compile("(?:[\\p{L}\\p{N}\\\\\\.\\#@\\$%\\+&;\\-_~,\\?=/!]+|\\#(\\w)+)");
    private static final Pattern OFFSITE_URL = Pattern.compile("\\s*(?:(?:ht|f)tps?://|mailto:)[\\p{L}\\p{N}][\\p{L}\\p{N}\\p{Zs}\\.\\#@\\$%\\+&;:\\-_~,\\?=/!\\(\\)]*\\s*");
    private static final Pattern NUMBER = Pattern.compile("[+-]?(?:(?:[0-9]+(?:\\.[0-9]*)?)|\\.[0-9]+)");
    private static final Pattern NAME = Pattern.compile("[a-zA-Z0-9\\-_\\.\\$]+");
    private static final Pattern ALIGN = Pattern.compile("(?i)center|left|right|justify|char");
    private static final Pattern VALIGN = Pattern.compile("(?i)baseline|bottom|middle|top");
    private static final Predicate<String> COLOR_NAME_OR_COLOR_CODE = string -> COLOR_NAME.matcher((CharSequence)string).matches() || COLOR_CODE.matcher((CharSequence)string).matches();
    private static final Predicate<String> INTERNAL_URL;
    private static final Predicate<String> ANY_URL;
    private static final Pattern ONE_CHAR;
    private static final PolicyFactory ADMINS_POLICY;
    private static final PolicyFactory USERS_POLICY;

    public static PolicyFactory adminsPolicy() {
        return ADMINS_POLICY;
    }

    public static PolicyFactory usersPolicy() {
        return USERS_POLICY;
    }

    private static HtmlPolicyBuilder fill(HtmlPolicyBuilder htmlPolicyBuilder, boolean bl) {
        htmlPolicyBuilder.allowAttributes(new String[]{"id"}).matching(HTML_ID).globally().allowAttributes(new String[]{"class"}).matching(HTML_CLASS).globally().allowAttributes(new String[]{"style"}).matching(AttributePolicy.IDENTITY_ATTRIBUTE_POLICY).globally().allowAttributes(new String[]{"lang"}).matching(Pattern.compile("[a-zA-Z]{2,20}")).globally().allowAttributes(new String[]{"title"}).matching(HTML_TITLE).globally().allowAttributes(new String[]{"for"}).matching(HTML_ID).onElements(new String[]{"label"}).allowAttributes(new String[]{"color"}).matching(COLOR_NAME_OR_COLOR_CODE).onElements(new String[]{"font"}).allowAttributes(new String[]{"face"}).matching(Pattern.compile("[\\w;, \\-]+")).onElements(new String[]{"font"}).allowAttributes(new String[]{"size"}).matching(NUMBER).onElements(new String[]{"font"}).allowAttributes(new String[]{"href"}).matching(ANY_URL).onElements(new String[]{"a"}).allowStandardUrlProtocols().allowAttributes(new String[]{"nohref", "target", "rel"}).onElements(new String[]{"a"}).allowAttributes(new String[]{"name"}).matching(NAME).onElements(new String[]{"a"}).allowAttributes(new String[]{"src"}).matching(bl ? ANY_URL : INTERNAL_URL).onElements(new String[]{"img"}).allowAttributes(new String[]{"name"}).matching(NAME).onElements(new String[]{"img"}).allowAttributes(new String[]{"alt"}).matching(PARAGRAPH).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "hspace", "vspace"}).matching(NUMBER).onElements(new String[]{"img"}).allowAttributes(new String[]{"border", "cellpadding", "cellspacing"}).matching(NUMBER).onElements(new String[]{"table"}).allowAttributes(new String[]{"bgcolor"}).matching(COLOR_NAME_OR_COLOR_CODE).onElements(new String[]{"table"}).allowAttributes(new String[]{"background"}).matching(ONSITE_URL).onElements(new String[]{"table"}).allowAttributes(new String[]{"align"}).matching(ALIGN).onElements(new String[]{"table"}).allowAttributes(new String[]{"noresize"}).matching(Pattern.compile("(?i)noresize")).onElements(new String[]{"table"}).allowAttributes(new String[]{"background"}).matching(ONSITE_URL).onElements(new String[]{"td", "th", "tr"}).allowAttributes(new String[]{"bgcolor"}).matching(COLOR_NAME_OR_COLOR_CODE).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"abbr"}).matching(PARAGRAPH).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"axis", "headers"}).matching(NAME).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"scope"}).matching(Pattern.compile("(?i)(?:row|col)(?:group)?")).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"nowrap"}).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"height", "width"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"table", "td", "th", "tr", "img"}).allowAttributes(new String[]{"align"}).matching(ALIGN).onElements(new String[]{"thead", "tbody", "tfoot", "img", "td", "th", "tr", "colgroup", "col", "p", "div"}).allowAttributes(new String[]{"valign"}).matching(VALIGN).onElements(new String[]{"thead", "tbody", "tfoot", "td", "th", "tr", "colgroup", "col"}).allowAttributes(new String[]{"charoff"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"td", "th", "tr", "colgroup", "col", "thead", "tbody", "tfoot"}).allowAttributes(new String[]{"char"}).matching(ONE_CHAR).onElements(new String[]{"td", "th", "tr", "colgroup", "col", "thead", "tbody", "tfoot"}).allowAttributes(new String[]{"colspan", "rowspan"}).matching(NUMBER).onElements(new String[]{"td", "th"}).allowAttributes(new String[]{"span", "width"}).matching(NUMBER_OR_PERCENT).onElements(new String[]{"colgroup", "col"}).allowElements(new String[]{"a", "label", "noscript", "h1", "h2", "h3", "h4", "h5", "h6", "p", "i", "b", "u", "strong", "em", "small", "big", "pre", "code", "cite", "samp", "sub", "sup", "strike", "center", "blockquote", "hr", "br", "col", "font", "map", "span", "div", "img", "ul", "ol", "li", "dd", "dt", "dl", "tbody", "thead", "tfoot", "table", "td", "th", "tr", "colgroup", "caption", "fieldset", "legend", "mark", "bdi", "bdo", "del", "details", "summary"});
        return htmlPolicyBuilder;
    }

    static {
        ANY_URL = string -> ONSITE_URL.matcher((CharSequence)string).matches() || OFFSITE_URL.matcher((CharSequence)string).matches();
        INTERNAL_URL = string -> {
            if (!ANY_URL.apply(string)) {
                return false;
            }
            SessionData sessionData = InvocationContext.getSessionData();
            return StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)sessionData.getConfiguration().getRootUrl()) || StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)sessionData.getRequestData().getBaseUrl()) || StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)sessionData.getRequestData().getApiUrl());
        };
        ONE_CHAR = Pattern.compile(".?", 32);
        ADMINS_POLICY = HtmlSanitizerPolicy.fill(new HtmlPolicyBuilder().allowAttributes(new String[]{"action", "target", "method", "enctype", "accept", "accept-charset"}).onElements(new String[]{"form"}).allowAttributes(new String[]{"type", "src", "name", "value", "checked", "disabled", "readonly", "maxlength", "size"}).onElements(new String[]{"input", "button", "textarea"}).allowTextIn(new String[]{"button"}).allowAttributes(new String[]{"name", "size", "multiple", "disabled"}).onElements(new String[]{"select"}).allowAttributes(new String[]{"disabled", "label"}).onElements(new String[]{"optgroup"}).allowAttributes(new String[]{"selected", "disabled", "label", "value"}).onElements(new String[]{"option"}).allowTextIn(new String[]{"option"}).allowAttributes(new String[]{"name", "scrolling", "align", "width", "height"}).onElements(new String[]{"iframe"}).allowAttributes(new String[]{"src"}).matching(ANY_URL).onElements(new String[]{"iframe"}).allowElements(new String[]{"form", "input", "button", "textarea", "select", "optgroup", "option", "iframe"}), true).toFactory();
        USERS_POLICY = HtmlSanitizerPolicy.fill(new HtmlPolicyBuilder(), false).toFactory();
    }
}

