/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.QUserStatusLog;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserStatusLog;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.AccessClientServiceLocal;
import org.cyclos.impl.access.LoginServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.TokenServiceLocal;
import org.cyclos.impl.access.UserIdentityProviderServiceLocal;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.contentmanagement.DocumentServiceLocal;
import org.cyclos.impl.contentmanagement.UserCustomImageServiceLocal;
import org.cyclos.impl.marketplace.AdDeliveryMethodServiceLocal;
import org.cyclos.impl.marketplace.AdInterestServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.marketplace.AdWebShopSettingServiceLocal;
import org.cyclos.impl.messaging.MessageServiceLocal;
import org.cyclos.impl.messaging.NotificationServiceLocal;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.BrokeringServiceLocal;
import org.cyclos.impl.users.ConnectedUserServiceLocal;
import org.cyclos.impl.users.ContactInfoServiceLocal;
import org.cyclos.impl.users.ContactServiceLocal;
import org.cyclos.impl.users.GeneralReferenceServiceLocal;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.RecordServiceLocal;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.users.UserImageServiceLocal;
import org.cyclos.impl.users.UserQuickAccessServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.system.entitylogs.EntityActionLog;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.OperatorExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.UserExtensionPointEvent;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.ChangeUserStatusData;
import org.cyclos.model.users.users.ChangeUserStatusParams;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserStatusLogVO;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserStatusServiceImpl
extends BaseServiceImpl
implements UserStatusServiceLocal {
    private static String USER_STATUS_PROPERTY_NAME = "status";
    private final QUserStatusLog $ = QUserStatusLog.userStatusLog;
    @Autowired
    private AdServiceLocal adService;
    @Autowired
    private AdDeliveryMethodServiceLocal adDeliveryMethodService;
    @Autowired
    private AdInterestServiceLocal adInterestService;
    @Autowired
    private AdWebShopSettingServiceLocal adWebShopSettingService;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private BrokeringServiceLocal brokeringService;
    @Autowired
    private UserImageServiceLocal userImageService;
    @Autowired
    private UserCustomImageServiceLocal userCustomImageService;
    @Autowired
    private UserQuickAccessServiceLocal userQuickAccessService;
    @Autowired
    private NotificationServiceLocal notificationService;
    @Autowired
    private MessageServiceLocal messageService;
    @Autowired
    private ConnectedUserServiceLocal connectedUserService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private ContactServiceLocal contactService;
    @Autowired
    private TokenServiceLocal tokenService;
    @Autowired
    private AccessClientServiceLocal accessClientService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private PhoneServiceLocal phoneService;
    @Autowired
    private UserAddressServiceLocal userAddressService;
    @Autowired
    private ContactInfoServiceLocal contactInfoService;
    @Autowired
    private DocumentServiceLocal documentService;
    @Autowired
    private EntityLogServiceLocal entityLogService;
    @Autowired
    private LoginServiceLocal loginService;
    @Autowired
    private RecordServiceLocal recordService;
    @Autowired
    private GeneralReferenceServiceLocal generalReferenceService;
    @Autowired
    private TransactionFeedbackServiceLocal transactionFeedbackService;
    @Autowired
    private UserCustomFieldServiceLocal userCustomFieldService;
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private UserIdentityProviderServiceLocal userIdentityProviderService;

    public void changeStatus(ChangeUserStatusParams changeUserStatusParams) throws FrameworkException {
        boolean bl;
        BasicUser basicUser = this.validate(changeUserStatusParams);
        Operator operator = (Operator)ObjectHelper.ifType((Object)basicUser, Operator.class);
        User user = (User)ObjectHelper.ifType((Object)basicUser, User.class);
        UserStatus userStatus = changeUserStatusParams.getStatus();
        UserStatus userStatus2 = basicUser.getStatus();
        ExtensionPointAccessor extensionPointAccessor = null;
        if (user != null) {
            extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)UserExtensionPointEvent.CHANGE_STATUS, new ExtensionPointFilter(user.getGroup()));
        } else if (operator != null) {
            extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)OperatorExtensionPointEvent.CHANGE_STATUS, new ExtensionPointFilter(operator.getUser().getGroup()));
        } else {
            throw new IllegalArgumentException("Invalid user: " + String.valueOf(basicUser));
        }
        extensionPointAccessor.attribute("user", (Object)user).attribute("operator", (Object)operator).attribute("oldStatus", (Object)basicUser.getStatus()).attribute("newStatus", (Object)userStatus).attribute("comments", (Object)changeUserStatusParams.getComment());
        extensionPointAccessor.fireValidated();
        boolean bl2 = bl = user != null && user.getActivationDate() == null && userStatus == UserStatus.ACTIVE;
        if (!(userStatus.isRemoved() || operator == null && bl)) {
            this.notificationHandler.user(basicUser).personal().userStatusChanged(basicUser, userStatus);
        }
        this.connectedUserService.disconnect(new UserLocatorVO(basicUser.getId()));
        basicUser.setStatus(userStatus);
        if (userStatus.isRemoved()) {
            this.invokerHandler.runAs(SessionDataFactory.system(), () -> {
                this.removeRelatedData(basicUser, userStatus == UserStatus.PURGED);
                return null;
            });
        }
        Date date = new Date();
        UserStatusLog userStatusLog = this.getLastLog(basicUser);
        if (userStatusLog != null) {
            userStatusLog.setEndDate(date);
        }
        this.log(basicUser, changeUserStatusParams.getComment());
        this.entityLogService.log((SimpleEntity)basicUser, this.message(UsersKeys.Users.STATUS, new Object[0]), USER_STATUS_PROPERTY_NAME, this.getFormatter().format((HasMessageKey)userStatus2), this.getFormatter().format((HasMessageKey)userStatus), EntityActionLog.CHANGE_USER_STATUS);
        if (user != null) {
            if (userStatus == UserStatus.ACTIVE) {
                this.userService.activateUserIfNeeded(user);
            }
            if (user.isRemoved()) {
                this.userSearchHandler.index((NetworkedEntity)user);
            } else {
                this.userSearchHandler.updateUserFields(user);
            }
        }
        extensionPointAccessor.fireSaved();
    }

    public void createStatusLog(BasicUser basicUser) {
        String string = this.message(basicUser instanceof Operator ? UsersKeys.Operators.INITIAL_LOG_DESCRIPTION : UsersKeys.Users.INITIAL_LOG_DESCRIPTION, new Object[0]);
        this.log(basicUser, string);
    }

    public ChangeUserStatusData getData(UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        ChangeUserStatusData changeUserStatusData = new ChangeUserStatusData();
        changeUserStatusData.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        changeUserStatusData.setStatus(basicUser.getStatus());
        List<UserStatus> list = this.getPossibleNewStatuses(basicUser);
        changeUserStatusData.setPossibleNewStatuses(list);
        changeUserStatusData.setHistory(((DBQuery)((DBQuery)this.from(new EntityPath[]{this.$}).where((Predicate)this.$.user().eq((Object)basicUser))).orderBy(this.$.startDate.desc())).list(UserStatusLogVO.class, (Expression)this.$));
        return changeUserStatusData;
    }

    public List<UserStatus> getManagedStatuses() {
        return this.doGetManagedStatuses(null);
    }

    public List<UserStatus> getManagedStatuses(BasicUser basicUser) {
        if (basicUser == null) {
            throw new IllegalArgumentException();
        }
        return this.doGetManagedStatuses(basicUser);
    }

    public List<UserStatus> getPossibleNewStatuses(BasicUser basicUser) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return new ArrayList<UserStatus>(this.getPossibleNewStatuses(basicUser.getStatus()));
        }
        if (!sessionData.isManagerOf(basicUser) && !sessionData.isOwnerOf(basicUser)) {
            return Collections.emptyList();
        }
        List<UserStatus> list = basicUser.isOperator() ? new ArrayList<UserStatus>(EnumSet.complementOf(EnumSet.of(UserStatus.PENDING))) : this.getManagedStatuses(basicUser);
        ArrayList<UserStatus> arrayList = new ArrayList<UserStatus>(this.getPossibleNewStatuses(basicUser.getStatus()));
        arrayList.retainAll(list);
        return arrayList;
    }

    public List<UserStatus> getStatusesForUserSearch(boolean bl) {
        SessionData sessionData = this.getSessionData();
        ArrayList<UserStatus> arrayList = new ArrayList<UserStatus>();
        if (sessionData.isAdmin() || bl) {
            arrayList.add(UserStatus.ACTIVE);
            arrayList.add(UserStatus.BLOCKED);
            if (sessionData.hasPermission(Permission.PENDING_USERS_VIEW)) {
                arrayList.add(UserStatus.PENDING);
            }
            if (sessionData.hasPermission(Permission.DISABLED_USERS_VIEW)) {
                arrayList.add(UserStatus.DISABLED);
            }
            if (sessionData.hasPermission(Permission.REMOVED_USERS_VIEW)) {
                arrayList.add(UserStatus.REMOVED);
            }
            if (sessionData.hasPermission(Permission.PURGED_USERS_VIEW)) {
                arrayList.add(UserStatus.PURGED);
            }
        }
        return arrayList;
    }

    public void setInitialStatusOnEmailValidation(BasicUser basicUser) {
        UserStatus userStatus = basicUser instanceof Operator ? UserStatus.ACTIVE : ((User)basicUser).getGroup().getInitialUserStatus();
        basicUser.setStatus(userStatus);
        this.log(basicUser, this.message(UsersKeys.Users.EMAIL_VALIDATION_LOG_DESCRIPTION, new Object[0]));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QUserStatusLog.userStatusLog.user().network());
    }

    private List<UserStatus> doGetManagedStatuses(BasicUser basicUser) {
        SessionData sessionData = this.getSessionData();
        boolean bl = sessionData.hasPermission(Permission.BLOCKED_USERS_MANAGE);
        boolean bl2 = sessionData.hasPermission(Permission.DISABLED_USERS_MANAGE);
        boolean bl3 = sessionData.hasPermission(Permission.REMOVED_USERS_MANAGE);
        boolean bl4 = sessionData.hasPermission(Permission.PURGED_USERS_MANAGE);
        boolean bl5 = true;
        if (basicUser != null) {
            switch (basicUser.getStatus()) {
                case BLOCKED: {
                    bl5 = bl;
                    break;
                }
                case DISABLED: {
                    bl5 = bl2;
                    break;
                }
                case PURGED: {
                    bl5 = bl4;
                    break;
                }
                case REMOVED: {
                    bl5 = bl3;
                    break;
                }
            }
        }
        ArrayList<UserStatus> arrayList = new ArrayList<UserStatus>();
        if (bl5) {
            if (bl && (basicUser == null || basicUser.getStatus() == UserStatus.BLOCKED) || bl2 && (basicUser == null || basicUser.getStatus() == UserStatus.DISABLED)) {
                arrayList.add(UserStatus.ACTIVE);
            }
            if (bl) {
                arrayList.add(UserStatus.BLOCKED);
            }
            if (bl2) {
                arrayList.add(UserStatus.DISABLED);
            }
            if (bl3) {
                arrayList.add(UserStatus.REMOVED);
            }
            if (bl4) {
                arrayList.add(UserStatus.PURGED);
            }
        }
        return arrayList;
    }

    private UserStatusLog getLastLog(BasicUser basicUser) {
        return (UserStatusLog)((DBQuery)((DBQuery)this.from(new EntityPath[]{this.$}).where((Predicate)this.$.user().eq((Object)basicUser))).orderBy(this.$.startDate.desc())).singleResult((Expression)this.$);
    }

    private Set<UserStatus> getPossibleNewStatuses(UserStatus userStatus) {
        switch (userStatus) {
            case PENDING: {
                return Collections.emptySet();
            }
            case ACTIVE: {
                return EnumSet.of(UserStatus.BLOCKED, UserStatus.DISABLED, UserStatus.REMOVED, UserStatus.PURGED);
            }
            case BLOCKED: {
                return EnumSet.of(UserStatus.ACTIVE, UserStatus.DISABLED, UserStatus.REMOVED, UserStatus.PURGED);
            }
            case DISABLED: {
                return EnumSet.of(UserStatus.ACTIVE, UserStatus.BLOCKED, UserStatus.REMOVED, UserStatus.PURGED);
            }
            case REMOVED: {
                return Collections.singleton(UserStatus.PURGED);
            }
            case PURGED: {
                return Collections.emptySet();
            }
        }
        throw new IllegalStateException("Unhandled status: " + String.valueOf(userStatus));
    }

    private UserStatusLog log(BasicUser basicUser, String string) {
        Date date = new Date();
        UserStatusLog userStatusLog = this.getLastLog(basicUser);
        if (userStatusLog != null) {
            userStatusLog.setEndDate(date);
        }
        UserStatusLog userStatusLog2 = new UserStatusLog();
        userStatusLog2.setUser(basicUser);
        userStatusLog2.setStatus(basicUser.getStatus());
        userStatusLog2.setBy(this.getLoggedBasicUser());
        userStatusLog2.setStartDate(date);
        userStatusLog2.setComment(string);
        this.persist((IEntity)userStatusLog2);
        return userStatusLog2;
    }

    private void removeRelatedData(BasicUser basicUser, boolean bl) {
        if (basicUser instanceof User) {
            User user = (User)basicUser;
            if (user.isMember()) {
                this.accountService.adjustAccounts(user);
                this.adService.removeAll(user, true);
                this.adService.removeAllFavorites(user);
                this.adInterestService.removeAll(user);
                this.adDeliveryMethodService.removeAll(user);
                this.adWebShopSettingService.remove(user);
                this.messageService.removeAll(user);
                this.operatorService.removeAll(user, bl);
                if (user.isBroker()) {
                    this.brokeringService.removeAllBrokered(user);
                }
            }
            this.accessClientService.removeAll(user);
            this.userQuickAccessService.removeAll((BasicUser)user);
            this.contactService.removeAll(user);
            this.userImageService.removeAll((BaseEntity)user);
            this.userCustomImageService.removeAll((BaseEntity)user);
            if (bl) {
                this.contactInfoService.removeAll(user);
                this.userAddressService.removeAll(user);
                this.documentService.removeAll(user);
                this.recordService.purgeAll(user);
                this.generalReferenceService.removeAll(user);
                this.transactionFeedbackService.removeAll(user);
            }
        }
        this.userIdentityProviderService.removeAll(basicUser);
        if (bl) {
            this.tokenService.removeAll(basicUser);
            this.entityManagerHandler.refresh((IEntity)basicUser);
            basicUser.setEmail(null);
            basicUser.setNewEmail(null);
            this.userCustomFieldService.purgeValues(basicUser);
            this.phoneService.removeAll(basicUser);
            this.entityLogService.removeAll(basicUser);
            this.loginService.removeAllLogs(basicUser);
        } else {
            this.tokenService.cancelAll(basicUser);
        }
        this.notificationService.removeAll(basicUser);
    }

    private BasicUser validate(ChangeUserStatusParams changeUserStatusParams) {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)changeUserStatusParams.getUser());
        Validator validator = new Validator();
        validator.property((Property)ChangeUserStatusParams.STATUS, UsersKeys.Users.STATUS).required().anyOf(this.getPossibleNewStatuses(basicUser));
        validator.property((Property)ChangeUserStatusParams.COMMENT, UsersKeys.Users.CHANGE_STATUS_COMMENT);
        this.validate(validator, changeUserStatusParams, "changeUserStatusParams");
        return basicUser;
    }
}

