/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.BrokerGroup;
import org.cyclos.entities.users.BrokerProduct;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.MemberGroup;
import org.cyclos.entities.users.ProductOwner;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.QUserGroupLog;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroupLog;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.users.BrokeringServiceLocal;
import org.cyclos.impl.users.ConnectedUserServiceLocal;
import org.cyclos.impl.users.GroupListViewFactory;
import org.cyclos.impl.users.UserGroupServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.IEntity;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.entitylogs.EntityActionLog;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.UserExtensionPointEvent;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.groups.ChangeGroupDTO;
import org.cyclos.model.users.groups.ChangeGroupData;
import org.cyclos.model.users.groups.GroupSetVO;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.groups.UserGroupLogVO;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserGroupServiceImpl
extends BaseServiceImpl
implements UserGroupServiceLocal {
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private ConnectedUserServiceLocal connectedUserService;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private BasicUserServiceLocal basicUserService;
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private BrokeringServiceLocal brokeringService;
    @Autowired
    private EntityLogServiceLocal entityLogService;

    public Long changeGroup(ChangeGroupDTO changeGroupDTO) {
        Object object2;
        Group group;
        this.validate(this.resolveValidator(changeGroupDTO), changeGroupDTO, "changeGroup");
        User user = (User)this.conversionHandler.convert(User.class, (Object)changeGroupDTO.getUser());
        if (user == null || user.isRemoved()) {
            throw new IllegalActionException();
        }
        Group group2 = user.getGroup();
        if (group2.equals((Object)(group = (Group)this.conversionHandler.convert(Group.class, (Object)changeGroupDTO.getGroup()))) || group2.getNature() == BasicGroupNature.ADMIN_GROUP != (group2.getNature() == BasicGroupNature.ADMIN_GROUP) || !Objects.equals(group2.getNetwork(), group.getNetwork())) {
            throw new IllegalActionException();
        }
        if (group2 instanceof BrokerGroup && group instanceof MemberGroup) {
            for (Object object2 : user.getProducts()) {
                if (!(object2 instanceof BrokerProduct)) continue;
                throw new ValidationException(this.message(UsersKeys.Users.ERROR_MOVE_BROKER_TO_MEMBER_GROUP_WITH_INDIVIDUAL_PRODUCT, new Object[0]));
            }
        }
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)UserExtensionPointEvent.CHANGE_GROUP, new ExtensionPointFilter(group2)).attribute("user", (Object)user).attribute("operator", null).attribute("oldGroup", (Object)group2).attribute("newGroup", (Object)group).attribute("comments", (Object)changeGroupDTO.getComment());
        extensionPointAccessor.fireValidated();
        user.setGroup(group);
        this.accountService.adjustAccounts(user);
        this.basicUserService.reindex((BasicUser)user);
        this.connectedUserService.notifySessionsOfPermissionChange((ProductOwner)user);
        object2 = new Date();
        UserGroupLog userGroupLog = this.getLastLog(user);
        if (userGroupLog != null) {
            userGroupLog.setEndDate((Date)object2);
        }
        UserGroupLog userGroupLog2 = this.createGroupHistoryLog(user, (Date)object2, changeGroupDTO.getComment());
        extensionPointAccessor.fireSaved();
        if (group2 instanceof BrokerGroup && group instanceof MemberGroup) {
            Set set = user.getBrokeredUsers();
            for (User user2 : set) {
                this.brokeringService.removeBroker(user2, user);
            }
        }
        this.entityLogService.log((SimpleEntity)user, this.message(UsersKeys.Users.GROUP, new Object[0]), UserDTO.GROUP.getName(), this.getFormatter().format((INamedEntity)group2), this.getFormatter().format((INamedEntity)group), EntityActionLog.CHANGE_USER_GROUP);
        this.userSearchHandler.onGroupChange(user);
        return userGroupLog2.getId();
    }

    public UserGroupLog createInitialGroupHistoryLog(User user) {
        String string = this.message(UsersKeys.Users.INITIAL_LOG_DESCRIPTION, new Object[0]);
        return this.createGroupHistoryLog(user, user.getCreationDate(), string);
    }

    public boolean existsInGroupHistoryLog(Long l) {
        QUserGroupLog qUserGroupLog = QUserGroupLog.userGroupLog;
        return ((DBQuery)this.from(new EntityPath[]{qUserGroupLog}).where((Predicate)qUserGroupLog.group().id.eq((Object)l))).hasResults();
    }

    public ChangeGroupData getChangeGroupData(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        List<BasicGroupVO> list = this.getPossibleNewGroups(user);
        List<UserGroupLog> list2 = this.getUserGroupLogs(user);
        ChangeGroupData changeGroupData = new ChangeGroupData();
        changeGroupData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        changeGroupData.setStatus(user.getStatus());
        changeGroupData.setCurrentGroup((BasicGroupVO)this.conversionHandler.convert(GroupVO.class, (Object)user.getGroup()));
        changeGroupData.setGroupSets(this.groupsHandler.visibles().accessibles().groupSets().sorted());
        changeGroupData.setPossibleNewGroups(list);
        changeGroupData.setLogs(this.conversionHandler.convertList(UserGroupLogVO.class, list2));
        return changeGroupData;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QUserGroupLog.userGroupLog.user().network());
    }

    private UserGroupLog createGroupHistoryLog(User user, Date date, String string) {
        UserGroupLog userGroupLog = new UserGroupLog();
        userGroupLog.setComment(string);
        userGroupLog.setGroup(user.getGroup());
        userGroupLog.setStartDate(date);
        userGroupLog.setBy(this.getLoggedUser());
        userGroupLog.setUser(user);
        this.persist((IEntity)userGroupLog);
        return userGroupLog;
    }

    private List<BasicGroupVO> filterOutEmptyGroupVOSets(List<? extends BasicGroupVO> list) {
        if (CollectionHelper.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<BasicGroupVO> arrayList = new ArrayList<BasicGroupVO>(list.size());
        BasicGroupVO basicGroupVO = null;
        for (BasicGroupVO basicGroupVO2 : list) {
            if (!(basicGroupVO == null || basicGroupVO instanceof GroupSetVO && basicGroupVO2 instanceof GroupSetVO)) {
                arrayList.add(basicGroupVO);
            }
            basicGroupVO = basicGroupVO2;
        }
        if (basicGroupVO instanceof GroupVO) {
            arrayList.add(basicGroupVO);
        }
        return arrayList;
    }

    private UserGroupLog getLastLog(User user) {
        List<UserGroupLog> list = this.getUserGroupLogs(user);
        if (CollectionHelper.isEmpty(list)) {
            return null;
        }
        return (UserGroupLog)CollectionHelper.first(list);
    }

    private List<BasicGroupVO> getPossibleNewGroups(User user) {
        if (user.isRemoved() || user.isGlobalAdmin()) {
            return Collections.emptyList();
        }
        Group group = user.getGroup();
        boolean bl = group.getNature() == BasicGroupNature.ADMIN_GROUP;
        GroupListViewFactory groupListViewFactory = this.groupsHandler.visibles().accessibles();
        List list = bl ? groupListViewFactory.admins().sorted() : groupListViewFactory.basicUsers().sorted();
        list.removeIf(basicGroupVO -> basicGroupVO.getId().equals(group.getId()));
        return this.filterOutEmptyGroupVOSets(list);
    }

    private List<UserGroupLog> getUserGroupLogs(User user) {
        QUserGroupLog qUserGroupLog = QUserGroupLog.userGroupLog;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qUserGroupLog}).where((Predicate)qUserGroupLog.user().eq((Object)user))).orderBy(qUserGroupLog.startDate.desc())).list((Expression)qUserGroupLog);
    }

    private Validator resolveValidator(ChangeGroupDTO changeGroupDTO) {
        Validator validator = new Validator();
        validator.property((Property)ChangeGroupDTO.USER, UsersKeys.Users.USER).required();
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)ChangeGroupDTO.GROUP, UsersKeys.Groups.CHANGE_GROUP_NEW_GROUP).required();
        User user = (User)this.conversionHandler.convert(User.class, (Object)changeGroupDTO.getUser());
        if (user != null) {
            List<BasicGroupVO> list = this.getPossibleNewGroups(user);
            list.removeIf(GroupSetVO.class::isInstance);
            property.anyOf(list);
        }
        validator.property((Property)ChangeGroupDTO.COMMENT, UsersKeys.Groups.CHANGE_GROUP_COMMENT);
        if (user != null) {
            validator.general(object -> {
                Group group = user.getGroup();
                if (group instanceof AdminGroup) {
                    AdminGroup adminGroup = (AdminGroup)group;
                    if (adminGroup.getAdminType() == AdminGroupType.GLOBAL) {
                        return new ValidationError(UsersKeys.Groups.CHANGE_GROUP_VALIDATION_NO_GLOBAL_ADMIN);
                    }
                    if (adminGroup.getAdminType() == AdminGroupType.NETWORK) {
                        QUser qUser = QUser.user;
                        int n = ((DBQuery)this.from(new EntityPath[]{qUser}).where(new Predicate[]{qUser.group().eq((Object)group), qUser.status.notIn((Object[])new UserStatus[]{UserStatus.REMOVED, UserStatus.PURGED})})).count(qUser.id);
                        if (n == 1) {
                            return new ValidationError(UsersKeys.Groups.CHANGE_GROUP_VALIDATION_NO_LAST_ADMIN);
                        }
                    }
                }
                return null;
            });
        }
        return validator;
    }
}

