/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.BrokerProduct;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.GroupSet;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.ProductOwner;
import org.cyclos.entities.users.QUserProductLog;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.entities.users.UserProductLog;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.users.BaseProductsOwnerServiceImpl;
import org.cyclos.impl.users.BasicUserServiceLocal;
import org.cyclos.impl.users.ProductsUserServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.access.Role;
import org.cyclos.model.system.entitylogs.EntityActionLog;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.groups.GroupVO;
import org.cyclos.model.users.products.ProductAssignmentLogVO;
import org.cyclos.model.users.products.ProductLevel;
import org.cyclos.model.users.products.ProductLevelData;
import org.cyclos.model.users.products.ProductWithUserAccountVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserProductsCollections;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductsUserServiceImpl
extends BaseProductsOwnerServiceImpl<User, UserProductLog, UserLocatorVO, UserProductsCollections>
implements ProductsUserServiceLocal {
    private static String USER_INDIVIDUAL_PRODUCTS_PROPERTY_NAME = "individualProducts";
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private BasicUserServiceLocal basicUserService;
    @Autowired
    private EntityLogServiceLocal entityLogService;

    public ProductsUserServiceImpl() {
        super(User.class, UserProductLog.class);
    }

    @Override
    public UserProductsCollections getDataWithoutLogs(User user) {
        boolean bl = user.isAdmin();
        UserProductsCollections userProductsCollections = new UserProductsCollections();
        userProductsCollections.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        userProductsCollections.setGroup((GroupVO)this.conversionHandler.convert(GroupVO.class, (Object)user.getGroup()));
        Set set = bl ? Collections.emptySet() : user.getProducts();
        Group group = user.getGroup();
        GroupSet groupSet = group instanceof UserGroup ? ((UserGroup)group).getGroupSet() : null;
        Set set2 = group.getProducts();
        Set set3 = groupSet == null ? Collections.emptySet() : groupSet.getProducts();
        List list = bl ? Collections.emptyList() : this.getSessionData().getProducts().admin().getManageIndividualProducts();
        ArrayList<Product> arrayList = new ArrayList<Product>(list);
        arrayList.removeAll(set);
        if (!user.isBroker()) {
            arrayList.removeIf(product -> product instanceof BrokerProduct);
        }
        HashSet hashSet = new HashSet(list);
        hashSet.retainAll(set);
        userProductsCollections.setUnassignable(this.conversionHandler.convertSet(ProductWithUserAccountVO.class, hashSet));
        ProductLevelData productLevelData = new ProductLevelData();
        productLevelData.setLevel(ProductLevel.INDIVIDUAL);
        productLevelData.setThisLevelsProducts(CollectionHelper.sort((Collection)this.conversionHandler.convertList(ProductWithUserAccountVO.class, (Iterable)set)));
        userProductsCollections.setAssigned(productLevelData);
        userProductsCollections.setAvailable(this.conversionHandler.convertList(ProductWithUserAccountVO.class, arrayList));
        ProductLevelData productLevelData2 = new ProductLevelData();
        productLevelData2.setLevel(ProductLevel.GROUP);
        productLevelData2.setThisLevelsProducts(CollectionHelper.sort((Collection)this.conversionHandler.convertList(ProductWithUserAccountVO.class, (Iterable)set2)));
        productLevelData.setLevelUp(productLevelData2);
        ProductLevelData productLevelData3 = new ProductLevelData();
        productLevelData3.setLevel(ProductLevel.GROUP_SET);
        productLevelData3.setThisLevelsProducts(CollectionHelper.sort((Collection)this.conversionHandler.convertList(ProductWithUserAccountVO.class, (Iterable)set3)));
        productLevelData2.setLevelUp(productLevelData3);
        return userProductsCollections;
    }

    @Override
    protected void addEntityLogs(User user, Product product, boolean bl) {
        HashSet<Product> hashSet = new HashSet<Product>(user.getProducts());
        if (bl) {
            hashSet.remove(product);
        } else {
            hashSet.add(product);
        }
        this.entityLogService.log((SimpleEntity)user, this.message(UsersKeys.Users.PRODUCTS_INDIVIDUAL, new Object[0]), USER_INDIVIDUAL_PRODUCTS_PROPERTY_NAME, this.getFormatter().format(hashSet), this.getFormatter().format((Collection)user.getProducts()), EntityActionLog.INDIVIDUAL_PRODUCT_ASSIGNMENT);
    }

    @Override
    protected List<ProductAssignmentLogVO> getLogs(User user) {
        QUserProductLog qUserProductLog = QUserProductLog.userProductLog;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qUserProductLog}).where((Predicate)qUserProductLog.user().eq((Object)user))).orderBy(qUserProductLog.date.desc())).list(ProductAssignmentLogVO.class, (Expression)qUserProductLog);
    }

    @Override
    protected boolean isCanAssign(User user) {
        UserStatus userStatus = user.getStatus();
        return userStatus == UserStatus.ACTIVE || userStatus == UserStatus.DISABLED || userStatus == UserStatus.BLOCKED;
    }

    @Override
    protected void onProductAssigned(User user, Product product) {
        this.onProductChanged(user, product);
    }

    @Override
    protected void onProductUnassigned(User user, Product product) {
        this.onProductChanged(user, product);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    @Override
    protected void validateAssign(User user, Product product) {
        if (!this.isCanAssign(user)) {
            throw new IllegalArgumentException("Invalid product assignment");
        }
        this.validate((ProductOwner)user);
        this.validate(product);
        User user2 = user;
        EnumSet<Role> enumSet = EnumSet.noneOf(Role.class);
        if (user2.isBroker()) {
            enumSet.add(Role.MEMBER);
            enumSet.add(Role.BROKER);
        } else if (user2.isMember()) {
            enumSet.add(Role.MEMBER);
        }
        if (!enumSet.contains(product.getRole())) {
            throw new IllegalActionException();
        }
        Set set = user2.getProducts();
        if (set.contains(product)) {
            throw new IllegalActionException();
        }
    }

    @Override
    protected void validateUnAssign(User user, Product product) {
        this.validate((ProductOwner)user);
        this.validate(product);
    }

    private void adjustAccountsIfNeeded(User user, Product product) {
        MemberProduct memberProduct;
        if (product instanceof MemberProduct && (memberProduct = (MemberProduct)product).getUserAccount() != null) {
            this.accountService.adjustAccounts(user);
        }
    }

    private void onProductChanged(User user, Product product) {
        this.basicUserService.reindex((BasicUser)user);
        this.adjustAccountsIfNeeded(user, product);
    }

    private void validate(Product product) {
        List list = this.getSessionData().getProducts().admin().getManageIndividualProducts();
        if (!list.contains(product)) {
            throw new EntityNotFoundException();
        }
    }

    private void validate(ProductOwner productOwner) {
        User user = (User)productOwner;
        if (user.isAdmin()) {
            throw new EntityNotFoundException();
        }
    }
}

