/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.QOperator;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.validation.EntityPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.Property;
import org.cyclos.model.system.entitylogs.EntityLogEvent;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.EntityPropertyLogQuery;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.operators.OperatorDTO;
import org.cyclos.model.users.operators.OperatorRegistrationDTO;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.model.users.users.ProfileFieldAction;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class OperatorEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<Operator, OperatorDTO> {
    @Autowired
    @Lazy
    private CustomFieldValueHandler customFieldValueHandler;

    @Override
    public boolean canViewEntityLog(long l) {
        return this.getEntityToViewLog(l) != null;
    }

    @Override
    public Pair<Boolean, Set<EntityLogType>> doApplyLogFilters(DBQuery<?> dBQuery, long l, EntityPropertyLogQuery entityPropertyLogQuery) {
        Operator operator = this.find(Operator.class, l);
        EnumSet<EntityLogType> enumSet = EnumSet.of(EntityLogType.PHONE);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        List list = this.profileFieldHandler.getFieldsByAction((BasicUser)operator, ProfileFieldAction.VIEW);
        HashSet<BasicProfileField> hashSet = new HashSet<BasicProfileField>(Arrays.asList(BasicProfileField.values()));
        for (ProfileField profileField : list) {
            if (profileField instanceof BasicProfileField) {
                hashSet.remove(profileField);
                continue;
            }
            arrayList.add(((BaseEntity)profileField).getId());
        }
        block6: for (BasicProfileField basicProfileField2 : BasicProfileField.values()) {
            switch (basicProfileField2) {
                case PHONE: {
                    if (hashSet.contains(basicProfileField2)) {
                        enumSet.remove(EntityLogType.PHONE);
                    }
                    hashSet.remove(basicProfileField2);
                    continue block6;
                }
                case EMAIL: 
                case FULL_NAME: 
                case LOGIN_NAME: {
                    continue block6;
                }
                case ADDRESS: 
                case ACCOUNT_NUMBER: 
                case IMAGE: {
                    hashSet.remove(basicProfileField2);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown basic profile field: " + String.valueOf(basicProfileField2));
                }
            }
        }
        dBQuery.where((Predicate)OperatorEntityLogHandlerImpl.el.type.ne((Object)EntityLogType.OPERATOR).or((Predicate)OperatorEntityLogHandlerImpl.$.customFieldId.isNull()).or((Predicate)OperatorEntityLogHandlerImpl.$.customFieldId.in(arrayList)));
        if (CollectionHelper.isNotEmpty(hashSet)) {
            dBQuery.where((Predicate)OperatorEntityLogHandlerImpl.el.type.ne((Object)EntityLogType.OPERATOR).or((Predicate)OperatorEntityLogHandlerImpl.$.propertyName.notIn(CollectionUtils.collect(hashSet, basicProfileField -> basicProfileField.property().getName()))).or((Predicate)OperatorEntityLogHandlerImpl.$.propertyName.isNull()));
        }
        return new Pair((Object)true, enumSet);
    }

    public Class<Operator> getEntityClass() {
        return Operator.class;
    }

    @Override
    public String getEntityLogName(Operator operator, Operator operator2, EntityLogEvent entityLogEvent) {
        return this.getFormatter().format((BasicUser)ObjectHelper.defaultValue((Object)operator2, (Object)operator));
    }

    @Override
    public BasicUser getRelatedUser(Operator operator) {
        return operator;
    }

    public EntityLogType getType() {
        return EntityLogType.OPERATOR;
    }

    @Override
    public boolean isAsManager(Operator operator) {
        return !operator.getUser().equals((Object)this.getLoggedUser());
    }

    public EntityLogDescriptor<? extends OperatorDTO> resolveLogDescriptor(Operator operator) {
        Class<? extends OperatorDTO> clazz = this.resolveDTOType(operator);
        List list = this.profileFieldHandler.getEnabledProfileFields((BasicUser)operator);
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(clazz).propertyOrIgnore(OperatorDTO.NAME, UsersKeys.Users.NAME, list.contains(BasicProfileField.FULL_NAME)).propertyOrIgnore((Property)OperatorDTO.USERNAME, UsersKeys.Users.USERNAME, list.contains(BasicProfileField.LOGIN_NAME)).propertyOrIgnore((Property)OperatorDTO.EMAIL, UsersKeys.Users.EMAIL, list.contains(BasicProfileField.EMAIL)).property((PropertyAccess)new EntityPropertyAccess((Path)QOperator.operator.group()), UsersKeys.Operators.OPERATOR_GROUP).ignore((Property)OperatorDTO.CUSTOM_VALUES).ignore((Property)OperatorDTO.USER);
        if (OperatorRegistrationDTO.class.isAssignableFrom(clazz)) {
            entityLogDescriptor.cast().ignore((Property)OperatorRegistrationDTO.LAND_LINE_PHONES).ignore((Property)OperatorRegistrationDTO.MOBILE_PHONES).ignore((Property)OperatorRegistrationDTO.SKIP_ACTIVATION_EMAIL).ignore((Property)OperatorRegistrationDTO.PASSWORDS);
        }
        List list2 = this.profileFieldHandler.getCustomFields((Collection)list);
        entityLogDescriptor.customFields((Iterable)list2, this.customFieldValueHandler);
        return entityLogDescriptor;
    }

    @Override
    protected Operator getEntityToViewLog(long l) {
        Operator operator = this.find(Operator.class, l);
        return operator == null || operator.equals((Object)this.getLoggedBasicUser()) ? null : operator;
    }

    private Class<? extends OperatorDTO> resolveDTOType(Operator operator) {
        return operator.isTransient() ? OperatorRegistrationDTO.class : OperatorDTO.class;
    }
}

