/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.users;

import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.NumberPath;
import java.util.Collection;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.QBasePayment;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.QTransactionAuthorization;
import org.cyclos.entities.banking.QUserAccount;
import org.cyclos.entities.users.QTransactionFeedback;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.utils.queryextensions.DateQueryExtensions;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.utils.TransactionLevel;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTransactionFeedbackRecurringTask
extends EntityBatchRecurringTask<BasePayment> {
    protected final NumberPath<Integer> days;
    protected final BooleanPath alreadyNotifiedPath;
    protected final boolean useIgnoreListAndPermission;
    @Autowired
    private ProductServiceLocal productService;

    public AbstractTransactionFeedbackRecurringTask(NumberPath<Integer> numberPath, BooleanPath booleanPath, boolean bl) {
        super(BasePayment.class);
        this.days = numberPath;
        this.alreadyNotifiedPath = booleanPath;
        this.useIgnoreListAndPermission = bl;
    }

    @Override
    protected final Collection<Long> nextIds() throws Throwable {
        QBasePayment qBasePayment = QBasePayment.basePayment;
        QUserAccount qUserAccount = new QUserAccount("fa");
        QUser qUser = new QUser("fu");
        QUserAccount qUserAccount2 = new QUserAccount("ta");
        QUser qUser2 = new QUser("tu");
        QPaymentTransferType qPaymentTransferType = QPaymentTransferType.paymentTransferType;
        QTransactionAuthorization qTransactionAuthorization = QTransactionAuthorization.transactionAuthorization;
        QTransactionFeedback qTransactionFeedback = QTransactionFeedback.transactionFeedback;
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qBasePayment}).join((EntityPath)qBasePayment.from(), (Path)qUserAccount._super)).join((EntityPath)qUserAccount.user(), (Path)qUser)).join((EntityPath)qBasePayment.to(), (Path)qUserAccount2._super)).join((EntityPath)qUserAccount2.user(), (Path)qUser2)).join((EntityPath)qBasePayment.type(), (Path)qPaymentTransferType._super)).where(new Predicate[]{this.alreadyNotifiedPath.isFalse(), qPaymentTransferType.requiresFeedback.isTrue(), ((DBQuery)this.subQuery(new EntityPath[]{qTransactionFeedback}).where((Predicate)qTransactionFeedback.transaction().eq((Expression)qBasePayment))).notExists(), qBasePayment.authorizationStatus.eq((Object)TransactionAuthorizationStatus.NA).and((Predicate)qBasePayment.date.addDays(this.days).loe((Expression)DateTimeExpression.currentTimestamp())).or((Predicate)qBasePayment.authorizationStatus.eq((Object)TransactionAuthorizationStatus.AUTHORIZED).and((Predicate)DateQueryExtensions.addDays((Expression)((Expression)this.subQuery(new EntityPath[]{qTransactionAuthorization}).select((Expression)qTransactionAuthorization.date.max()).where((Predicate)qTransactionAuthorization.transaction().eq((Expression)qBasePayment._super))), this.days).loe((Expression)DateTimeExpression.currentTimestamp()))), this.productService.permissionQuery(new Permission[]{Permission.MY_TRANSACTION_FEEDBACKS_RECEIVE}).apply(qUser2)});
        if (this.useIgnoreListAndPermission) {
            QUser qUser3 = QUser.user;
            dBQuery.where(new Predicate[]{((DBQuery)this.subQuery(new EntityPath[]{qUser3}).where((Predicate)qUser3.in((CollectionExpression)qUser.ignoreFeedback).and((Predicate)qUser3.eq((Expression)qUser2)))).notExists(), this.productService.permissionQuery(new Permission[]{Permission.MY_TRANSACTION_FEEDBACKS_GIVE}).apply(qUser)});
        }
        return ((DBQuery)dBQuery.limit(200L)).list((Expression)qBasePayment.id);
    }

    @Override
    protected boolean shouldRun() {
        QPaymentTransferType qPaymentTransferType = QPaymentTransferType.paymentTransferType;
        return (Boolean)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_ONLY, transactionStatus -> ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qPaymentTransferType}).where((Predicate)qPaymentTransferType.requiresFeedback.isTrue())).hasResults());
    }
}

