/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QServiceInterceptor;
import org.cyclos.entities.system.ServiceInterceptor;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ServiceInterceptorServiceLocal;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.interceptors.ServiceInterceptorDTO;
import org.cyclos.model.system.interceptors.ServiceInterceptorData;
import org.cyclos.model.system.interceptors.ServiceInterceptorVO;
import org.cyclos.model.system.interceptors.ServiceWithOperationsVO;
import org.cyclos.model.system.networks.NetworkVO;
import org.cyclos.model.system.scripts.CustomScriptVO;
import org.cyclos.model.system.scripts.ScriptType;
import org.cyclos.server.utils.ServiceMetadata;
import org.cyclos.server.utils.ServiceMetadataHelper;
import org.cyclos.services.Service;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;

@org.springframework.stereotype.Service
public class ServiceInterceptorServiceImpl
extends CRUDServiceImpl<ServiceInterceptor, QServiceInterceptor, ServiceInterceptorDTO, ServiceInterceptorData, Void>
implements ServiceInterceptorServiceLocal {
    private static final Property<?, ?>[] EXCLUDED_PROPERTIES = new Property[]{ServiceInterceptorDTO.SERVICES, ServiceInterceptorDTO.OPERATIONS};
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private CacheHandler cacheHandler;
    private Map<String, ServiceWithOperationsVO> servicesWithOperations;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public ServiceInterceptorServiceImpl() {
        super(ServiceInterceptor.class, QServiceInterceptor.serviceInterceptor, ServiceInterceptorDTO.class);
    }

    public void disableAllInterceptorsInNetwork(NetworkVO networkVO) throws FrameworkException {
        Network network = (Network)this.conversionHandler.convert(Network.class, (Object)networkVO);
        this.rawEntityManagerHandler.update(this.$).set((Path)((QServiceInterceptor)this.$).enabled, (Object)false).where(new Predicate[]{((QServiceInterceptor)this.$).network().eq((Object)network)}).execute();
        this.evictCache(network);
    }

    public boolean hasEnabledInterceptors(Network network) {
        return ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where(new Predicate[]{((QServiceInterceptor)this.$).network().eq((Object)network), ((QServiceInterceptor)this.$).enabled.isTrue()})).hasResults();
    }

    @PostConstruct
    public void initialize() {
        this.servicesWithOperations = ServiceMetadataHelper.get().stream().map(this::toServiceWithOperationsVO).collect(TreeMap::new, (treeMap, serviceWithOperationsVO) -> treeMap.put(serviceWithOperationsVO.getName(), serviceWithOperationsVO), TreeMap::putAll);
    }

    public List<ServiceInterceptorVO> list() throws FrameworkException {
        return ((DBQuery)this.from().orderBy(((QServiceInterceptor)this.$).order.asc())).list(ServiceInterceptorVO.class, (Expression)this.$);
    }

    public List<ServiceWithOperationsVO> listServices() {
        return new ArrayList<ServiceWithOperationsVO>(this.servicesWithOperations.values());
    }

    @Override
    public ServiceInterceptor newEntity(Void void_) {
        ServiceInterceptor serviceInterceptor = new ServiceInterceptor();
        serviceInterceptor.setEnabled(true);
        return serviceInterceptor;
    }

    public List<ServiceInterceptor> resolveInterceptors(Network network, Class<? extends Service> clazz, Method method) {
        List list = ((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where(new Predicate[]{((QServiceInterceptor)this.$).network().eq((Object)network), ((QServiceInterceptor)this.$).enabled.isTrue()})).orderBy(((QServiceInterceptor)this.$).order.asc())).list((Expression)this.$);
        String string = "\n" + clazz.getSimpleName() + "\n";
        String string2 = "\n" + clazz.getSimpleName() + "." + method.getName() + "\n";
        list.removeIf(serviceInterceptor -> !serviceInterceptor.isAllServices() && !serviceInterceptor.getServices().contains(string) || !serviceInterceptor.isAllOperations() && !serviceInterceptor.getOperations().contains(string2));
        return list;
    }

    @Override
    public void saveOrder(List<Long> list) {
        super.saveOrder(list);
        Set<Network> set = this.findAll(list).stream().map(ServiceInterceptor::getNetwork).collect(Collectors.toSet());
        set.forEach(this::evictCache);
    }

    @Override
    public ServiceInterceptorDTO toDTO(ServiceInterceptor serviceInterceptor) {
        ServiceInterceptorDTO serviceInterceptorDTO = (ServiceInterceptorDTO)super.toDTO(serviceInterceptor);
        serviceInterceptorDTO.setServices(new LinkedHashSet(StringHelper.splitTrimming((String)serviceInterceptor.getServices(), (String)"\n")));
        serviceInterceptorDTO.setOperations(new LinkedHashSet(StringHelper.splitTrimming((String)serviceInterceptor.getOperations(), (String)"\n")));
        return serviceInterceptorDTO;
    }

    @Override
    public ServiceInterceptor toEntity(ServiceInterceptorDTO serviceInterceptorDTO) {
        ServiceInterceptor serviceInterceptor = (ServiceInterceptor)super.toEntity(serviceInterceptorDTO);
        serviceInterceptor.setServices(StringHelper.joinTrimming((Collection)serviceInterceptorDTO.getServices(), (String)"\n"));
        serviceInterceptor.setOperations(StringHelper.joinTrimming((Collection)serviceInterceptorDTO.getOperations(), (String)"\n"));
        return serviceInterceptor;
    }

    @Override
    protected ServiceInterceptorData getData(ServiceInterceptor serviceInterceptor) {
        ServiceInterceptorData serviceInterceptorData = new ServiceInterceptorData();
        serviceInterceptorData.setDto((EntityDTO)this.toDTO(serviceInterceptor));
        serviceInterceptorData.setScripts(this.conversionHandler.convertList(CustomScriptVO.class, (Iterable)this.customScriptService.listByType(ScriptType.SERVICE_INTERCEPTOR)));
        serviceInterceptorData.setServices(this.listServices());
        return serviceInterceptorData;
    }

    @Override
    protected Object[] getExcludedPropertiesToDTO(ServiceInterceptor serviceInterceptor) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(ServiceInterceptorDTO serviceInterceptorDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onAfterSave(ServiceInterceptor serviceInterceptor, ServiceInterceptor serviceInterceptor2, Object object) {
        this.evictCache(serviceInterceptor.getNetwork());
    }

    @Override
    protected void onBeforeRemove(ServiceInterceptor serviceInterceptor) {
        this.evictCache(serviceInterceptor.getNetwork());
    }

    @Override
    protected Object onBeforeSave(ServiceInterceptor serviceInterceptor, ServiceInterceptor serviceInterceptor2) {
        if (serviceInterceptor2 == null) {
            int n = (Integer)ObjectHelper.defaultValue((Object)((Integer)this.from().singleResult((Expression)((QServiceInterceptor)this.$).order.max())), (Object)0);
            serviceInterceptor.setOrder(Integer.valueOf(n + 1));
        }
        if (!serviceInterceptor.isAllServices()) {
            serviceInterceptor.setServices("\n" + serviceInterceptor.getServices() + "\n");
        }
        if (!serviceInterceptor.isAllOperations()) {
            serviceInterceptor.setOperations("\n" + serviceInterceptor.getOperations() + "\n");
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QServiceInterceptor)this.$).network());
    }

    @Override
    protected Validator resolveValidator(ServiceInterceptorDTO serviceInterceptorDTO) {
        Validator validator = new Validator();
        validator.property((Property)ServiceInterceptorDTO.SCRIPT, SystemKeys.Interceptors.SCRIPT).required().entity(CustomScript.class, (EntityValidation)new BaseEntityValidation<CustomScript>(){

            protected boolean isValid(Object object, Object object2, CustomScript customScript) {
                return customScript.getType() == ScriptType.SERVICE_INTERCEPTOR;
            }
        });
        if (CollectionHelper.isNotEmpty((Iterable)serviceInterceptorDTO.getServices())) {
            validator.property((Property)ServiceInterceptorDTO.SERVICES, SystemKeys.Interceptors.SERVICES).anyOf(this.servicesWithOperations.keySet());
        }
        if (CollectionHelper.isNotEmpty((Iterable)serviceInterceptorDTO.getOperations())) {
            Set<String> set = serviceInterceptorDTO.getServices();
            if (CollectionHelper.isEmpty((Iterable)set)) {
                set = this.servicesWithOperations.keySet();
            }
            List list = set.stream().map(this.servicesWithOperations::get).flatMap(serviceWithOperationsVO -> serviceWithOperationsVO.getOperations().stream().map(string -> serviceWithOperationsVO.getName() + "." + string)).collect(Collectors.toList());
            validator.property((Property)ServiceInterceptorDTO.OPERATIONS, SystemKeys.Interceptors.OPERATIONS).anyOf(list);
        }
        return validator;
    }

    private void evictCache(Network network) {
        Long l = SimpleEntity.id((SimpleEntity)network);
        this.cacheHandler.schedulePartialEvict(CacheType.SERVICE_INTERCEPTORS, (SerializablePredicate & Serializable)serviceInterceptorCacheKey -> serviceInterceptorCacheKey.matchesNetwork(l));
    }

    private ServiceWithOperationsVO toServiceWithOperationsVO(ServiceMetadata serviceMetadata) {
        ServiceWithOperationsVO serviceWithOperationsVO = new ServiceWithOperationsVO();
        serviceWithOperationsVO.setName(serviceMetadata.getServiceInterface().getSimpleName());
        serviceWithOperationsVO.setOperations(serviceMetadata.getOperations());
        return serviceWithOperationsVO;
    }
}

