/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomFieldPossibleValue;
import org.cyclos.entities.system.CustomFieldPossibleValueCategory;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.system.CustomWizardField;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.users.BaseContactInfo;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Contact;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.Record;
import org.cyclos.entities.users.RecordType;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserGroup;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.VoucherCustomFieldServiceLocal;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.system.CustomWizardFieldServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.system.ScriptHelper;
import org.cyclos.impl.users.ContactCustomFieldServiceLocal;
import org.cyclos.impl.users.ContactInfoFieldServiceLocal;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.RecordFieldHandler;
import org.cyclos.impl.utils.ConvertingBeanMap;
import org.cyclos.impl.utils.EntityWithCustomValuesMap;
import org.cyclos.impl.utils.ModelWithCustomValuesMap;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.vouchers.CreateVouchersDTO;
import org.cyclos.model.banking.vouchers.TopUpVoucherDTO;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.wizards.CustomWizardTransitionParams;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.users.contactinfos.AddressContactInfoDTO;
import org.cyclos.model.users.contactinfos.ContactInfoDTO;
import org.cyclos.model.users.contacts.ContactDTO;
import org.cyclos.model.users.operators.OperatorDTO;
import org.cyclos.model.users.operators.OperatorRegistrationDTO;
import org.cyclos.model.users.records.RecordDTO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserDTO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class ScriptHelperImpl
extends BaseNetworkedHandlerImpl
implements ScriptHelper {
    private Map<Class<?>, Function<Object, Stream<CustomField<?, ?, ?>>>> fieldsResolvers;
    private Map<String, Object> beans;
    private ConcurrentMap<String, Object> globals = new ConcurrentHashMap<String, Object>();
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    private VoucherCustomFieldServiceLocal voucherCustomFieldService;
    @Autowired
    private CustomWizardServiceLocal customWizardService;
    @Autowired
    private CustomWizardFieldServiceLocal customWizardFieldService;
    @Autowired
    private VoucherServiceLocal voucherService;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private ContactCustomFieldServiceLocal contactCustomFieldService;
    @Autowired
    private ContactInfoFieldServiceLocal contactInfoFieldService;
    @Autowired
    private RecordFieldHandler recordFieldHandler;
    @Autowired
    private BeanHandler beanHandler;

    public ScriptHelperImpl() {
        this.registerModelResolvers();
    }

    public void addOnAfterEnd(Consumer<Boolean> consumer) {
        InvocationContext.ensure().addTransactionEndListener(false, consumer);
    }

    public void addOnAfterEndTransactional(Consumer<Boolean> consumer) {
        InvocationContext.ensure().addTransactionEndListener(true, consumer);
    }

    public void addOnBeforeEnd(Runnable runnable) {
        InvocationContext.ensure().addBeforeEndListener(runnable);
    }

    public void addOnCommit(Runnable runnable) {
        InvocationContext.ensure().addCommitListener(false, runnable);
    }

    public void addOnCommitTransactional(Runnable runnable) {
        InvocationContext.ensure().addCommitListener(true, runnable);
    }

    public void addOnRollback(Runnable runnable) {
        InvocationContext.ensure().addRollbackListener(false, runnable);
    }

    public void addOnRollbackTransactional(Runnable runnable) {
        InvocationContext.ensure().addRollbackListener(true, runnable);
    }

    public <T> T bean(Class<T> clazz) {
        return (T)this.getApplicationContext().getBean(clazz);
    }

    public Object bean(String string) {
        Object object = this.beans.get(string);
        if (object == null) {
            throw new NoSuchBeanDefinitionException(string);
        }
        return object;
    }

    @PreDestroy
    public void destroy() {
        this.globals.values().forEach(arg_0 -> ((BeanHandler)this.beanHandler).destroy(arg_0));
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return super.getApplicationContext();
    }

    public Map<String, Object> getBeanMap() {
        return this.beans;
    }

    public ConcurrentMap<String, Object> getGlobals() {
        return this.globals;
    }

    @PostConstruct
    public void initialize() {
        RestTemplate restTemplate;
        ApplicationContext applicationContext = this.getApplicationContext();
        this.beans = new HashMap<String, Object>();
        for (String string : restTemplate = applicationContext.getBeanDefinitionNames()) {
            if (!string.endsWith("ServiceImpl") && !string.endsWith("HandlerImpl") && !string.endsWith("ServiceSecurity") && !string.endsWith("Handler") && !string.endsWith("HandlerFactoryBean")) continue;
            String string2 = StringHelper.removeEnd((String)StringHelper.removeEnd((String)string, (String)"Impl"), (String)"FactoryBean");
            int n = string2.lastIndexOf(46);
            if (n >= 0) {
                string2 = string2.substring(n + 1);
            }
            string2 = StringUtils.uncapitalize((String)string2);
            this.beans.put(string2, applicationContext.getBean(string));
        }
        RestTemplate restTemplate2 = (RestTemplate)applicationContext.getBean(RestTemplate.class);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = (NamedParameterJdbcTemplate)applicationContext.getBean(NamedParameterJdbcTemplate.class);
        JdbcTemplate jdbcTemplate = (JdbcTemplate)applicationContext.getBean(JdbcTemplate.class);
        this.beans.put("globals", this.globals);
        this.beans.put("cyclosProperties", applicationContext.getBean(CyclosProperties.class));
        this.beans.put("jdbc", jdbcTemplate);
        this.beans.put("jdbcTemplate", jdbcTemplate);
        this.beans.put("namedJdbc", namedParameterJdbcTemplate);
        this.beans.put("namedParameterJdbcTemplate", namedParameterJdbcTemplate);
        this.beans.put("rest", restTemplate2);
        this.beans.put("restTemplate", restTemplate2);
        this.beans.put("objectMapper", ((JacksonConfiguration)applicationContext.getBean(JacksonConfiguration.class)).getObjectMapper());
        this.beans = Collections.unmodifiableMap(this.beans);
    }

    public Long maskId(Object object) {
        return this.applicationHandler.getIdMask().apply(object);
    }

    @Override
    public <T> long processBatch(Iterable<T> iterable, Consumer<T> consumer) {
        return super.processBatch(iterable, consumer);
    }

    @Override
    public <T> long processBatch(Iterator<T> iterator, Consumer<T> consumer) {
        return super.processBatch(iterator, consumer);
    }

    public Long unmaskId(Object object) {
        return this.applicationHandler.getIdMask().remove(object);
    }

    public Map<String, Object> wrap(Object object) {
        return this.wrap(object, null);
    }

    public Map<String, Object> wrap(Object object, Collection<? extends CustomField<?, ?, ?>> collection) {
        Map map;
        if (object == null) {
            map = Collections.emptyMap();
        } else if (object instanceof EntityWithCustomValues) {
            EntityWithCustomValues entityWithCustomValues = (EntityWithCustomValues)object;
            map = new EntityWithCustomValuesMap(entityWithCustomValues, collection == null ? this.resolveCustomFields(entityWithCustomValues) : collection, this.conversionHandler, this.entityManagerHandler, this.customFieldValueHandler);
        } else if (object instanceof ModelWithCustomValues) {
            ModelWithCustomValues modelWithCustomValues = (ModelWithCustomValues)object;
            map = new ModelWithCustomValuesMap(modelWithCustomValues, collection == null ? this.resolveCustomFields(modelWithCustomValues) : collection, this.conversionHandler, this.entityManagerHandler, this.customFieldValueHandler);
        } else {
            map = object instanceof Map ? (Map)object : new ConvertingBeanMap(object, this.conversionHandler);
        }
        return map;
    }

    private <E extends EntityWithCustomValues<CF, C, PV, ?>, CF extends CustomField<CF, C, PV>, C extends CustomFieldPossibleValueCategory<CF, C, PV>, PV extends CustomFieldPossibleValue<CF, C, PV>> void registerEntityFieldsResolver(Class<E> clazz, Function<E, Stream<CF>> function) {
        this.fieldsResolvers.put(clazz, function);
    }

    private <M extends ModelWithCustomValues<?>, CF extends CustomField<?, ?, ?>> void registerModelFieldsResolver(Class<M> clazz, Function<M, Stream<CF>> function) {
        this.fieldsResolvers.put(clazz, function);
    }

    private void registerModelResolvers() {
        this.fieldsResolvers = new HashMap();
        this.registerModelFieldsResolver(OperatorDTO.class, operatorDTO -> {
            List list;
            Operator operator;
            if (operatorDTO.isPersistent()) {
                operator = this.find(Operator.class, operatorDTO.getId());
            } else {
                operator = new Operator((User)this.conversionHandler.convert(User.class, (Object)operatorDTO.getUser()));
                if (operatorDTO instanceof OperatorRegistrationDTO) {
                    list = (OperatorGroup)this.conversionHandler.convert(OperatorGroup.class, (Object)((OperatorRegistrationDTO)operatorDTO).getGroup());
                    operator.setGroup((OperatorGroup)list);
                }
            }
            list = this.profileFieldHandler.getEnabledProfileFields((BasicUser)operator);
            return CollectionHelper.filterByType(list.stream(), UserCustomField.class);
        });
        this.registerModelFieldsResolver(UserDTO.class, userDTO -> {
            Object object;
            User user;
            if (userDTO.isPersistent()) {
                user = this.find(User.class, userDTO.getId());
            } else {
                object = (UserGroup)this.conversionHandler.convert(UserGroup.class, (Object)userDTO.getGroup());
                user = new User((Group)object);
            }
            object = this.profileFieldHandler.getEnabledProfileFields((BasicUser)user);
            return CollectionHelper.filterByType(object.stream(), UserCustomField.class);
        });
        this.registerModelFieldsResolver(ContactDTO.class, contactDTO -> {
            User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)contactDTO.getOwner());
            return this.contactCustomFieldService.listEnabled(user).stream();
        });
        this.registerModelFieldsResolver(ContactInfoDTO.class, contactInfoDTO -> {
            User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)contactInfoDTO.getUser());
            return this.contactInfoFieldService.listEnabled(user).stream();
        });
        this.registerModelFieldsResolver(AddressContactInfoDTO.class, addressContactInfoDTO -> this.contactInfoFieldService.listAll().stream());
        this.registerModelFieldsResolver(RecordDTO.class, recordDTO -> {
            RecordType recordType = (RecordType)this.conversionHandler.convert(RecordType.class, (Object)recordDTO.getType());
            return this.recordFieldHandler.getAllFields(recordType).stream();
        });
        this.registerModelFieldsResolver(BasicAdDTO.class, basicAdDTO -> {
            User user = (User)this.conversionHandler.convert(User.class, (Object)basicAdDTO.getOwner());
            if (user == null) {
                return this.adCustomFieldService.listAll().stream();
            }
            return this.adCustomFieldService.listEnabled(user).stream();
        });
        this.registerModelFieldsResolver(PerformTransactionDTO.class, performTransactionDTO -> {
            if (performTransactionDTO.getType() != null) {
                PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performTransactionDTO.getType());
                return this.transactionCustomFieldService.listRelated((TransferType)paymentTransferType).stream();
            }
            return this.transactionCustomFieldService.listAll().stream();
        });
        this.registerModelFieldsResolver(CreateVouchersDTO.class, createVouchersDTO -> this.voucherCustomFieldService.listRelated((VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)createVouchersDTO.getType()), null).stream());
        this.registerModelFieldsResolver(TopUpVoucherDTO.class, topUpVoucherDTO -> {
            Voucher voucher = (Voucher)this.conversionHandler.convert(Voucher.class, (Object)this.voucherService.loadByToken(topUpVoucherDTO.getToken()));
            return this.voucherCustomFieldService.listRelated(voucher.getType(), null).stream();
        });
        this.registerModelFieldsResolver(CustomWizardTransitionParams.class, customWizardTransitionParams -> {
            CustomWizard customWizard = this.customWizardService.findExecution(customWizardTransitionParams.getKey()).getWizard();
            List list = this.customWizardFieldService.list(new CustomWizardVO(customWizard.getId()));
            return this.conversionHandler.convertList(CustomWizardField.class, (Iterable)list).stream();
        });
        this.registerEntityFieldsResolver(BasicUser.class, basicUser -> {
            List list = this.profileFieldHandler.getEnabledProfileFields(basicUser);
            return CollectionHelper.filterByType(list.stream(), UserCustomField.class);
        });
        this.registerEntityFieldsResolver(Contact.class, contact -> this.contactCustomFieldService.listEnabled(contact.getOwner()).stream());
        this.registerEntityFieldsResolver(BaseContactInfo.class, baseContactInfo -> this.contactInfoFieldService.listEnabled(baseContactInfo.getUser()).stream());
        this.registerEntityFieldsResolver(Record.class, record -> this.recordFieldHandler.getAllFields(record.getType()).stream());
        this.registerEntityFieldsResolver(BasicAd.class, basicAd -> (basicAd.getOwner() == null ? this.adCustomFieldService.listAll() : this.adCustomFieldService.listEnabled(basicAd.getOwner())).stream());
        this.registerEntityFieldsResolver(Transaction.class, transaction -> this.transactionCustomFieldService.listRelated(transaction.getType()).stream());
        this.registerEntityFieldsResolver(Voucher.class, voucher -> this.voucherCustomFieldService.listRelated(voucher.getType(), null).stream());
        this.registerEntityFieldsResolver(VoucherPack.class, voucherPack -> this.voucherCustomFieldService.listRelated(voucherPack.getType(), null).stream());
    }

    private Collection<? extends CustomField<?, ?, ?>> resolveCustomFields(Object object) {
        Class<?> clazz = object.getClass();
        Function<Object, Stream<CustomField<?, ?, ?>>> function = null;
        for (Class<?> clazz2 = clazz; clazz2 != null && (function = this.fieldsResolvers.get(clazz2)) == null; clazz2 = clazz2.getSuperclass()) {
        }
        if (function == null) {
            throw new IllegalStateException("No field resolver for " + String.valueOf(clazz));
        }
        return ((Stream)function.apply(object)).collect(Collectors.toSet());
    }
}

