/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.mysema.commons.lang.CloseableIterator;
import org.cyclos.impl.system.CustomRecurringTaskServiceLocal;
import org.cyclos.impl.system.RunScheduledBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskFirstExecution;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RunScheduledRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private CustomRecurringTaskServiceLocal customRecurringTaskService;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;

    @Override
    public RecurringTaskFirstExecution getFirstExecution() {
        return RecurringTaskFirstExecution.NOW;
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.RUN_CUSTOM;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_MINUTE;
    }

    @Override
    protected long execute() throws Throwable {
        try (CloseableIterator closeableIterator = this.customRecurringTaskService.iterateForRunningNow();){
            long l = this.processBatch(closeableIterator, (T customRecurringTask) -> this.backgroundTaskHandler.schedule(RunScheduledBackgroundTask.scheduling(customRecurringTask)));
            return l;
        }
    }
}

