/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.persistence.EntityManagerHandler;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InlineScriptBackgroundTask
extends AbstractBackgroundTask {
    private static final String LIBS_START = "/*!!! ";
    private static final String LIBS_END = " !!!*/ ";
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private EntityManagerHandler entityManagerHandler;

    public static BackgroundTaskScheduling scheduling(String string) {
        return InlineScriptBackgroundTask.scheduling(string, null);
    }

    public static BackgroundTaskScheduling scheduling(String string, Collection<String> collection) {
        return InlineScriptBackgroundTask.scheduling(null, string, null);
    }

    public static BackgroundTaskScheduling scheduling(String string, String string2, Collection<String> collection) {
        Object object = string2;
        if (CollectionHelper.isNotEmpty(collection)) {
            object = LIBS_START + StringHelper.join(collection, (String)",") + " !!!*/ \n" + string2;
        }
        return new BackgroundTaskScheduling(InlineScriptBackgroundTask.class, object, "Run script: \"" + (StringHelper.isNotBlank((Object)string) ? string : StringHelper.truncate((String)string2, (int)100)) + "\"");
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.RUN_INLINE_SCRIPT;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        if ((string = StringHelper.trimToNull((Object)string)) == null) {
            return 0L;
        }
        String string2 = this.getScriptCode(string);
        String string3 = StringHelper.trimToNull((Object)StringUtils.substringBetween((String)string2, (String)LIBS_START, (String)LIBS_END));
        Object object = this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            Set set = string3 == null ? null : StringHelper.split((String)string3, (String)",").stream().map(string -> StringHelper.isNumeric((String)string) ? (CustomScript)this.entityManagerHandler.find(CustomScript.class, Long.valueOf(Long.parseLong(string))) : (CustomScript)this.entityManagerHandler.find(CustomScript.class, string)).collect(Collectors.toSet());
            return this.customScriptService.runScript(string2, set);
        });
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return 1L;
    }

    protected String getScriptCode(String string) {
        return string;
    }
}

