/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.awt.color.ICC_Profile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.QImage;
import org.cyclos.impl.BaseNetworkedHandlerImpl;
import org.cyclos.impl.system.ImageHandler;
import org.cyclos.impl.system.ImageVOConverter;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.stereotype.Component;

@Component
public class ImageHandlerImpl
extends BaseNetworkedHandlerImpl
implements ImageHandler {
    private static final QImage $;

    public ImageVO build(Long l, String string, Boolean bl, String string2, Integer n, Integer n2, Integer n3, String string3, Date date) {
        if (l == null) {
            return null;
        }
        ImageVO imageVO = new ImageVO();
        imageVO.setId(l);
        imageVO.setName(string);
        imageVO.setConvertedToJpeg(Boolean.TRUE.equals(bl));
        imageVO.setContentType(string2);
        imageVO.setWidth(((Integer)ObjectHelper.defaultValue((Object)n, (Object)0)).intValue());
        imageVO.setHeight(((Integer)ObjectHelper.defaultValue((Object)n2, (Object)0)).intValue());
        imageVO.setLength(((Integer)ObjectHelper.defaultValue((Object)n3, (Object)0)).intValue());
        imageVO.setKey(ImageVOConverter.getKey(string3, n, n2, string2));
        if (date != null) {
            imageVO.setLastModified(this.conversionHandler.toDateTime(date));
            imageVO.setLastModifiedInMillis(String.valueOf(date.getTime()));
        }
        return imageVO;
    }

    public ImageVO build(Tuple tuple, QImage qImage) {
        return this.build((Long)tuple.get((Expression)qImage.id), (String)tuple.get((Expression)qImage.name), (Boolean)tuple.get((Expression)qImage.convertedToJpeg), (String)tuple.get((Expression)qImage.contentType), (Integer)tuple.get((Expression)qImage.width), (Integer)tuple.get((Expression)qImage.height), (Integer)tuple.get((Expression)qImage.length), (String)tuple.get((Expression)qImage.key), (Date)tuple.get((Expression)qImage.lastModified));
    }

    public String newKey() {
        String string;
        while (this.isUsed(string = StringHelper.randomAlphanumeric((int)64))) {
        }
        return string;
    }

    public List<Path<?>> projection(QImage qImage) {
        return Arrays.asList(qImage.id, qImage.name, qImage.convertedToJpeg, qImage.contentType, qImage.width, qImage.height, qImage.length, qImage.key, qImage.lastModified);
    }

    public ImageVO resolveImage(ImageVO imageVO) {
        return (ImageVO)CollectionHelper.first(this.resolveImages(Collections.singletonList(imageVO)));
    }

    public List<ImageVO> resolveImages(List<ImageVO> list) {
        return this.conversionHandler.convertList(ImageVO.class, (Iterable)this.conversionHandler.convertList(Image.class, list));
    }

    private boolean isUsed(String string) {
        return ((DBQuery)this.from(new EntityPath[]{$}).where((Predicate)ImageHandlerImpl.$.key.eq((Object)string))).hasResults();
    }

    static {
        ICC_Profile.getInstance(1000).getData();
        ICC_Profile.getInstance(1002).getData();
        ICC_Profile.getInstance(1003).getData();
        ICC_Profile.getInstance(1001).getData();
        ICC_Profile.getInstance(1004).getData();
        $ = QImage.image;
    }
}

