/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.collections4.CollectionUtils;
import org.cyclos.entities.system.GeneralReferenceImportedFile;
import org.cyclos.entities.system.ImportedLine;
import org.cyclos.entities.users.GeneralReference;
import org.cyclos.entities.users.User;
import org.cyclos.impl.system.BaseImportHandlerImpl;
import org.cyclos.impl.users.GeneralReferenceServiceLocal;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.ValidationException;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.imports.GeneralReferenceImportField;
import org.cyclos.model.system.imports.GeneralReferenceImportedFileDTO;
import org.cyclos.model.system.imports.GeneralReferenceImportedFileData;
import org.cyclos.model.system.imports.ImportField;
import org.cyclos.model.system.imports.ImportType;
import org.cyclos.model.system.imports.ImportedFileDTO;
import org.cyclos.model.users.references.GeneralReferenceDTO;
import org.cyclos.model.users.references.GeneralReferenceData;
import org.cyclos.model.users.references.GeneralReferenceDataParams;
import org.cyclos.model.users.references.ReferenceLevel;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GeneralReferenceImportHandlerImpl
extends BaseImportHandlerImpl<GeneralReferenceImportedFileDTO, GeneralReferenceImportedFileData, GeneralReferenceImportedFile, GeneralReference> {
    protected static final Set<String> REQUIRED_HEADERS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{GeneralReferenceImportField.FROM.getName(), GeneralReferenceImportField.TO.getName(), GeneralReferenceImportField.LEVEL.getName(), GeneralReferenceImportField.COMMENTS.getName()}));
    @Autowired
    private GeneralReferenceServiceLocal generalReferenceService;

    public GeneralReferenceImportHandlerImpl() {
        super((ImportField[])GeneralReferenceImportField.values());
    }

    public Predicate<String> getAllowedImportFieldsPredicate(GeneralReferenceImportedFile generalReferenceImportedFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GeneralReferenceImportField generalReferenceImportField : GeneralReferenceImportField.values()) {
            arrayList.add(generalReferenceImportField.getName());
        }
        return string -> arrayList.contains(string);
    }

    public GeneralReferenceImportedFileData getData(GeneralReferenceImportedFile generalReferenceImportedFile) {
        GeneralReferenceImportedFileData generalReferenceImportedFileData = new GeneralReferenceImportedFileData();
        generalReferenceImportedFileData.setDto((EntityDTO)((ImportedFileDTO)this.conversionHandler.convert(GeneralReferenceImportedFileDTO.class, (Object)generalReferenceImportedFile)));
        return generalReferenceImportedFileData;
    }

    public Class<GeneralReference> getEntityClass() {
        return GeneralReference.class;
    }

    public Class<GeneralReferenceImportedFile> getImportedFileClass() {
        return GeneralReferenceImportedFile.class;
    }

    public ImportType getImportType() {
        return ImportType.GENERAL_REFERENCES_IMPORT;
    }

    public Set<String> getMissingRequiredFields(GeneralReferenceImportedFile generalReferenceImportedFile, List<String> list) {
        return Set.copyOf(CollectionUtils.subtract(REQUIRED_HEADERS, list));
    }

    public Object instantiateContext() {
        return null;
    }

    public GeneralReferenceImportedFile newImportedFile(GeneralReferenceImportedFileDTO generalReferenceImportedFileDTO) {
        return new GeneralReferenceImportedFile();
    }

    public GeneralReference processImportedLine(ImportedLine importedLine, Object object) {
        GeneralReferenceDTO generalReferenceDTO = this.convertToDTO(importedLine);
        return (GeneralReference)this.find(this.generalReferenceService.save((EntityDTO)generalReferenceDTO));
    }

    public Validator resolveValidator(GeneralReferenceImportedFileDTO generalReferenceImportedFileDTO) {
        return new Validator();
    }

    public void validateImportedLine(ImportedLine importedLine, Object object) throws ValidationException {
        GeneralReferenceDTO generalReferenceDTO = this.convertToDTO(importedLine);
        this.generalReferenceService.validate((EntityDTO)generalReferenceDTO);
    }

    @Override
    protected List<ImportField> doGetFieldsInList(GeneralReferenceImportedFile generalReferenceImportedFile) {
        return Arrays.asList(GeneralReferenceImportField.FROM, GeneralReferenceImportField.TO, GeneralReferenceImportField.LEVEL, GeneralReferenceImportField.COMMENTS);
    }

    private GeneralReferenceDTO convertToDTO(ImportedLine importedLine) throws ValidationException {
        GeneralReferenceDataParams generalReferenceDataParams = new GeneralReferenceDataParams();
        User user = this.locateUser(importedLine.getValue((ImportField)GeneralReferenceImportField.FROM), true).getUser();
        User user2 = this.locateUser(importedLine.getValue((ImportField)GeneralReferenceImportField.TO), true).getUser();
        if (user != null) {
            generalReferenceDataParams.setFromUser(new UserLocatorVO(user.getId()));
        }
        if (user2 == null) {
            String string = this.translationHandler.message(SystemKeys.Imports.ERROR_GENERAL_REFERENCE_TO_NOT_FOUND, new Object[0]);
            throw new ValidationException(string);
        }
        generalReferenceDataParams.setToUser(new UserLocatorVO(user2.getId()));
        GeneralReferenceData generalReferenceData = (GeneralReferenceData)this.generalReferenceService.getDataForNew((Object)generalReferenceDataParams);
        GeneralReferenceDTO generalReferenceDTO = (GeneralReferenceDTO)generalReferenceData.getDto();
        generalReferenceDTO.setComments(importedLine.getValue((ImportField)GeneralReferenceImportField.COMMENTS));
        String string = importedLine.getValue((ImportField)GeneralReferenceImportField.DATE);
        generalReferenceDTO.setDate(this.parseDateTime(string));
        generalReferenceDTO.setLevel(this.parseLevel(importedLine.getValue((ImportField)GeneralReferenceImportField.LEVEL), importedLine));
        return generalReferenceDTO;
    }

    private ReferenceLevel parseLevel(String string, ImportedLine importedLine) {
        if (StringHelper.isNotBlank((Object)string)) {
            try {
                return ReferenceLevel.valueOf((String)string.toUpperCase().trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = this.translationHandler.message(SystemKeys.Imports.ERROR_GENERAL_REFERENCE_LEVEL, new Object[0]);
                throw new ValidationException(string2);
            }
        }
        return null;
    }
}

