/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.ConfigurationOrderableEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.system.CustomWizard;
import org.cyclos.entities.system.CustomWizardField;
import org.cyclos.entities.system.CustomWizardStep;
import org.cyclos.entities.system.EmailVerificationWizardStep;
import org.cyclos.entities.system.FormFieldsWizardStep;
import org.cyclos.entities.system.FormFieldsWizardStepField;
import org.cyclos.entities.system.GroupSelectionWizardStep;
import org.cyclos.entities.system.IdentityProviderWizardStep;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.PhoneVerificationWizardStep;
import org.cyclos.entities.system.QCustomWizardStep;
import org.cyclos.entities.system.RegistrationWizard;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.system.CustomWizardStepServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.wizards.CustomWizardNature;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.system.wizardsteps.CustomWizardStepDTO;
import org.cyclos.model.system.wizardsteps.CustomWizardStepData;
import org.cyclos.model.system.wizardsteps.CustomWizardStepDataParams;
import org.cyclos.model.system.wizardsteps.CustomWizardStepFieldDefinitionType;
import org.cyclos.model.system.wizardsteps.CustomWizardStepNature;
import org.cyclos.model.system.wizardsteps.CustomWizardStepVO;
import org.cyclos.model.system.wizardsteps.EmailVerificationWizardStepDTO;
import org.cyclos.model.system.wizardsteps.FormFieldsWizardStepDTO;
import org.cyclos.model.system.wizardsteps.FormFieldsWizardStepData;
import org.cyclos.model.system.wizardsteps.FormFieldsWizardStepFieldDTO;
import org.cyclos.model.system.wizardsteps.GroupSelectionWizardStepDTO;
import org.cyclos.model.system.wizardsteps.IdentityProviderWizardStepDTO;
import org.cyclos.model.system.wizardsteps.PhoneVerificationWizardStepDTO;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.ProfileField;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.stereotype.Service;

@Service
public class CustomWizardStepServiceImpl
extends CRUDServiceImpl<CustomWizardStep, QCustomWizardStep, CustomWizardStepDTO, CustomWizardStepData, CustomWizardStepDataParams>
implements CustomWizardStepServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{FormFieldsWizardStepDTO.FIELDS};
    private static final BidiMap<Class<? extends CustomWizardStep>, Class<? extends CustomWizardStepDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();

    public CustomWizardStepServiceImpl() {
        super(CustomWizardStep.class, QCustomWizardStep.customWizardStep, CustomWizardStepDTO.class);
    }

    public List<CustomWizardStepVO> list(CustomWizardVO customWizardVO) throws FrameworkException {
        CustomWizard customWizard = (CustomWizard)this.conversionHandler.convert(CustomWizard.class, (Object)customWizardVO);
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QCustomWizardStep)this.$).wizard().eq((Object)customWizard))).orderBy(((QCustomWizardStep)this.$).order.asc())).list(CustomWizardStepVO.class, (Expression)this.$);
    }

    @Override
    public CustomWizardStep newEntity(CustomWizardStepDataParams customWizardStepDataParams) {
        CustomWizard customWizard = (CustomWizard)this.conversionHandler.convert(CustomWizard.class, (Object)customWizardStepDataParams.getWizard());
        CustomWizardStepNature customWizardStepNature = customWizardStepDataParams.getNature();
        GroupSelectionWizardStep groupSelectionWizardStep = null;
        if (customWizardStepNature != null) {
            switch (customWizardStepNature) {
                case GROUP: {
                    groupSelectionWizardStep = new GroupSelectionWizardStep();
                    break;
                }
                case IDENTITY_PROVIDER: {
                    groupSelectionWizardStep = new IdentityProviderWizardStep();
                    break;
                }
                case FORM_FIELDS: {
                    groupSelectionWizardStep = new FormFieldsWizardStep();
                    break;
                }
                case EMAIL_VERIFICATION: {
                    groupSelectionWizardStep = new EmailVerificationWizardStep();
                    break;
                }
                case PHONE_VERIFICATION: {
                    groupSelectionWizardStep = new PhoneVerificationWizardStep();
                }
            }
        }
        if (groupSelectionWizardStep == null) {
            throw new IllegalActionException("Invalid nature: " + String.valueOf(customWizardStepNature));
        }
        groupSelectionWizardStep.setWizard(customWizard);
        if (customWizard instanceof RegistrationWizard) {
            groupSelectionWizardStep.setName(this.message(groupSelectionWizardStep.getNature().getMessageKey(), new Object[0]));
        }
        return groupSelectionWizardStep;
    }

    @Override
    public CustomWizardStep toEntity(CustomWizardStepDTO customWizardStepDTO) {
        CustomWizardStep customWizardStep = (CustomWizardStep)super.toEntity(customWizardStepDTO);
        if (customWizardStep instanceof FormFieldsWizardStep) {
            FormFieldsWizardStep formFieldsWizardStep = (FormFieldsWizardStep)customWizardStep;
            FormFieldsWizardStepDTO formFieldsWizardStepDTO = (FormFieldsWizardStepDTO)customWizardStepDTO;
            CollectionHelper.orEmpty((List)formFieldsWizardStep.getFields()).forEach(iEntity -> this.remove(iEntity));
            List list = this.conversionHandler.convertList(FormFieldsWizardStepField.class, (Iterable)formFieldsWizardStepDTO.getFields());
            for (int i = 0; i < list.size(); ++i) {
                FormFieldsWizardStepField formFieldsWizardStepField = (FormFieldsWizardStepField)list.get(i);
                formFieldsWizardStepField.setStep(formFieldsWizardStep);
                formFieldsWizardStepField.setOrder(Integer.valueOf(i));
                if (!formFieldsWizardStepField.getType().supportsReadOnly()) {
                    formFieldsWizardStepField.setReadOnly(false);
                }
                if (formFieldsWizardStepField.getBasicProfileField() == BasicProfileField.EMAIL || formFieldsWizardStepField.getPhoneNature() == PhoneNature.MOBILE) continue;
                formFieldsWizardStepField.setRequireVerification(false);
            }
            formFieldsWizardStep.setTransientFields(list);
        }
        return customWizardStep;
    }

    @Override
    protected void addCustomInternalNameValidations(org.cyclos.impl.utils.validation.Property property, CustomWizardStepDTO customWizardStepDTO) {
        property.noneOf(new Object[]{"next"});
    }

    @Override
    protected CustomWizardStepData getData(CustomWizardStep customWizardStep) {
        CustomWizardStepData customWizardStepData;
        FormFieldsWizardStepData formFieldsWizardStepData;
        if (customWizardStep instanceof FormFieldsWizardStep) {
            formFieldsWizardStepData = new FormFieldsWizardStepData();
            formFieldsWizardStepData.setGroups(this.groupsHandler.accessibles().basicUsers().sorted());
            formFieldsWizardStepData.setAllFields(this.getAllFields(customWizardStep.getWizard()));
            customWizardStepData = formFieldsWizardStepData;
        } else {
            customWizardStepData = new CustomWizardStepData();
        }
        customWizardStepData.setNature(customWizardStep.getNature());
        formFieldsWizardStepData = (CustomWizardStepDTO)this.toDTO(customWizardStep);
        customWizardStepData.setDto((EntityDTO)formFieldsWizardStepData);
        if (formFieldsWizardStepData instanceof FormFieldsWizardStepDTO) {
            FormFieldsWizardStepData formFieldsWizardStepData2 = (FormFieldsWizardStepData)customWizardStepData;
            FormFieldsWizardStepDTO formFieldsWizardStepDTO = (FormFieldsWizardStepDTO)formFieldsWizardStepData;
            formFieldsWizardStepDTO.getFields().forEach(formFieldsWizardStepFieldDTO -> formFieldsWizardStepData2.getAllFields().stream().filter(formFieldsWizardStepFieldDTO2 -> formFieldsWizardStepFieldDTO2.equals(formFieldsWizardStepFieldDTO)).findFirst().ifPresent(formFieldsWizardStepFieldDTO2 -> formFieldsWizardStepFieldDTO.setDisplay(formFieldsWizardStepFieldDTO2.getDisplay())));
        }
        return customWizardStepData;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(CustomWizardStepDTO customWizardStepDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onAfterSave(CustomWizardStep customWizardStep, CustomWizardStep customWizardStep2, Object object) {
        if (customWizardStep instanceof FormFieldsWizardStep) {
            FormFieldsWizardStep formFieldsWizardStep = (FormFieldsWizardStep)customWizardStep;
            formFieldsWizardStep.getTransientFields().forEach(iEntity -> this.persist((IEntity)iEntity));
            formFieldsWizardStep.setFields(formFieldsWizardStep.getTransientFields());
        }
    }

    @Override
    protected Object onBeforeSave(CustomWizardStep customWizardStep, CustomWizardStep customWizardStep2) {
        CustomWizard customWizard = customWizardStep.getWizard();
        if (!customWizardStep.getNature().wizardNatures().contains(customWizard.getNature())) {
            throw new IllegalActionException("Step isn't compatible with wizard: " + String.valueOf(customWizardStep) + ", " + String.valueOf(customWizard));
        }
        if (customWizardStep instanceof FormFieldsWizardStep) {
            FormFieldsWizardStep formFieldsWizardStep = (FormFieldsWizardStep)customWizardStep;
            if (customWizard.getNature() != CustomWizardNature.REGISTRATION) {
                formFieldsWizardStep.setFieldVisibility(false);
                formFieldsWizardStep.setGroups(null);
            }
        }
        if (customWizardStep2 == null) {
            customWizardStep.setOrder(Integer.valueOf(customWizard.getSteps().stream().map(ConfigurationOrderableEntity::getOrder).collect(Collectors.maxBy(Comparator.naturalOrder())).orElse(0) + 1));
            customWizard.getSteps().add(customWizardStep);
        }
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(CustomWizardStepDTO customWizardStepDTO, CustomWizardStep customWizardStep) {
        if (customWizardStep instanceof FormFieldsWizardStep) {
            ((FormFieldsWizardStep)customWizardStep).getFields().size();
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QCustomWizardStep)this.$).wizard().network());
    }

    @Override
    protected Validator resolveValidator(final CustomWizardStepDTO customWizardStepDTO) {
        CustomWizard customWizard;
        Validator validator = new Validator();
        if (customWizardStepDTO.isTransient()) {
            customWizard = (CustomWizard)this.conversionHandler.convert(CustomWizard.class, (Object)customWizardStepDTO.getWizard());
            validator.property((Property)CustomWizardStepDTO.WIZARD, SystemKeys.WizardSteps.WIZARD).required();
            if (customWizard == null) {
                return validator;
            }
        } else {
            customWizard = ((CustomWizardStep)this.find(customWizardStepDTO.getId())).getWizard();
        }
        if (customWizardStepDTO instanceof FormFieldsWizardStepDTO) {
            validator.property((Property)FormFieldsWizardStepDTO.FIELDS, SystemKeys.WizardSteps.FIELDS).add((PropertyValidation)new BasePropertyValidation(){

                protected boolean isValid(Object object, Object object2, Object object3) {
                    List list = ((FormFieldsWizardStepDTO)customWizardStepDTO).getFields();
                    if (CollectionHelper.isEmpty((Iterable)list)) {
                        return true;
                    }
                    return list.stream().allMatch(formFieldsWizardStepFieldDTO -> CustomWizardStepServiceImpl.this.isValid(customWizard, (FormFieldsWizardStepFieldDTO)formFieldsWizardStepFieldDTO));
                }
            });
            List list = CollectionHelper.orEmpty((List)((FormFieldsWizardStepDTO)customWizardStepDTO).getFields());
            if (list.stream().anyMatch(formFieldsWizardStepFieldDTO -> formFieldsWizardStepFieldDTO.isReadOnly() && formFieldsWizardStepFieldDTO.isRequireVerification())) {
                validator.general(GeneralValidations.invalid((MessageKey)SystemKeys.WizardSteps.FIELDS_ERROR_READ_ONLY_AND_VERIFICATION, (Object[])new Object[0]));
            }
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends CustomWizardStep>, Class<? extends CustomWizardStepDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private List<FormFieldsWizardStepFieldDTO> getAllFields(CustomWizard customWizard) {
        FormFieldsWizardStepFieldDTO formFieldsWizardStepFieldDTO;
        boolean bl;
        SessionData sessionData = this.getSessionData();
        Language language = sessionData.getConfiguration().getLanguage();
        ArrayList<FormFieldsWizardStepFieldDTO> arrayList = new ArrayList<FormFieldsWizardStepFieldDTO>();
        boolean bl2 = bl = customWizard.getNature() == CustomWizardNature.REGISTRATION;
        if (bl) {
            for (ProfileField customWizardField : this.profileFieldHandler.getAllProfileFields()) {
                FormFieldsWizardStepFieldDTO formFieldsWizardStepFieldDTO2;
                if (customWizardField == BasicProfileField.ACCOUNT_NUMBER) continue;
                if (customWizardField == BasicProfileField.PHONE) {
                    formFieldsWizardStepFieldDTO = new FormFieldsWizardStepFieldDTO();
                    formFieldsWizardStepFieldDTO.setType(CustomWizardStepFieldDefinitionType.BASIC_PROFILE_FIELD);
                    formFieldsWizardStepFieldDTO.setBasicProfileField(BasicProfileField.PHONE);
                    formFieldsWizardStepFieldDTO.setPhoneNature(PhoneNature.MOBILE);
                    formFieldsWizardStepFieldDTO.setDisplay(this.message(language, UsersKeys.Users.MOBILE_PHONE, new Object[0]));
                    arrayList.add(formFieldsWizardStepFieldDTO);
                    formFieldsWizardStepFieldDTO2 = new FormFieldsWizardStepFieldDTO();
                    formFieldsWizardStepFieldDTO2.setType(CustomWizardStepFieldDefinitionType.BASIC_PROFILE_FIELD);
                    formFieldsWizardStepFieldDTO2.setBasicProfileField(BasicProfileField.PHONE);
                    formFieldsWizardStepFieldDTO2.setPhoneNature(PhoneNature.LANDLINE);
                    formFieldsWizardStepFieldDTO2.setDisplay(this.message(language, UsersKeys.Users.LAND_LINE_PHONE, new Object[0]));
                    arrayList.add(formFieldsWizardStepFieldDTO2);
                    continue;
                }
                if (customWizardField instanceof BasicProfileField) {
                    formFieldsWizardStepFieldDTO = (BasicProfileField)customWizardField;
                    formFieldsWizardStepFieldDTO2 = new FormFieldsWizardStepFieldDTO();
                    formFieldsWizardStepFieldDTO2.setType(CustomWizardStepFieldDefinitionType.BASIC_PROFILE_FIELD);
                    formFieldsWizardStepFieldDTO2.setBasicProfileField((BasicProfileField)formFieldsWizardStepFieldDTO);
                    formFieldsWizardStepFieldDTO2.setDisplay(this.message(language, formFieldsWizardStepFieldDTO.getMessageKey(), new Object[0]));
                    arrayList.add(formFieldsWizardStepFieldDTO2);
                    continue;
                }
                if (!(customWizardField instanceof UserCustomField)) continue;
                formFieldsWizardStepFieldDTO = (UserCustomField)customWizardField;
                formFieldsWizardStepFieldDTO2 = new FormFieldsWizardStepFieldDTO();
                formFieldsWizardStepFieldDTO2.setType(CustomWizardStepFieldDefinitionType.CUSTOM_PROFILE_FIELD);
                formFieldsWizardStepFieldDTO2.setCustomProfileField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, (Object)formFieldsWizardStepFieldDTO));
                formFieldsWizardStepFieldDTO2.setDisplay(this.dataTranslationHandler.getName(language, (NamedEntity)formFieldsWizardStepFieldDTO));
                arrayList.add(formFieldsWizardStepFieldDTO2);
            }
        }
        for (CustomWizardField customWizardField : customWizard.getCustomFields()) {
            formFieldsWizardStepFieldDTO = new FormFieldsWizardStepFieldDTO();
            formFieldsWizardStepFieldDTO.setType(CustomWizardStepFieldDefinitionType.WIZARD_FIELD);
            formFieldsWizardStepFieldDTO.setWizardField((CustomFieldVO)this.conversionHandler.convert(CustomFieldVO.class, (Object)customWizardField));
            formFieldsWizardStepFieldDTO.setDisplay(this.dataTranslationHandler.getName(language, (NamedEntity)customWizardField));
            arrayList.add(formFieldsWizardStepFieldDTO);
        }
        if (bl) {
            for (CustomWizardStepFieldDefinitionType customWizardStepFieldDefinitionType : EnumSet.of(CustomWizardStepFieldDefinitionType.CONTACT_INFO, CustomWizardStepFieldDefinitionType.PASSWORDS, CustomWizardStepFieldDefinitionType.SECURITY_QUESTION, CustomWizardStepFieldDefinitionType.AGREEMENTS, CustomWizardStepFieldDefinitionType.CAPTCHA)) {
                formFieldsWizardStepFieldDTO = new FormFieldsWizardStepFieldDTO();
                formFieldsWizardStepFieldDTO.setType(customWizardStepFieldDefinitionType);
                formFieldsWizardStepFieldDTO.setDisplay(this.message(language, customWizardStepFieldDefinitionType.getMessageKey(), new Object[0]));
                arrayList.add(formFieldsWizardStepFieldDTO);
            }
        }
        return arrayList;
    }

    private boolean isValid(CustomWizard customWizard, FormFieldsWizardStepFieldDTO formFieldsWizardStepFieldDTO) {
        boolean bl;
        CustomWizardStepFieldDefinitionType customWizardStepFieldDefinitionType = formFieldsWizardStepFieldDTO.getType();
        if (customWizardStepFieldDefinitionType == null) {
            return false;
        }
        boolean bl2 = bl = customWizard.getNature() == CustomWizardNature.REGISTRATION;
        if (!bl && customWizardStepFieldDefinitionType != CustomWizardStepFieldDefinitionType.WIZARD_FIELD) {
            return false;
        }
        switch (customWizardStepFieldDefinitionType) {
            case BASIC_PROFILE_FIELD: {
                BasicProfileField basicProfileField = formFieldsWizardStepFieldDTO.getBasicProfileField();
                return basicProfileField != null && basicProfileField != BasicProfileField.ACCOUNT_NUMBER && (basicProfileField != BasicProfileField.PHONE || formFieldsWizardStepFieldDTO.getPhoneNature() != null);
            }
            case CUSTOM_PROFILE_FIELD: {
                UserCustomField userCustomField = (UserCustomField)this.conversionHandler.convert(UserCustomField.class, (Object)formFieldsWizardStepFieldDTO.getCustomProfileField());
                return userCustomField != null;
            }
            case WIZARD_FIELD: {
                CustomWizardField customWizardField = (CustomWizardField)this.conversionHandler.convert(CustomWizardField.class, (Object)formFieldsWizardStepFieldDTO.getWizardField());
                return customWizardField != null && customWizard.equals((Object)customWizardField.getWizard());
            }
        }
        return true;
    }

    static {
        SUBCLASS_MAPPINGS.put(GroupSelectionWizardStep.class, GroupSelectionWizardStepDTO.class);
        SUBCLASS_MAPPINGS.put(IdentityProviderWizardStep.class, IdentityProviderWizardStepDTO.class);
        SUBCLASS_MAPPINGS.put(FormFieldsWizardStep.class, FormFieldsWizardStepDTO.class);
        SUBCLASS_MAPPINGS.put(EmailVerificationWizardStep.class, EmailVerificationWizardStepDTO.class);
        SUBCLASS_MAPPINGS.put(PhoneVerificationWizardStep.class, PhoneVerificationWizardStepDTO.class);
    }
}

