/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.system.CustomWizardStep;
import org.cyclos.entities.system.EmailVerificationWizardStep;
import org.cyclos.entities.system.FormFieldsWizardStep;
import org.cyclos.entities.system.GroupSelectionWizardStep;
import org.cyclos.entities.system.IdentityProviderWizardStep;
import org.cyclos.entities.system.PhoneVerificationWizardStep;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.PropertyLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.wizardsteps.CustomWizardStepDTO;
import org.cyclos.model.system.wizardsteps.EmailVerificationWizardStepDTO;
import org.cyclos.model.system.wizardsteps.FormFieldsWizardStepDTO;
import org.cyclos.model.system.wizardsteps.GroupSelectionWizardStepDTO;
import org.cyclos.model.system.wizardsteps.IdentityProviderWizardStepDTO;
import org.cyclos.model.system.wizardsteps.PhoneVerificationWizardStepDTO;
import org.cyclos.security.system.CustomWizardStepServiceSecurity;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class CustomWizardStepEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<CustomWizardStep, CustomWizardStepDTO> {
    @Autowired
    @Lazy
    private CustomWizardStepServiceSecurity customWizardStepServiceSecurity;

    public Class<CustomWizardStep> getEntityClass() {
        return CustomWizardStep.class;
    }

    public EntityLogType getType() {
        return EntityLogType.CUSTOM_WIZARD_STEP;
    }

    @Override
    public Pair<Object, Object> getValues(CustomWizardStep customWizardStep, CustomWizardStep customWizardStep2, PropertyLogDescriptor<CustomWizardStepDTO> propertyLogDescriptor) {
        if (FormFieldsWizardStepDTO.FIELDS.getName().equals(propertyLogDescriptor.getAccess().getPropertyName())) {
            return Pair.create((Object)this.formatFields(customWizardStep), (Object)this.formatFields(customWizardStep2));
        }
        return null;
    }

    public EntityLogDescriptor<? extends CustomWizardStepDTO> resolveLogDescriptor(CustomWizardStep customWizardStep) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDtoType(customWizardStep)).property(CustomWizardStepDTO.NAME, GeneralKeys.Ui.NAME).property(CustomWizardStepDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property(CustomWizardStepDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property((Property)CustomWizardStepDTO.INFORMATION_TEXT, SystemKeys.WizardSteps.INFORMATION_TEXT).property((Property)CustomWizardStepDTO.CONTENT_SCRIPT, GeneralKeys.Ui.CONTENT_SCRIPT).property((Property)CustomWizardStepDTO.CONTENT_SCRIPT_PARAMETERS, GeneralKeys.Ui.CONTENT_SCRIPT_PARAMETERS).property((Property)CustomWizardStepDTO.TITLE, SystemKeys.WizardSteps.TITLE).property((Property)CustomWizardStepDTO.WIZARD, SystemKeys.WizardSteps.WIZARD);
        if (customWizardStep instanceof FormFieldsWizardStep) {
            entityLogDescriptor.cast().property((Property)FormFieldsWizardStepDTO.FIELDS, SystemKeys.WizardSteps.FIELDS).property((Property)FormFieldsWizardStepDTO.GROUPS, SystemKeys.WizardSteps.GROUPS).property((Property)FormFieldsWizardStepDTO.FIELD_VISIBILITY, SystemKeys.WizardSteps.FIELD_VISIBILITY).property((Property)FormFieldsWizardStepDTO.EXTERNAL_REDIRECT, SystemKeys.WizardSteps.EXTERNAL_REDIRECT);
        }
        return entityLogDescriptor;
    }

    @Override
    protected CustomWizardStep getEntityToViewLog(long l) {
        CustomWizardStep customWizardStep = this.find(CustomWizardStep.class, l);
        if (this.customWizardStepServiceSecurity.canPerformOperation((SimpleEntity)customWizardStep, CRUDOperation.READ)) {
            return customWizardStep;
        }
        return null;
    }

    private Object formatFields(CustomWizardStep customWizardStep) {
        if (customWizardStep == null) {
            return null;
        }
        FormFieldsWizardStep formFieldsWizardStep = (FormFieldsWizardStep)customWizardStep;
        return CollectionHelper.orEmpty((List)formFieldsWizardStep.getFields()).stream().map(formFieldsWizardStepField -> {
            String string = this.getFormatter().format(formFieldsWizardStepField.getIdentity());
            if (formFieldsWizardStepField.isReadOnly()) {
                string = this.message(SystemKeys.WizardSteps.FIELDS_MARKER_READONLY, string);
            }
            if (formFieldsWizardStepField.isRequireVerification()) {
                string = this.message(SystemKeys.WizardSteps.FIELDS_MARKER_REQUIRE_VERIFICATION, string);
            }
            return string;
        }).collect(Collectors.joining(", "));
    }

    private Class<? extends CustomWizardStepDTO> resolveDtoType(CustomWizardStep customWizardStep) {
        if (customWizardStep instanceof FormFieldsWizardStep) {
            return FormFieldsWizardStepDTO.class;
        }
        if (customWizardStep instanceof GroupSelectionWizardStep) {
            return GroupSelectionWizardStepDTO.class;
        }
        if (customWizardStep instanceof IdentityProviderWizardStep) {
            return IdentityProviderWizardStepDTO.class;
        }
        if (customWizardStep instanceof EmailVerificationWizardStep) {
            return EmailVerificationWizardStepDTO.class;
        }
        if (customWizardStep instanceof PhoneVerificationWizardStep) {
            return PhoneVerificationWizardStepDTO.class;
        }
        return null;
    }
}

