/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.system;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.List;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.CustomOperationAction;
import org.cyclos.entities.system.CustomOperationField;
import org.cyclos.entities.system.QCustomOperationAction;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.system.CustomOperationActionServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.operations.CustomOperationActionDTO;
import org.cyclos.model.system.operations.CustomOperationActionData;
import org.cyclos.model.system.operations.CustomOperationActionDataParams;
import org.cyclos.model.system.operations.CustomOperationActionParameterDTO;
import org.cyclos.model.system.operations.CustomOperationActionVO;
import org.cyclos.model.system.operations.CustomOperationActionVisibility;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.operations.CustomOperationWithParametersVO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.stereotype.Service;

@Service
public class CustomOperationActionServiceImpl
extends CRUDServiceImpl<CustomOperationAction, QCustomOperationAction, CustomOperationActionDTO, CustomOperationActionData, CustomOperationActionDataParams>
implements CustomOperationActionServiceLocal {
    public CustomOperationActionServiceImpl() {
        super(CustomOperationAction.class, QCustomOperationAction.customOperationAction, CustomOperationActionDTO.class);
    }

    public List<CustomOperationActionVO> list(CustomOperationVO customOperationVO) throws FrameworkException {
        CustomOperation customOperation = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationVO);
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QCustomOperationAction)this.$).ownerOperation().eq((Object)customOperation))).orderBy(new OrderSpecifier[]{((QCustomOperationAction)this.$).order.asc(), ((QCustomOperationAction)this.$).actionOperation().name.asc()})).list(CustomOperationActionVO.class, (Expression)this.$);
    }

    @Override
    public CustomOperationAction newEntity(CustomOperationActionDataParams customOperationActionDataParams) {
        CustomOperation customOperation = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationActionDataParams.getOwnerOperation());
        CustomOperation customOperation2 = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationActionDataParams.getActionOperation());
        CustomOperationAction customOperationAction = new CustomOperationAction();
        customOperationAction.setActionOperation(customOperation2);
        customOperationAction.setOwnerOperation(customOperation);
        customOperationAction.setVisibility(CustomOperationActionVisibility.AFTER_RUN);
        return customOperationAction;
    }

    @Override
    protected CustomOperationActionData getData(CustomOperationAction customOperationAction) {
        CustomOperationActionData customOperationActionData = new CustomOperationActionData();
        customOperationActionData.setDto((EntityDTO)((CustomOperationActionDTO)this.toDTO(customOperationAction)));
        customOperationActionData.setActionOperation((CustomOperationWithParametersVO)this.conversionHandler.convert(CustomOperationWithParametersVO.class, (Object)customOperationAction.getActionOperation()));
        customOperationActionData.setOwnerOperation((CustomOperationWithParametersVO)this.conversionHandler.convert(CustomOperationWithParametersVO.class, (Object)customOperationAction.getOwnerOperation()));
        return customOperationActionData;
    }

    @Override
    protected void onAfterRemove(CustomOperationAction customOperationAction) {
        customOperationAction.getOwnerOperation().getActions().remove(customOperationAction);
    }

    @Override
    protected void onAfterSave(CustomOperationAction customOperationAction, CustomOperationAction customOperationAction2, Object object) {
        if (customOperationAction2 == null) {
            customOperationAction.getOwnerOperation().getActions().add(customOperationAction);
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QCustomOperationAction)this.$).ownerOperation().network());
    }

    @Override
    protected Validator resolveValidator(CustomOperationActionDTO customOperationActionDTO) {
        Validator validator = new Validator();
        validator.property((Property)CustomOperationActionDTO.ACTION_OPERATION, SystemKeys.Operations.ACTIONS_ACTION_OPERATION).required();
        validator.property((Property)CustomOperationActionDTO.OWNER_OPERATION, SystemKeys.Operations.ACTIONS_OWNER_OPERATION).required();
        validator.property((Property)CustomOperationActionDTO.VISIBILITY, SystemKeys.Operations.ACTIONS_VISIBILITY).required();
        if (CollectionHelper.isNotEmpty((Iterable)customOperationActionDTO.getParameters())) {
            CustomOperation customOperation = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationActionDTO.getActionOperation());
            CustomOperation customOperation2 = (CustomOperation)this.conversionHandler.convert(CustomOperation.class, (Object)customOperationActionDTO.getOwnerOperation());
            validator.general(object -> {
                for (CustomOperationActionParameterDTO customOperationActionParameterDTO : customOperationActionDTO.getParameters()) {
                    CustomOperationField customOperationField = (CustomOperationField)this.conversionHandler.convert(CustomOperationField.class, (Object)customOperationActionParameterDTO.getActionField());
                    if (!customOperation.getFormParameters().contains(customOperationField)) {
                        return new ValidationError(SystemKeys.Operations.ACTIONS_ERROR_INVALID_PARAMETERS, new Object[]{customOperationField, customOperation});
                    }
                    customOperationField = (CustomOperationField)this.conversionHandler.convert(CustomOperationField.class, (Object)customOperationActionParameterDTO.getOwnerField());
                    if (customOperationField == null || customOperation2.getFormParameters().contains(customOperationField)) continue;
                    return new ValidationError(SystemKeys.Operations.ACTIONS_ERROR_INVALID_PARAMETERS, new Object[]{customOperationField, customOperation2});
                }
                return null;
            });
        }
        return validator;
    }
}

